/*
 * Shopware Store API
 * This endpoint reference contains an overview of all endpoints comprising the Shopware Store API
 *
 * The version of the OpenAPI document: 6.5.7.3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package de.codebarista.shopware.model.core;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.openapitools.jackson.nullable.JsonNullable;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * Added since version: 6.1.0.0
 */
@JsonPropertyOrder({
  MainCategoryJsonApi.JSON_PROPERTY_TYPE,
  MainCategoryJsonApi.JSON_PROPERTY_ID,
  MainCategoryJsonApi.JSON_PROPERTY_ATTRIBUTES,
  MainCategoryJsonApi.JSON_PROPERTY_RELATIONSHIPS,
  MainCategoryJsonApi.JSON_PROPERTY_LINKS,
  MainCategoryJsonApi.JSON_PROPERTY_META,
  MainCategoryJsonApi.JSON_PROPERTY_PRODUCT_ID,
  MainCategoryJsonApi.JSON_PROPERTY_PRODUCT_VERSION_ID,
  MainCategoryJsonApi.JSON_PROPERTY_CATEGORY_ID,
  MainCategoryJsonApi.JSON_PROPERTY_CATEGORY_VERSION_ID,
  MainCategoryJsonApi.JSON_PROPERTY_SALES_CHANNEL_ID,
  MainCategoryJsonApi.JSON_PROPERTY_CREATED_AT,
  MainCategoryJsonApi.JSON_PROPERTY_UPDATED_AT
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-10T11:26:02.541008353+02:00[Europe/Berlin]", comments = "Generator version: 7.5.0")
public class MainCategoryJsonApi {
  public static final String JSON_PROPERTY_TYPE = "type";
  private String type;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
  private Map<String, Object> attributes = new HashMap<>();

  public static final String JSON_PROPERTY_RELATIONSHIPS = "relationships";
  private JsonNullable<Relationships> relationships = JsonNullable.<Relationships>undefined();

  public static final String JSON_PROPERTY_LINKS = "links";
  private Map<String, Link> links = new HashMap<>();

  public static final String JSON_PROPERTY_META = "meta";
  private Map<String, Object> meta = new HashMap<>();

  public static final String JSON_PROPERTY_PRODUCT_ID = "productId";
  private String productId;

  public static final String JSON_PROPERTY_PRODUCT_VERSION_ID = "productVersionId";
  private String productVersionId;

  public static final String JSON_PROPERTY_CATEGORY_ID = "categoryId";
  private String categoryId;

  public static final String JSON_PROPERTY_CATEGORY_VERSION_ID = "categoryVersionId";
  private String categoryVersionId;

  public static final String JSON_PROPERTY_SALES_CHANNEL_ID = "salesChannelId";
  private String salesChannelId;

  public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
  private OffsetDateTime createdAt;

  public static final String JSON_PROPERTY_UPDATED_AT = "updatedAt";
  private OffsetDateTime updatedAt;

  public MainCategoryJsonApi() {
  }

  @JsonCreator
  public MainCategoryJsonApi(
    @JsonProperty(JSON_PROPERTY_CREATED_AT) OffsetDateTime createdAt, 
    @JsonProperty(JSON_PROPERTY_UPDATED_AT) OffsetDateTime updatedAt
  ) {
    this();
    this.createdAt = createdAt;
    this.updatedAt = updatedAt;
  }

  public MainCategoryJsonApi type(String type) {
    
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(String type) {
    this.type = type;
  }


  public MainCategoryJsonApi id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setId(String id) {
    this.id = id;
  }


  public MainCategoryJsonApi attributes(Map<String, Object> attributes) {
    
    this.attributes = attributes;
    return this;
  }

  public MainCategoryJsonApi putAttributesItem(String key, Object attributesItem) {
    if (this.attributes == null) {
      this.attributes = new HashMap<>();
    }
    this.attributes.put(key, attributesItem);
    return this;
  }

   /**
   * Members of the attributes object (\&quot;attributes\&quot;) represent information about the resource object in which it&#39;s defined.
   * @return attributes
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ATTRIBUTES)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Object> getAttributes() {
    return attributes;
  }


  @JsonProperty(JSON_PROPERTY_ATTRIBUTES)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)
  public void setAttributes(Map<String, Object> attributes) {
    this.attributes = attributes;
  }


  public MainCategoryJsonApi relationships(Relationships relationships) {
    this.relationships = JsonNullable.<Relationships>of(relationships);
    
    return this;
  }

   /**
   * Get relationships
   * @return relationships
  **/
  @jakarta.annotation.Nullable
  @JsonIgnore

  public Relationships getRelationships() {
        return relationships.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_RELATIONSHIPS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Relationships> getRelationships_JsonNullable() {
    return relationships;
  }
  
  @JsonProperty(JSON_PROPERTY_RELATIONSHIPS)
  public void setRelationships_JsonNullable(JsonNullable<Relationships> relationships) {
    this.relationships = relationships;
  }

  public void setRelationships(Relationships relationships) {
    this.relationships = JsonNullable.<Relationships>of(relationships);
  }


  public MainCategoryJsonApi links(Map<String, Link> links) {
    
    this.links = links;
    return this;
  }

  public MainCategoryJsonApi putLinksItem(String key, Link linksItem) {
    if (this.links == null) {
      this.links = new HashMap<>();
    }
    this.links.put(key, linksItem);
    return this;
  }

   /**
   * Get links
   * @return links
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Link> getLinks() {
    return links;
  }


  @JsonProperty(JSON_PROPERTY_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLinks(Map<String, Link> links) {
    this.links = links;
  }


  public MainCategoryJsonApi meta(Map<String, Object> meta) {
    
    this.meta = meta;
    return this;
  }

  public MainCategoryJsonApi putMetaItem(String key, Object metaItem) {
    if (this.meta == null) {
      this.meta = new HashMap<>();
    }
    this.meta.put(key, metaItem);
    return this;
  }

   /**
   * Non-standard meta-information that can not be represented as an attribute or relationship.
   * @return meta
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_META)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Object> getMeta() {
    return meta;
  }


  @JsonProperty(JSON_PROPERTY_META)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)
  public void setMeta(Map<String, Object> meta) {
    this.meta = meta;
  }


  public MainCategoryJsonApi productId(String productId) {
    
    this.productId = productId;
    return this;
  }

   /**
   * Get productId
   * @return productId
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_PRODUCT_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getProductId() {
    return productId;
  }


  @JsonProperty(JSON_PROPERTY_PRODUCT_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setProductId(String productId) {
    this.productId = productId;
  }


  public MainCategoryJsonApi productVersionId(String productVersionId) {
    
    this.productVersionId = productVersionId;
    return this;
  }

   /**
   * Get productVersionId
   * @return productVersionId
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PRODUCT_VERSION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProductVersionId() {
    return productVersionId;
  }


  @JsonProperty(JSON_PROPERTY_PRODUCT_VERSION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProductVersionId(String productVersionId) {
    this.productVersionId = productVersionId;
  }


  public MainCategoryJsonApi categoryId(String categoryId) {
    
    this.categoryId = categoryId;
    return this;
  }

   /**
   * Get categoryId
   * @return categoryId
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_CATEGORY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCategoryId() {
    return categoryId;
  }


  @JsonProperty(JSON_PROPERTY_CATEGORY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCategoryId(String categoryId) {
    this.categoryId = categoryId;
  }


  public MainCategoryJsonApi categoryVersionId(String categoryVersionId) {
    
    this.categoryVersionId = categoryVersionId;
    return this;
  }

   /**
   * Get categoryVersionId
   * @return categoryVersionId
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CATEGORY_VERSION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCategoryVersionId() {
    return categoryVersionId;
  }


  @JsonProperty(JSON_PROPERTY_CATEGORY_VERSION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCategoryVersionId(String categoryVersionId) {
    this.categoryVersionId = categoryVersionId;
  }


  public MainCategoryJsonApi salesChannelId(String salesChannelId) {
    
    this.salesChannelId = salesChannelId;
    return this;
  }

   /**
   * Get salesChannelId
   * @return salesChannelId
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_SALES_CHANNEL_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSalesChannelId() {
    return salesChannelId;
  }


  @JsonProperty(JSON_PROPERTY_SALES_CHANNEL_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSalesChannelId(String salesChannelId) {
    this.salesChannelId = salesChannelId;
  }


   /**
   * Get createdAt
   * @return createdAt
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }




   /**
   * Get updatedAt
   * @return updatedAt
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getUpdatedAt() {
    return updatedAt;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MainCategoryJsonApi mainCategoryJsonApi = (MainCategoryJsonApi) o;
    return Objects.equals(this.type, mainCategoryJsonApi.type) &&
        Objects.equals(this.id, mainCategoryJsonApi.id) &&
        Objects.equals(this.attributes, mainCategoryJsonApi.attributes) &&
        equalsNullable(this.relationships, mainCategoryJsonApi.relationships) &&
        Objects.equals(this.links, mainCategoryJsonApi.links) &&
        Objects.equals(this.meta, mainCategoryJsonApi.meta) &&
        Objects.equals(this.productId, mainCategoryJsonApi.productId) &&
        Objects.equals(this.productVersionId, mainCategoryJsonApi.productVersionId) &&
        Objects.equals(this.categoryId, mainCategoryJsonApi.categoryId) &&
        Objects.equals(this.categoryVersionId, mainCategoryJsonApi.categoryVersionId) &&
        Objects.equals(this.salesChannelId, mainCategoryJsonApi.salesChannelId) &&
        Objects.equals(this.createdAt, mainCategoryJsonApi.createdAt) &&
        Objects.equals(this.updatedAt, mainCategoryJsonApi.updatedAt);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, id, attributes, hashCodeNullable(relationships), links, meta, productId, productVersionId, categoryId, categoryVersionId, salesChannelId, createdAt, updatedAt);
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MainCategoryJsonApi {\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    attributes: ").append(toIndentedString(attributes)).append("\n");
    sb.append("    relationships: ").append(toIndentedString(relationships)).append("\n");
    sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("    meta: ").append(toIndentedString(meta)).append("\n");
    sb.append("    productId: ").append(toIndentedString(productId)).append("\n");
    sb.append("    productVersionId: ").append(toIndentedString(productVersionId)).append("\n");
    sb.append("    categoryId: ").append(toIndentedString(categoryId)).append("\n");
    sb.append("    categoryVersionId: ").append(toIndentedString(categoryVersionId)).append("\n");
    sb.append("    salesChannelId: ").append(toIndentedString(salesChannelId)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

