/*
 * Shopware Store API
 * This endpoint reference contains an overview of all endpoints comprising the Shopware Store API
 *
 * The version of the OpenAPI document: 6.5.7.3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package de.codebarista.shopware.model.core;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonNode;

import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * Added since version: 6.0.0.0
 */
@JsonPropertyOrder({
  Order.JSON_PROPERTY_ID,
  Order.JSON_PROPERTY_VERSION_ID,
  Order.JSON_PROPERTY_ORDER_NUMBER,
  Order.JSON_PROPERTY_BILLING_ADDRESS_ID,
  Order.JSON_PROPERTY_BILLING_ADDRESS_VERSION_ID,
  Order.JSON_PROPERTY_CURRENCY_ID,
  Order.JSON_PROPERTY_LANGUAGE_ID,
  Order.JSON_PROPERTY_SALES_CHANNEL_ID,
  Order.JSON_PROPERTY_ORDER_DATE_TIME,
  Order.JSON_PROPERTY_ORDER_DATE,
  Order.JSON_PROPERTY_PRICE,
  Order.JSON_PROPERTY_AMOUNT_TOTAL,
  Order.JSON_PROPERTY_AMOUNT_NET,
  Order.JSON_PROPERTY_POSITION_PRICE,
  Order.JSON_PROPERTY_TAX_STATUS,
  Order.JSON_PROPERTY_SHIPPING_COSTS,
  Order.JSON_PROPERTY_SHIPPING_TOTAL,
  Order.JSON_PROPERTY_CURRENCY_FACTOR,
  Order.JSON_PROPERTY_DEEP_LINK_CODE,
  Order.JSON_PROPERTY_AFFILIATE_CODE,
  Order.JSON_PROPERTY_CAMPAIGN_CODE,
  Order.JSON_PROPERTY_CUSTOMER_COMMENT,
  Order.JSON_PROPERTY_SOURCE,
  Order.JSON_PROPERTY_CUSTOM_FIELDS,
  Order.JSON_PROPERTY_CREATED_BY_ID,
  Order.JSON_PROPERTY_UPDATED_BY_ID,
  Order.JSON_PROPERTY_CREATED_AT,
  Order.JSON_PROPERTY_UPDATED_AT,
  Order.JSON_PROPERTY_STATE_MACHINE_STATE,
  Order.JSON_PROPERTY_ORDER_CUSTOMER,
  Order.JSON_PROPERTY_CURRENCY,
  Order.JSON_PROPERTY_LANGUAGE,
  Order.JSON_PROPERTY_ADDRESSES,
  Order.JSON_PROPERTY_BILLING_ADDRESS,
  Order.JSON_PROPERTY_DELIVERIES,
  Order.JSON_PROPERTY_LINE_ITEMS,
  Order.JSON_PROPERTY_TRANSACTIONS,
  Order.JSON_PROPERTY_DOCUMENTS,
  Order.JSON_PROPERTY_TAGS
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-10T11:26:02.541008353+02:00[Europe/Berlin]", comments = "Generator version: 7.5.0")
public class Order {
  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_VERSION_ID = "versionId";
  private String versionId;

  public static final String JSON_PROPERTY_ORDER_NUMBER = "orderNumber";
  private String orderNumber;

  public static final String JSON_PROPERTY_BILLING_ADDRESS_ID = "billingAddressId";
  private String billingAddressId;

  public static final String JSON_PROPERTY_BILLING_ADDRESS_VERSION_ID = "billingAddressVersionId";
  private String billingAddressVersionId;

  public static final String JSON_PROPERTY_CURRENCY_ID = "currencyId";
  private String currencyId;

  public static final String JSON_PROPERTY_LANGUAGE_ID = "languageId";
  private String languageId;

  public static final String JSON_PROPERTY_SALES_CHANNEL_ID = "salesChannelId";
  private String salesChannelId;

  public static final String JSON_PROPERTY_ORDER_DATE_TIME = "orderDateTime";
  private OffsetDateTime orderDateTime;

  public static final String JSON_PROPERTY_ORDER_DATE = "orderDate";
  private String orderDate;

  public static final String JSON_PROPERTY_PRICE = "price";
  private OrderPrice price;

  public static final String JSON_PROPERTY_AMOUNT_TOTAL = "amountTotal";
  private Float amountTotal;

  public static final String JSON_PROPERTY_AMOUNT_NET = "amountNet";
  private Float amountNet;

  public static final String JSON_PROPERTY_POSITION_PRICE = "positionPrice";
  private Float positionPrice;

  public static final String JSON_PROPERTY_TAX_STATUS = "taxStatus";
  private String taxStatus;

  public static final String JSON_PROPERTY_SHIPPING_COSTS = "shippingCosts";
  private CalculatedPrice shippingCosts;

  public static final String JSON_PROPERTY_SHIPPING_TOTAL = "shippingTotal";
  private Float shippingTotal;

  public static final String JSON_PROPERTY_CURRENCY_FACTOR = "currencyFactor";
  private Float currencyFactor;

  public static final String JSON_PROPERTY_DEEP_LINK_CODE = "deepLinkCode";
  private String deepLinkCode;

  public static final String JSON_PROPERTY_AFFILIATE_CODE = "affiliateCode";
  private String affiliateCode;

  public static final String JSON_PROPERTY_CAMPAIGN_CODE = "campaignCode";
  private String campaignCode;

  public static final String JSON_PROPERTY_CUSTOMER_COMMENT = "customerComment";
  private String customerComment;

  public static final String JSON_PROPERTY_SOURCE = "source";
  private String source;

  public static final String JSON_PROPERTY_CUSTOM_FIELDS = "customFields";
  private JsonNode customFields;

  public static final String JSON_PROPERTY_CREATED_BY_ID = "createdById";
  private String createdById;

  public static final String JSON_PROPERTY_UPDATED_BY_ID = "updatedById";
  private String updatedById;

  public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
  private OffsetDateTime createdAt;

  public static final String JSON_PROPERTY_UPDATED_AT = "updatedAt";
  private OffsetDateTime updatedAt;

  public static final String JSON_PROPERTY_STATE_MACHINE_STATE = "stateMachineState";
  private StateMachineState stateMachineState;

  public static final String JSON_PROPERTY_ORDER_CUSTOMER = "orderCustomer";
  private OrderCustomer orderCustomer;

  public static final String JSON_PROPERTY_CURRENCY = "currency";
  private Currency currency;

  public static final String JSON_PROPERTY_LANGUAGE = "language";
  private Language language;

  public static final String JSON_PROPERTY_ADDRESSES = "addresses";
  private List<OrderAddress> addresses = new ArrayList<>();

  public static final String JSON_PROPERTY_BILLING_ADDRESS = "billingAddress";
  private OrderAddress billingAddress;

  public static final String JSON_PROPERTY_DELIVERIES = "deliveries";
  private List<OrderDelivery> deliveries = new ArrayList<>();

  public static final String JSON_PROPERTY_LINE_ITEMS = "lineItems";
  private List<OrderLineItem> lineItems = new ArrayList<>();

  public static final String JSON_PROPERTY_TRANSACTIONS = "transactions";
  private List<OrderTransaction> transactions = new ArrayList<>();

  public static final String JSON_PROPERTY_DOCUMENTS = "documents";
  private List<Document> documents = new ArrayList<>();

  public static final String JSON_PROPERTY_TAGS = "tags";
  private List<Tag> tags = new ArrayList<>();

  public Order() {
  }

  @JsonCreator
  public Order(
    @JsonProperty(JSON_PROPERTY_ORDER_DATE) String orderDate, 
    @JsonProperty(JSON_PROPERTY_AMOUNT_TOTAL) Float amountTotal, 
    @JsonProperty(JSON_PROPERTY_AMOUNT_NET) Float amountNet, 
    @JsonProperty(JSON_PROPERTY_POSITION_PRICE) Float positionPrice, 
    @JsonProperty(JSON_PROPERTY_TAX_STATUS) String taxStatus, 
    @JsonProperty(JSON_PROPERTY_SHIPPING_TOTAL) Float shippingTotal, 
    @JsonProperty(JSON_PROPERTY_CREATED_AT) OffsetDateTime createdAt, 
    @JsonProperty(JSON_PROPERTY_UPDATED_AT) OffsetDateTime updatedAt
  ) {
    this();
    this.orderDate = orderDate;
    this.amountTotal = amountTotal;
    this.amountNet = amountNet;
    this.positionPrice = positionPrice;
    this.taxStatus = taxStatus;
    this.shippingTotal = shippingTotal;
    this.createdAt = createdAt;
    this.updatedAt = updatedAt;
  }

  public Order id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public Order versionId(String versionId) {
    
    this.versionId = versionId;
    return this;
  }

   /**
   * Get versionId
   * @return versionId
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_VERSION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getVersionId() {
    return versionId;
  }


  @JsonProperty(JSON_PROPERTY_VERSION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVersionId(String versionId) {
    this.versionId = versionId;
  }


  public Order orderNumber(String orderNumber) {
    
    this.orderNumber = orderNumber;
    return this;
  }

   /**
   * Get orderNumber
   * @return orderNumber
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ORDER_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOrderNumber() {
    return orderNumber;
  }


  @JsonProperty(JSON_PROPERTY_ORDER_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOrderNumber(String orderNumber) {
    this.orderNumber = orderNumber;
  }


  public Order billingAddressId(String billingAddressId) {
    
    this.billingAddressId = billingAddressId;
    return this;
  }

   /**
   * Get billingAddressId
   * @return billingAddressId
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_BILLING_ADDRESS_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getBillingAddressId() {
    return billingAddressId;
  }


  @JsonProperty(JSON_PROPERTY_BILLING_ADDRESS_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBillingAddressId(String billingAddressId) {
    this.billingAddressId = billingAddressId;
  }


  public Order billingAddressVersionId(String billingAddressVersionId) {
    
    this.billingAddressVersionId = billingAddressVersionId;
    return this;
  }

   /**
   * Get billingAddressVersionId
   * @return billingAddressVersionId
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_BILLING_ADDRESS_VERSION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBillingAddressVersionId() {
    return billingAddressVersionId;
  }


  @JsonProperty(JSON_PROPERTY_BILLING_ADDRESS_VERSION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBillingAddressVersionId(String billingAddressVersionId) {
    this.billingAddressVersionId = billingAddressVersionId;
  }


  public Order currencyId(String currencyId) {
    
    this.currencyId = currencyId;
    return this;
  }

   /**
   * Get currencyId
   * @return currencyId
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_CURRENCY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCurrencyId() {
    return currencyId;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCurrencyId(String currencyId) {
    this.currencyId = currencyId;
  }


  public Order languageId(String languageId) {
    
    this.languageId = languageId;
    return this;
  }

   /**
   * Get languageId
   * @return languageId
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_LANGUAGE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getLanguageId() {
    return languageId;
  }


  @JsonProperty(JSON_PROPERTY_LANGUAGE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLanguageId(String languageId) {
    this.languageId = languageId;
  }


  public Order salesChannelId(String salesChannelId) {
    
    this.salesChannelId = salesChannelId;
    return this;
  }

   /**
   * Get salesChannelId
   * @return salesChannelId
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_SALES_CHANNEL_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSalesChannelId() {
    return salesChannelId;
  }


  @JsonProperty(JSON_PROPERTY_SALES_CHANNEL_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSalesChannelId(String salesChannelId) {
    this.salesChannelId = salesChannelId;
  }


  public Order orderDateTime(OffsetDateTime orderDateTime) {
    
    this.orderDateTime = orderDateTime;
    return this;
  }

   /**
   * Get orderDateTime
   * @return orderDateTime
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_ORDER_DATE_TIME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public OffsetDateTime getOrderDateTime() {
    return orderDateTime;
  }


  @JsonProperty(JSON_PROPERTY_ORDER_DATE_TIME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOrderDateTime(OffsetDateTime orderDateTime) {
    this.orderDateTime = orderDateTime;
  }


   /**
   * Get orderDate
   * @return orderDate
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ORDER_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOrderDate() {
    return orderDate;
  }




  public Order price(OrderPrice price) {
    
    this.price = price;
    return this;
  }

   /**
   * Get price
   * @return price
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OrderPrice getPrice() {
    return price;
  }


  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPrice(OrderPrice price) {
    this.price = price;
  }


   /**
   * Get amountTotal
   * @return amountTotal
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_AMOUNT_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getAmountTotal() {
    return amountTotal;
  }




   /**
   * Get amountNet
   * @return amountNet
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_AMOUNT_NET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getAmountNet() {
    return amountNet;
  }




   /**
   * Get positionPrice
   * @return positionPrice
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_POSITION_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getPositionPrice() {
    return positionPrice;
  }




   /**
   * Get taxStatus
   * @return taxStatus
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TAX_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTaxStatus() {
    return taxStatus;
  }




  public Order shippingCosts(CalculatedPrice shippingCosts) {
    
    this.shippingCosts = shippingCosts;
    return this;
  }

   /**
   * Get shippingCosts
   * @return shippingCosts
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SHIPPING_COSTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CalculatedPrice getShippingCosts() {
    return shippingCosts;
  }


  @JsonProperty(JSON_PROPERTY_SHIPPING_COSTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShippingCosts(CalculatedPrice shippingCosts) {
    this.shippingCosts = shippingCosts;
  }


   /**
   * Get shippingTotal
   * @return shippingTotal
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SHIPPING_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getShippingTotal() {
    return shippingTotal;
  }




  public Order currencyFactor(Float currencyFactor) {
    
    this.currencyFactor = currencyFactor;
    return this;
  }

   /**
   * Get currencyFactor
   * @return currencyFactor
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_CURRENCY_FACTOR)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Float getCurrencyFactor() {
    return currencyFactor;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY_FACTOR)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCurrencyFactor(Float currencyFactor) {
    this.currencyFactor = currencyFactor;
  }


  public Order deepLinkCode(String deepLinkCode) {
    
    this.deepLinkCode = deepLinkCode;
    return this;
  }

   /**
   * Get deepLinkCode
   * @return deepLinkCode
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DEEP_LINK_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDeepLinkCode() {
    return deepLinkCode;
  }


  @JsonProperty(JSON_PROPERTY_DEEP_LINK_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeepLinkCode(String deepLinkCode) {
    this.deepLinkCode = deepLinkCode;
  }


  public Order affiliateCode(String affiliateCode) {
    
    this.affiliateCode = affiliateCode;
    return this;
  }

   /**
   * Get affiliateCode
   * @return affiliateCode
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_AFFILIATE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAffiliateCode() {
    return affiliateCode;
  }


  @JsonProperty(JSON_PROPERTY_AFFILIATE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAffiliateCode(String affiliateCode) {
    this.affiliateCode = affiliateCode;
  }


  public Order campaignCode(String campaignCode) {
    
    this.campaignCode = campaignCode;
    return this;
  }

   /**
   * Get campaignCode
   * @return campaignCode
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CAMPAIGN_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCampaignCode() {
    return campaignCode;
  }


  @JsonProperty(JSON_PROPERTY_CAMPAIGN_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCampaignCode(String campaignCode) {
    this.campaignCode = campaignCode;
  }


  public Order customerComment(String customerComment) {
    
    this.customerComment = customerComment;
    return this;
  }

   /**
   * Get customerComment
   * @return customerComment
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CUSTOMER_COMMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCustomerComment() {
    return customerComment;
  }


  @JsonProperty(JSON_PROPERTY_CUSTOMER_COMMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCustomerComment(String customerComment) {
    this.customerComment = customerComment;
  }


  public Order source(String source) {
    
    this.source = source;
    return this;
  }

   /**
   * Get source
   * @return source
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSource() {
    return source;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSource(String source) {
    this.source = source;
  }


  public Order customFields(JsonNode customFields) {
    
    this.customFields = customFields;
    return this;
  }

   /**
   * Get customFields
   * @return customFields
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CUSTOM_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNode getCustomFields() {
    return customFields;
  }


  @JsonProperty(JSON_PROPERTY_CUSTOM_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCustomFields(JsonNode customFields) {
    this.customFields = customFields;
  }


  public Order createdById(String createdById) {
    
    this.createdById = createdById;
    return this;
  }

   /**
   * Get createdById
   * @return createdById
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CREATED_BY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCreatedById() {
    return createdById;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_BY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreatedById(String createdById) {
    this.createdById = createdById;
  }


  public Order updatedById(String updatedById) {
    
    this.updatedById = updatedById;
    return this;
  }

   /**
   * Get updatedById
   * @return updatedById
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_UPDATED_BY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUpdatedById() {
    return updatedById;
  }


  @JsonProperty(JSON_PROPERTY_UPDATED_BY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUpdatedById(String updatedById) {
    this.updatedById = updatedById;
  }


   /**
   * Get createdAt
   * @return createdAt
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }




   /**
   * Get updatedAt
   * @return updatedAt
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getUpdatedAt() {
    return updatedAt;
  }




  public Order stateMachineState(StateMachineState stateMachineState) {
    
    this.stateMachineState = stateMachineState;
    return this;
  }

   /**
   * Get stateMachineState
   * @return stateMachineState
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_STATE_MACHINE_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StateMachineState getStateMachineState() {
    return stateMachineState;
  }


  @JsonProperty(JSON_PROPERTY_STATE_MACHINE_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStateMachineState(StateMachineState stateMachineState) {
    this.stateMachineState = stateMachineState;
  }


  public Order orderCustomer(OrderCustomer orderCustomer) {
    
    this.orderCustomer = orderCustomer;
    return this;
  }

   /**
   * Get orderCustomer
   * @return orderCustomer
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ORDER_CUSTOMER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OrderCustomer getOrderCustomer() {
    return orderCustomer;
  }


  @JsonProperty(JSON_PROPERTY_ORDER_CUSTOMER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOrderCustomer(OrderCustomer orderCustomer) {
    this.orderCustomer = orderCustomer;
  }


  public Order currency(Currency currency) {
    
    this.currency = currency;
    return this;
  }

   /**
   * Get currency
   * @return currency
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Currency getCurrency() {
    return currency;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrency(Currency currency) {
    this.currency = currency;
  }


  public Order language(Language language) {
    
    this.language = language;
    return this;
  }

   /**
   * Get language
   * @return language
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Language getLanguage() {
    return language;
  }


  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLanguage(Language language) {
    this.language = language;
  }


  public Order addresses(List<OrderAddress> addresses) {
    
    this.addresses = addresses;
    return this;
  }

  public Order addAddressesItem(OrderAddress addressesItem) {
    if (this.addresses == null) {
      this.addresses = new ArrayList<>();
    }
    this.addresses.add(addressesItem);
    return this;
  }

   /**
   * Get addresses
   * @return addresses
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ADDRESSES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<OrderAddress> getAddresses() {
    return addresses;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESSES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddresses(List<OrderAddress> addresses) {
    this.addresses = addresses;
  }


  public Order billingAddress(OrderAddress billingAddress) {
    
    this.billingAddress = billingAddress;
    return this;
  }

   /**
   * Get billingAddress
   * @return billingAddress
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_BILLING_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OrderAddress getBillingAddress() {
    return billingAddress;
  }


  @JsonProperty(JSON_PROPERTY_BILLING_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBillingAddress(OrderAddress billingAddress) {
    this.billingAddress = billingAddress;
  }


  public Order deliveries(List<OrderDelivery> deliveries) {
    
    this.deliveries = deliveries;
    return this;
  }

  public Order addDeliveriesItem(OrderDelivery deliveriesItem) {
    if (this.deliveries == null) {
      this.deliveries = new ArrayList<>();
    }
    this.deliveries.add(deliveriesItem);
    return this;
  }

   /**
   * Get deliveries
   * @return deliveries
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DELIVERIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<OrderDelivery> getDeliveries() {
    return deliveries;
  }


  @JsonProperty(JSON_PROPERTY_DELIVERIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeliveries(List<OrderDelivery> deliveries) {
    this.deliveries = deliveries;
  }


  public Order lineItems(List<OrderLineItem> lineItems) {
    
    this.lineItems = lineItems;
    return this;
  }

  public Order addLineItemsItem(OrderLineItem lineItemsItem) {
    if (this.lineItems == null) {
      this.lineItems = new ArrayList<>();
    }
    this.lineItems.add(lineItemsItem);
    return this;
  }

   /**
   * Get lineItems
   * @return lineItems
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LINE_ITEMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<OrderLineItem> getLineItems() {
    return lineItems;
  }


  @JsonProperty(JSON_PROPERTY_LINE_ITEMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLineItems(List<OrderLineItem> lineItems) {
    this.lineItems = lineItems;
  }


  public Order transactions(List<OrderTransaction> transactions) {
    
    this.transactions = transactions;
    return this;
  }

  public Order addTransactionsItem(OrderTransaction transactionsItem) {
    if (this.transactions == null) {
      this.transactions = new ArrayList<>();
    }
    this.transactions.add(transactionsItem);
    return this;
  }

   /**
   * Get transactions
   * @return transactions
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TRANSACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<OrderTransaction> getTransactions() {
    return transactions;
  }


  @JsonProperty(JSON_PROPERTY_TRANSACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTransactions(List<OrderTransaction> transactions) {
    this.transactions = transactions;
  }


  public Order documents(List<Document> documents) {
    
    this.documents = documents;
    return this;
  }

  public Order addDocumentsItem(Document documentsItem) {
    if (this.documents == null) {
      this.documents = new ArrayList<>();
    }
    this.documents.add(documentsItem);
    return this;
  }

   /**
   * Get documents
   * @return documents
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DOCUMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Document> getDocuments() {
    return documents;
  }


  @JsonProperty(JSON_PROPERTY_DOCUMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDocuments(List<Document> documents) {
    this.documents = documents;
  }


  public Order tags(List<Tag> tags) {
    
    this.tags = tags;
    return this;
  }

  public Order addTagsItem(Tag tagsItem) {
    if (this.tags == null) {
      this.tags = new ArrayList<>();
    }
    this.tags.add(tagsItem);
    return this;
  }

   /**
   * Get tags
   * @return tags
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Tag> getTags() {
    return tags;
  }


  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTags(List<Tag> tags) {
    this.tags = tags;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Order order = (Order) o;
    return Objects.equals(this.id, order.id) &&
        Objects.equals(this.versionId, order.versionId) &&
        Objects.equals(this.orderNumber, order.orderNumber) &&
        Objects.equals(this.billingAddressId, order.billingAddressId) &&
        Objects.equals(this.billingAddressVersionId, order.billingAddressVersionId) &&
        Objects.equals(this.currencyId, order.currencyId) &&
        Objects.equals(this.languageId, order.languageId) &&
        Objects.equals(this.salesChannelId, order.salesChannelId) &&
        Objects.equals(this.orderDateTime, order.orderDateTime) &&
        Objects.equals(this.orderDate, order.orderDate) &&
        Objects.equals(this.price, order.price) &&
        Objects.equals(this.amountTotal, order.amountTotal) &&
        Objects.equals(this.amountNet, order.amountNet) &&
        Objects.equals(this.positionPrice, order.positionPrice) &&
        Objects.equals(this.taxStatus, order.taxStatus) &&
        Objects.equals(this.shippingCosts, order.shippingCosts) &&
        Objects.equals(this.shippingTotal, order.shippingTotal) &&
        Objects.equals(this.currencyFactor, order.currencyFactor) &&
        Objects.equals(this.deepLinkCode, order.deepLinkCode) &&
        Objects.equals(this.affiliateCode, order.affiliateCode) &&
        Objects.equals(this.campaignCode, order.campaignCode) &&
        Objects.equals(this.customerComment, order.customerComment) &&
        Objects.equals(this.source, order.source) &&
        Objects.equals(this.customFields, order.customFields) &&
        Objects.equals(this.createdById, order.createdById) &&
        Objects.equals(this.updatedById, order.updatedById) &&
        Objects.equals(this.createdAt, order.createdAt) &&
        Objects.equals(this.updatedAt, order.updatedAt) &&
        Objects.equals(this.stateMachineState, order.stateMachineState) &&
        Objects.equals(this.orderCustomer, order.orderCustomer) &&
        Objects.equals(this.currency, order.currency) &&
        Objects.equals(this.language, order.language) &&
        Objects.equals(this.addresses, order.addresses) &&
        Objects.equals(this.billingAddress, order.billingAddress) &&
        Objects.equals(this.deliveries, order.deliveries) &&
        Objects.equals(this.lineItems, order.lineItems) &&
        Objects.equals(this.transactions, order.transactions) &&
        Objects.equals(this.documents, order.documents) &&
        Objects.equals(this.tags, order.tags);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, versionId, orderNumber, billingAddressId, billingAddressVersionId, currencyId, languageId, salesChannelId, orderDateTime, orderDate, price, amountTotal, amountNet, positionPrice, taxStatus, shippingCosts, shippingTotal, currencyFactor, deepLinkCode, affiliateCode, campaignCode, customerComment, source, customFields, createdById, updatedById, createdAt, updatedAt, stateMachineState, orderCustomer, currency, language, addresses, billingAddress, deliveries, lineItems, transactions, documents, tags);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Order {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    versionId: ").append(toIndentedString(versionId)).append("\n");
    sb.append("    orderNumber: ").append(toIndentedString(orderNumber)).append("\n");
    sb.append("    billingAddressId: ").append(toIndentedString(billingAddressId)).append("\n");
    sb.append("    billingAddressVersionId: ").append(toIndentedString(billingAddressVersionId)).append("\n");
    sb.append("    currencyId: ").append(toIndentedString(currencyId)).append("\n");
    sb.append("    languageId: ").append(toIndentedString(languageId)).append("\n");
    sb.append("    salesChannelId: ").append(toIndentedString(salesChannelId)).append("\n");
    sb.append("    orderDateTime: ").append(toIndentedString(orderDateTime)).append("\n");
    sb.append("    orderDate: ").append(toIndentedString(orderDate)).append("\n");
    sb.append("    price: ").append(toIndentedString(price)).append("\n");
    sb.append("    amountTotal: ").append(toIndentedString(amountTotal)).append("\n");
    sb.append("    amountNet: ").append(toIndentedString(amountNet)).append("\n");
    sb.append("    positionPrice: ").append(toIndentedString(positionPrice)).append("\n");
    sb.append("    taxStatus: ").append(toIndentedString(taxStatus)).append("\n");
    sb.append("    shippingCosts: ").append(toIndentedString(shippingCosts)).append("\n");
    sb.append("    shippingTotal: ").append(toIndentedString(shippingTotal)).append("\n");
    sb.append("    currencyFactor: ").append(toIndentedString(currencyFactor)).append("\n");
    sb.append("    deepLinkCode: ").append(toIndentedString(deepLinkCode)).append("\n");
    sb.append("    affiliateCode: ").append(toIndentedString(affiliateCode)).append("\n");
    sb.append("    campaignCode: ").append(toIndentedString(campaignCode)).append("\n");
    sb.append("    customerComment: ").append(toIndentedString(customerComment)).append("\n");
    sb.append("    source: ").append(toIndentedString(source)).append("\n");
    sb.append("    customFields: ").append(toIndentedString(customFields)).append("\n");
    sb.append("    createdById: ").append(toIndentedString(createdById)).append("\n");
    sb.append("    updatedById: ").append(toIndentedString(updatedById)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("    stateMachineState: ").append(toIndentedString(stateMachineState)).append("\n");
    sb.append("    orderCustomer: ").append(toIndentedString(orderCustomer)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    language: ").append(toIndentedString(language)).append("\n");
    sb.append("    addresses: ").append(toIndentedString(addresses)).append("\n");
    sb.append("    billingAddress: ").append(toIndentedString(billingAddress)).append("\n");
    sb.append("    deliveries: ").append(toIndentedString(deliveries)).append("\n");
    sb.append("    lineItems: ").append(toIndentedString(lineItems)).append("\n");
    sb.append("    transactions: ").append(toIndentedString(transactions)).append("\n");
    sb.append("    documents: ").append(toIndentedString(documents)).append("\n");
    sb.append("    tags: ").append(toIndentedString(tags)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
