/*
 * Shopware Store API
 * This endpoint reference contains an overview of all endpoints comprising the Shopware Store API
 *
 * The version of the OpenAPI document: 6.5.7.3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package de.codebarista.shopware.model.core;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * Added since version: 6.0.0.0
 */
@JsonPropertyOrder({
  OrderDelivery.JSON_PROPERTY_ID,
  OrderDelivery.JSON_PROPERTY_VERSION_ID,
  OrderDelivery.JSON_PROPERTY_ORDER_ID,
  OrderDelivery.JSON_PROPERTY_ORDER_VERSION_ID,
  OrderDelivery.JSON_PROPERTY_SHIPPING_ORDER_ADDRESS_ID,
  OrderDelivery.JSON_PROPERTY_SHIPPING_ORDER_ADDRESS_VERSION_ID,
  OrderDelivery.JSON_PROPERTY_SHIPPING_METHOD_ID,
  OrderDelivery.JSON_PROPERTY_STATE_ID,
  OrderDelivery.JSON_PROPERTY_TRACKING_CODES,
  OrderDelivery.JSON_PROPERTY_SHIPPING_DATE_EARLIEST,
  OrderDelivery.JSON_PROPERTY_SHIPPING_DATE_LATEST,
  OrderDelivery.JSON_PROPERTY_SHIPPING_COSTS,
  OrderDelivery.JSON_PROPERTY_CUSTOM_FIELDS,
  OrderDelivery.JSON_PROPERTY_CREATED_AT,
  OrderDelivery.JSON_PROPERTY_UPDATED_AT,
  OrderDelivery.JSON_PROPERTY_STATE_MACHINE_STATE,
  OrderDelivery.JSON_PROPERTY_SHIPPING_ORDER_ADDRESS,
  OrderDelivery.JSON_PROPERTY_SHIPPING_METHOD,
  OrderDelivery.JSON_PROPERTY_POSITIONS
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-10T11:26:02.541008353+02:00[Europe/Berlin]", comments = "Generator version: 7.5.0")
public class OrderDelivery {
  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_VERSION_ID = "versionId";
  private String versionId;

  public static final String JSON_PROPERTY_ORDER_ID = "orderId";
  private String orderId;

  public static final String JSON_PROPERTY_ORDER_VERSION_ID = "orderVersionId";
  private String orderVersionId;

  public static final String JSON_PROPERTY_SHIPPING_ORDER_ADDRESS_ID = "shippingOrderAddressId";
  private String shippingOrderAddressId;

  public static final String JSON_PROPERTY_SHIPPING_ORDER_ADDRESS_VERSION_ID = "shippingOrderAddressVersionId";
  private String shippingOrderAddressVersionId;

  public static final String JSON_PROPERTY_SHIPPING_METHOD_ID = "shippingMethodId";
  private String shippingMethodId;

  public static final String JSON_PROPERTY_STATE_ID = "stateId";
  private String stateId;

  public static final String JSON_PROPERTY_TRACKING_CODES = "trackingCodes";
  private List<String> trackingCodes = new ArrayList<>();

  public static final String JSON_PROPERTY_SHIPPING_DATE_EARLIEST = "shippingDateEarliest";
  private OffsetDateTime shippingDateEarliest;

  public static final String JSON_PROPERTY_SHIPPING_DATE_LATEST = "shippingDateLatest";
  private OffsetDateTime shippingDateLatest;

  public static final String JSON_PROPERTY_SHIPPING_COSTS = "shippingCosts";
  private OrderShippingCosts shippingCosts;

  public static final String JSON_PROPERTY_CUSTOM_FIELDS = "customFields";
  private Object customFields;

  public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
  private OffsetDateTime createdAt;

  public static final String JSON_PROPERTY_UPDATED_AT = "updatedAt";
  private OffsetDateTime updatedAt;

  public static final String JSON_PROPERTY_STATE_MACHINE_STATE = "stateMachineState";
  private StateMachineState stateMachineState;

  public static final String JSON_PROPERTY_SHIPPING_ORDER_ADDRESS = "shippingOrderAddress";
  private OrderAddress shippingOrderAddress;

  public static final String JSON_PROPERTY_SHIPPING_METHOD = "shippingMethod";
  private ShippingMethod shippingMethod;

  public static final String JSON_PROPERTY_POSITIONS = "positions";
  private List<OrderDeliveryPosition> positions = new ArrayList<>();

  public OrderDelivery() {
  }

  @JsonCreator
  public OrderDelivery(
    @JsonProperty(JSON_PROPERTY_CREATED_AT) OffsetDateTime createdAt, 
    @JsonProperty(JSON_PROPERTY_UPDATED_AT) OffsetDateTime updatedAt
  ) {
    this();
    this.createdAt = createdAt;
    this.updatedAt = updatedAt;
  }

  public OrderDelivery id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public OrderDelivery versionId(String versionId) {
    
    this.versionId = versionId;
    return this;
  }

   /**
   * Get versionId
   * @return versionId
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_VERSION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getVersionId() {
    return versionId;
  }


  @JsonProperty(JSON_PROPERTY_VERSION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVersionId(String versionId) {
    this.versionId = versionId;
  }


  public OrderDelivery orderId(String orderId) {
    
    this.orderId = orderId;
    return this;
  }

   /**
   * Get orderId
   * @return orderId
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_ORDER_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getOrderId() {
    return orderId;
  }


  @JsonProperty(JSON_PROPERTY_ORDER_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOrderId(String orderId) {
    this.orderId = orderId;
  }


  public OrderDelivery orderVersionId(String orderVersionId) {
    
    this.orderVersionId = orderVersionId;
    return this;
  }

   /**
   * Get orderVersionId
   * @return orderVersionId
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ORDER_VERSION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOrderVersionId() {
    return orderVersionId;
  }


  @JsonProperty(JSON_PROPERTY_ORDER_VERSION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOrderVersionId(String orderVersionId) {
    this.orderVersionId = orderVersionId;
  }


  public OrderDelivery shippingOrderAddressId(String shippingOrderAddressId) {
    
    this.shippingOrderAddressId = shippingOrderAddressId;
    return this;
  }

   /**
   * Get shippingOrderAddressId
   * @return shippingOrderAddressId
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_SHIPPING_ORDER_ADDRESS_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getShippingOrderAddressId() {
    return shippingOrderAddressId;
  }


  @JsonProperty(JSON_PROPERTY_SHIPPING_ORDER_ADDRESS_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setShippingOrderAddressId(String shippingOrderAddressId) {
    this.shippingOrderAddressId = shippingOrderAddressId;
  }


  public OrderDelivery shippingOrderAddressVersionId(String shippingOrderAddressVersionId) {
    
    this.shippingOrderAddressVersionId = shippingOrderAddressVersionId;
    return this;
  }

   /**
   * Get shippingOrderAddressVersionId
   * @return shippingOrderAddressVersionId
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SHIPPING_ORDER_ADDRESS_VERSION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getShippingOrderAddressVersionId() {
    return shippingOrderAddressVersionId;
  }


  @JsonProperty(JSON_PROPERTY_SHIPPING_ORDER_ADDRESS_VERSION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShippingOrderAddressVersionId(String shippingOrderAddressVersionId) {
    this.shippingOrderAddressVersionId = shippingOrderAddressVersionId;
  }


  public OrderDelivery shippingMethodId(String shippingMethodId) {
    
    this.shippingMethodId = shippingMethodId;
    return this;
  }

   /**
   * Get shippingMethodId
   * @return shippingMethodId
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_SHIPPING_METHOD_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getShippingMethodId() {
    return shippingMethodId;
  }


  @JsonProperty(JSON_PROPERTY_SHIPPING_METHOD_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setShippingMethodId(String shippingMethodId) {
    this.shippingMethodId = shippingMethodId;
  }


  public OrderDelivery stateId(String stateId) {
    
    this.stateId = stateId;
    return this;
  }

   /**
   * Get stateId
   * @return stateId
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_STATE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getStateId() {
    return stateId;
  }


  @JsonProperty(JSON_PROPERTY_STATE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStateId(String stateId) {
    this.stateId = stateId;
  }


  public OrderDelivery trackingCodes(List<String> trackingCodes) {
    
    this.trackingCodes = trackingCodes;
    return this;
  }

  public OrderDelivery addTrackingCodesItem(String trackingCodesItem) {
    if (this.trackingCodes == null) {
      this.trackingCodes = new ArrayList<>();
    }
    this.trackingCodes.add(trackingCodesItem);
    return this;
  }

   /**
   * Get trackingCodes
   * @return trackingCodes
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_TRACKING_CODES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<String> getTrackingCodes() {
    return trackingCodes;
  }


  @JsonProperty(JSON_PROPERTY_TRACKING_CODES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTrackingCodes(List<String> trackingCodes) {
    this.trackingCodes = trackingCodes;
  }


  public OrderDelivery shippingDateEarliest(OffsetDateTime shippingDateEarliest) {
    
    this.shippingDateEarliest = shippingDateEarliest;
    return this;
  }

   /**
   * Get shippingDateEarliest
   * @return shippingDateEarliest
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_SHIPPING_DATE_EARLIEST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public OffsetDateTime getShippingDateEarliest() {
    return shippingDateEarliest;
  }


  @JsonProperty(JSON_PROPERTY_SHIPPING_DATE_EARLIEST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setShippingDateEarliest(OffsetDateTime shippingDateEarliest) {
    this.shippingDateEarliest = shippingDateEarliest;
  }


  public OrderDelivery shippingDateLatest(OffsetDateTime shippingDateLatest) {
    
    this.shippingDateLatest = shippingDateLatest;
    return this;
  }

   /**
   * Get shippingDateLatest
   * @return shippingDateLatest
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_SHIPPING_DATE_LATEST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public OffsetDateTime getShippingDateLatest() {
    return shippingDateLatest;
  }


  @JsonProperty(JSON_PROPERTY_SHIPPING_DATE_LATEST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setShippingDateLatest(OffsetDateTime shippingDateLatest) {
    this.shippingDateLatest = shippingDateLatest;
  }


  public OrderDelivery shippingCosts(OrderShippingCosts shippingCosts) {
    
    this.shippingCosts = shippingCosts;
    return this;
  }

   /**
   * Get shippingCosts
   * @return shippingCosts
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SHIPPING_COSTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OrderShippingCosts getShippingCosts() {
    return shippingCosts;
  }


  @JsonProperty(JSON_PROPERTY_SHIPPING_COSTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShippingCosts(OrderShippingCosts shippingCosts) {
    this.shippingCosts = shippingCosts;
  }


  public OrderDelivery customFields(Object customFields) {
    
    this.customFields = customFields;
    return this;
  }

   /**
   * Get customFields
   * @return customFields
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CUSTOM_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getCustomFields() {
    return customFields;
  }


  @JsonProperty(JSON_PROPERTY_CUSTOM_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCustomFields(Object customFields) {
    this.customFields = customFields;
  }


   /**
   * Get createdAt
   * @return createdAt
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }




   /**
   * Get updatedAt
   * @return updatedAt
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getUpdatedAt() {
    return updatedAt;
  }




  public OrderDelivery stateMachineState(StateMachineState stateMachineState) {
    
    this.stateMachineState = stateMachineState;
    return this;
  }

   /**
   * Get stateMachineState
   * @return stateMachineState
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_STATE_MACHINE_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StateMachineState getStateMachineState() {
    return stateMachineState;
  }


  @JsonProperty(JSON_PROPERTY_STATE_MACHINE_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStateMachineState(StateMachineState stateMachineState) {
    this.stateMachineState = stateMachineState;
  }


  public OrderDelivery shippingOrderAddress(OrderAddress shippingOrderAddress) {
    
    this.shippingOrderAddress = shippingOrderAddress;
    return this;
  }

   /**
   * Get shippingOrderAddress
   * @return shippingOrderAddress
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SHIPPING_ORDER_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OrderAddress getShippingOrderAddress() {
    return shippingOrderAddress;
  }


  @JsonProperty(JSON_PROPERTY_SHIPPING_ORDER_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShippingOrderAddress(OrderAddress shippingOrderAddress) {
    this.shippingOrderAddress = shippingOrderAddress;
  }


  public OrderDelivery shippingMethod(ShippingMethod shippingMethod) {
    
    this.shippingMethod = shippingMethod;
    return this;
  }

   /**
   * Get shippingMethod
   * @return shippingMethod
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SHIPPING_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ShippingMethod getShippingMethod() {
    return shippingMethod;
  }


  @JsonProperty(JSON_PROPERTY_SHIPPING_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShippingMethod(ShippingMethod shippingMethod) {
    this.shippingMethod = shippingMethod;
  }


  public OrderDelivery positions(List<OrderDeliveryPosition> positions) {
    
    this.positions = positions;
    return this;
  }

  public OrderDelivery addPositionsItem(OrderDeliveryPosition positionsItem) {
    if (this.positions == null) {
      this.positions = new ArrayList<>();
    }
    this.positions.add(positionsItem);
    return this;
  }

   /**
   * Get positions
   * @return positions
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_POSITIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<OrderDeliveryPosition> getPositions() {
    return positions;
  }


  @JsonProperty(JSON_PROPERTY_POSITIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPositions(List<OrderDeliveryPosition> positions) {
    this.positions = positions;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OrderDelivery orderDelivery = (OrderDelivery) o;
    return Objects.equals(this.id, orderDelivery.id) &&
        Objects.equals(this.versionId, orderDelivery.versionId) &&
        Objects.equals(this.orderId, orderDelivery.orderId) &&
        Objects.equals(this.orderVersionId, orderDelivery.orderVersionId) &&
        Objects.equals(this.shippingOrderAddressId, orderDelivery.shippingOrderAddressId) &&
        Objects.equals(this.shippingOrderAddressVersionId, orderDelivery.shippingOrderAddressVersionId) &&
        Objects.equals(this.shippingMethodId, orderDelivery.shippingMethodId) &&
        Objects.equals(this.stateId, orderDelivery.stateId) &&
        Objects.equals(this.trackingCodes, orderDelivery.trackingCodes) &&
        Objects.equals(this.shippingDateEarliest, orderDelivery.shippingDateEarliest) &&
        Objects.equals(this.shippingDateLatest, orderDelivery.shippingDateLatest) &&
        Objects.equals(this.shippingCosts, orderDelivery.shippingCosts) &&
        Objects.equals(this.customFields, orderDelivery.customFields) &&
        Objects.equals(this.createdAt, orderDelivery.createdAt) &&
        Objects.equals(this.updatedAt, orderDelivery.updatedAt) &&
        Objects.equals(this.stateMachineState, orderDelivery.stateMachineState) &&
        Objects.equals(this.shippingOrderAddress, orderDelivery.shippingOrderAddress) &&
        Objects.equals(this.shippingMethod, orderDelivery.shippingMethod) &&
        Objects.equals(this.positions, orderDelivery.positions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, versionId, orderId, orderVersionId, shippingOrderAddressId, shippingOrderAddressVersionId, shippingMethodId, stateId, trackingCodes, shippingDateEarliest, shippingDateLatest, shippingCosts, customFields, createdAt, updatedAt, stateMachineState, shippingOrderAddress, shippingMethod, positions);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OrderDelivery {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    versionId: ").append(toIndentedString(versionId)).append("\n");
    sb.append("    orderId: ").append(toIndentedString(orderId)).append("\n");
    sb.append("    orderVersionId: ").append(toIndentedString(orderVersionId)).append("\n");
    sb.append("    shippingOrderAddressId: ").append(toIndentedString(shippingOrderAddressId)).append("\n");
    sb.append("    shippingOrderAddressVersionId: ").append(toIndentedString(shippingOrderAddressVersionId)).append("\n");
    sb.append("    shippingMethodId: ").append(toIndentedString(shippingMethodId)).append("\n");
    sb.append("    stateId: ").append(toIndentedString(stateId)).append("\n");
    sb.append("    trackingCodes: ").append(toIndentedString(trackingCodes)).append("\n");
    sb.append("    shippingDateEarliest: ").append(toIndentedString(shippingDateEarliest)).append("\n");
    sb.append("    shippingDateLatest: ").append(toIndentedString(shippingDateLatest)).append("\n");
    sb.append("    shippingCosts: ").append(toIndentedString(shippingCosts)).append("\n");
    sb.append("    customFields: ").append(toIndentedString(customFields)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("    stateMachineState: ").append(toIndentedString(stateMachineState)).append("\n");
    sb.append("    shippingOrderAddress: ").append(toIndentedString(shippingOrderAddress)).append("\n");
    sb.append("    shippingMethod: ").append(toIndentedString(shippingMethod)).append("\n");
    sb.append("    positions: ").append(toIndentedString(positions)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

