/*
 * Shopware Store API
 * This endpoint reference contains an overview of all endpoints comprising the Shopware Store API
 *
 * The version of the OpenAPI document: 6.5.7.3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package de.codebarista.shopware.model.core;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * OrderRouteResponse
 */
@JsonPropertyOrder({
  OrderRouteResponse.JSON_PROPERTY_ORDERS,
  OrderRouteResponse.JSON_PROPERTY_PAYMENT_CHANGEABLE
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-10T11:26:02.541008353+02:00[Europe/Berlin]", comments = "Generator version: 7.5.0")
public class OrderRouteResponse {
  public static final String JSON_PROPERTY_ORDERS = "orders";
  private List<Order> orders = new ArrayList<>();

  public static final String JSON_PROPERTY_PAYMENT_CHANGEABLE = "paymentChangeable";
  private Map<String, Boolean> paymentChangeable = new HashMap<>();

  public OrderRouteResponse() {
  }

  public OrderRouteResponse orders(List<Order> orders) {
    
    this.orders = orders;
    return this;
  }

  public OrderRouteResponse addOrdersItem(Order ordersItem) {
    if (this.orders == null) {
      this.orders = new ArrayList<>();
    }
    this.orders.add(ordersItem);
    return this;
  }

   /**
   * Get orders
   * @return orders
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ORDERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Order> getOrders() {
    return orders;
  }


  @JsonProperty(JSON_PROPERTY_ORDERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOrders(List<Order> orders) {
    this.orders = orders;
  }


  public OrderRouteResponse paymentChangeable(Map<String, Boolean> paymentChangeable) {
    
    this.paymentChangeable = paymentChangeable;
    return this;
  }

  public OrderRouteResponse putPaymentChangeableItem(String key, Boolean paymentChangeableItem) {
    if (this.paymentChangeable == null) {
      this.paymentChangeable = new HashMap<>();
    }
    this.paymentChangeable.put(key, paymentChangeableItem);
    return this;
  }

   /**
   * The key-value pairs contain the uuid of the order as key and a boolean as value, indicating that the payment method can still be changed.
   * @return paymentChangeable
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PAYMENT_CHANGEABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Boolean> getPaymentChangeable() {
    return paymentChangeable;
  }


  @JsonProperty(JSON_PROPERTY_PAYMENT_CHANGEABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaymentChangeable(Map<String, Boolean> paymentChangeable) {
    this.paymentChangeable = paymentChangeable;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OrderRouteResponse orderRouteResponse = (OrderRouteResponse) o;
    return Objects.equals(this.orders, orderRouteResponse.orders) &&
        Objects.equals(this.paymentChangeable, orderRouteResponse.paymentChangeable);
  }

  @Override
  public int hashCode() {
    return Objects.hash(orders, paymentChangeable);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OrderRouteResponse {\n");
    sb.append("    orders: ").append(toIndentedString(orders)).append("\n");
    sb.append("    paymentChangeable: ").append(toIndentedString(paymentChangeable)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

