/*
 * Shopware Store API
 * This endpoint reference contains an overview of all endpoints comprising the Shopware Store API
 *
 * The version of the OpenAPI document: 6.5.7.3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package de.codebarista.shopware.model.core;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonNode;

import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * Added since version: 6.0.0.0
 */
@JsonPropertyOrder({
  OrderTransaction.JSON_PROPERTY_ID,
  OrderTransaction.JSON_PROPERTY_VERSION_ID,
  OrderTransaction.JSON_PROPERTY_ORDER_ID,
  OrderTransaction.JSON_PROPERTY_ORDER_VERSION_ID,
  OrderTransaction.JSON_PROPERTY_PAYMENT_METHOD_ID,
  OrderTransaction.JSON_PROPERTY_AMOUNT,
  OrderTransaction.JSON_PROPERTY_STATE_ID,
  OrderTransaction.JSON_PROPERTY_CUSTOM_FIELDS,
  OrderTransaction.JSON_PROPERTY_CREATED_AT,
  OrderTransaction.JSON_PROPERTY_UPDATED_AT,
  OrderTransaction.JSON_PROPERTY_STATE_MACHINE_STATE,
  OrderTransaction.JSON_PROPERTY_PAYMENT_METHOD,
  OrderTransaction.JSON_PROPERTY_CAPTURES
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-10T11:26:02.541008353+02:00[Europe/Berlin]", comments = "Generator version: 7.5.0")
public class OrderTransaction {
  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_VERSION_ID = "versionId";
  private String versionId;

  public static final String JSON_PROPERTY_ORDER_ID = "orderId";
  private String orderId;

  public static final String JSON_PROPERTY_ORDER_VERSION_ID = "orderVersionId";
  private String orderVersionId;

  public static final String JSON_PROPERTY_PAYMENT_METHOD_ID = "paymentMethodId";
  private String paymentMethodId;

  public static final String JSON_PROPERTY_AMOUNT = "amount";
  private OrderShippingCosts amount;

  public static final String JSON_PROPERTY_STATE_ID = "stateId";
  private String stateId;

  public static final String JSON_PROPERTY_CUSTOM_FIELDS = "customFields";
  private JsonNode customFields;

  public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
  private OffsetDateTime createdAt;

  public static final String JSON_PROPERTY_UPDATED_AT = "updatedAt";
  private OffsetDateTime updatedAt;

  public static final String JSON_PROPERTY_STATE_MACHINE_STATE = "stateMachineState";
  private StateMachineState stateMachineState;

  public static final String JSON_PROPERTY_PAYMENT_METHOD = "paymentMethod";
  private PaymentMethod paymentMethod;

  public static final String JSON_PROPERTY_CAPTURES = "captures";
  private List<OrderTransactionCapture> captures = new ArrayList<>();

  public OrderTransaction() {
  }

  @JsonCreator
  public OrderTransaction(
    @JsonProperty(JSON_PROPERTY_CREATED_AT) OffsetDateTime createdAt, 
    @JsonProperty(JSON_PROPERTY_UPDATED_AT) OffsetDateTime updatedAt
  ) {
    this();
    this.createdAt = createdAt;
    this.updatedAt = updatedAt;
  }

  public OrderTransaction id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public OrderTransaction versionId(String versionId) {
    
    this.versionId = versionId;
    return this;
  }

   /**
   * Get versionId
   * @return versionId
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_VERSION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getVersionId() {
    return versionId;
  }


  @JsonProperty(JSON_PROPERTY_VERSION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVersionId(String versionId) {
    this.versionId = versionId;
  }


  public OrderTransaction orderId(String orderId) {
    
    this.orderId = orderId;
    return this;
  }

   /**
   * Get orderId
   * @return orderId
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_ORDER_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getOrderId() {
    return orderId;
  }


  @JsonProperty(JSON_PROPERTY_ORDER_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOrderId(String orderId) {
    this.orderId = orderId;
  }


  public OrderTransaction orderVersionId(String orderVersionId) {
    
    this.orderVersionId = orderVersionId;
    return this;
  }

   /**
   * Get orderVersionId
   * @return orderVersionId
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ORDER_VERSION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOrderVersionId() {
    return orderVersionId;
  }


  @JsonProperty(JSON_PROPERTY_ORDER_VERSION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOrderVersionId(String orderVersionId) {
    this.orderVersionId = orderVersionId;
  }


  public OrderTransaction paymentMethodId(String paymentMethodId) {
    
    this.paymentMethodId = paymentMethodId;
    return this;
  }

   /**
   * Get paymentMethodId
   * @return paymentMethodId
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_PAYMENT_METHOD_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getPaymentMethodId() {
    return paymentMethodId;
  }


  @JsonProperty(JSON_PROPERTY_PAYMENT_METHOD_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPaymentMethodId(String paymentMethodId) {
    this.paymentMethodId = paymentMethodId;
  }


  public OrderTransaction amount(OrderShippingCosts amount) {
    
    this.amount = amount;
    return this;
  }

   /**
   * Get amount
   * @return amount
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public OrderShippingCosts getAmount() {
    return amount;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAmount(OrderShippingCosts amount) {
    this.amount = amount;
  }


  public OrderTransaction stateId(String stateId) {
    
    this.stateId = stateId;
    return this;
  }

   /**
   * Get stateId
   * @return stateId
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_STATE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getStateId() {
    return stateId;
  }


  @JsonProperty(JSON_PROPERTY_STATE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStateId(String stateId) {
    this.stateId = stateId;
  }


  public OrderTransaction customFields(JsonNode customFields) {
    
    this.customFields = customFields;
    return this;
  }

   /**
   * Get customFields
   * @return customFields
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CUSTOM_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNode getCustomFields() {
    return customFields;
  }


  @JsonProperty(JSON_PROPERTY_CUSTOM_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCustomFields(JsonNode customFields) {
    this.customFields = customFields;
  }


   /**
   * Get createdAt
   * @return createdAt
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }




   /**
   * Get updatedAt
   * @return updatedAt
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getUpdatedAt() {
    return updatedAt;
  }




  public OrderTransaction stateMachineState(StateMachineState stateMachineState) {
    
    this.stateMachineState = stateMachineState;
    return this;
  }

   /**
   * Get stateMachineState
   * @return stateMachineState
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_STATE_MACHINE_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StateMachineState getStateMachineState() {
    return stateMachineState;
  }


  @JsonProperty(JSON_PROPERTY_STATE_MACHINE_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStateMachineState(StateMachineState stateMachineState) {
    this.stateMachineState = stateMachineState;
  }


  public OrderTransaction paymentMethod(PaymentMethod paymentMethod) {
    
    this.paymentMethod = paymentMethod;
    return this;
  }

   /**
   * Get paymentMethod
   * @return paymentMethod
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PAYMENT_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PaymentMethod getPaymentMethod() {
    return paymentMethod;
  }


  @JsonProperty(JSON_PROPERTY_PAYMENT_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaymentMethod(PaymentMethod paymentMethod) {
    this.paymentMethod = paymentMethod;
  }


  public OrderTransaction captures(List<OrderTransactionCapture> captures) {
    
    this.captures = captures;
    return this;
  }

  public OrderTransaction addCapturesItem(OrderTransactionCapture capturesItem) {
    if (this.captures == null) {
      this.captures = new ArrayList<>();
    }
    this.captures.add(capturesItem);
    return this;
  }

   /**
   * Get captures
   * @return captures
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CAPTURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<OrderTransactionCapture> getCaptures() {
    return captures;
  }


  @JsonProperty(JSON_PROPERTY_CAPTURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCaptures(List<OrderTransactionCapture> captures) {
    this.captures = captures;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OrderTransaction orderTransaction = (OrderTransaction) o;
    return Objects.equals(this.id, orderTransaction.id) &&
        Objects.equals(this.versionId, orderTransaction.versionId) &&
        Objects.equals(this.orderId, orderTransaction.orderId) &&
        Objects.equals(this.orderVersionId, orderTransaction.orderVersionId) &&
        Objects.equals(this.paymentMethodId, orderTransaction.paymentMethodId) &&
        Objects.equals(this.amount, orderTransaction.amount) &&
        Objects.equals(this.stateId, orderTransaction.stateId) &&
        Objects.equals(this.customFields, orderTransaction.customFields) &&
        Objects.equals(this.createdAt, orderTransaction.createdAt) &&
        Objects.equals(this.updatedAt, orderTransaction.updatedAt) &&
        Objects.equals(this.stateMachineState, orderTransaction.stateMachineState) &&
        Objects.equals(this.paymentMethod, orderTransaction.paymentMethod) &&
        Objects.equals(this.captures, orderTransaction.captures);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, versionId, orderId, orderVersionId, paymentMethodId, amount, stateId, customFields, createdAt, updatedAt, stateMachineState, paymentMethod, captures);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OrderTransaction {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    versionId: ").append(toIndentedString(versionId)).append("\n");
    sb.append("    orderId: ").append(toIndentedString(orderId)).append("\n");
    sb.append("    orderVersionId: ").append(toIndentedString(orderVersionId)).append("\n");
    sb.append("    paymentMethodId: ").append(toIndentedString(paymentMethodId)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    stateId: ").append(toIndentedString(stateId)).append("\n");
    sb.append("    customFields: ").append(toIndentedString(customFields)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("    stateMachineState: ").append(toIndentedString(stateMachineState)).append("\n");
    sb.append("    paymentMethod: ").append(toIndentedString(paymentMethod)).append("\n");
    sb.append("    captures: ").append(toIndentedString(captures)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
