/*
 * Shopware Store API
 * This endpoint reference contains an overview of all endpoints comprising the Shopware Store API
 *
 * The version of the OpenAPI document: 6.5.7.3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package de.codebarista.shopware.model.core;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * Added since version: 6.0.0.0
 */
@JsonPropertyOrder({
  ProductJsonApi.JSON_PROPERTY_TYPE,
  ProductJsonApi.JSON_PROPERTY_ID,
  ProductJsonApi.JSON_PROPERTY_ATTRIBUTES,
  ProductJsonApi.JSON_PROPERTY_RELATIONSHIPS,
  ProductJsonApi.JSON_PROPERTY_LINKS,
  ProductJsonApi.JSON_PROPERTY_META,
  ProductJsonApi.JSON_PROPERTY_VERSION_ID,
  ProductJsonApi.JSON_PROPERTY_PARENT_ID,
  ProductJsonApi.JSON_PROPERTY_PARENT_VERSION_ID,
  ProductJsonApi.JSON_PROPERTY_MANUFACTURER_ID,
  ProductJsonApi.JSON_PROPERTY_PRODUCT_MANUFACTURER_VERSION_ID,
  ProductJsonApi.JSON_PROPERTY_UNIT_ID,
  ProductJsonApi.JSON_PROPERTY_TAX_ID,
  ProductJsonApi.JSON_PROPERTY_COVER_ID,
  ProductJsonApi.JSON_PROPERTY_PRODUCT_MEDIA_VERSION_ID,
  ProductJsonApi.JSON_PROPERTY_DELIVERY_TIME_ID,
  ProductJsonApi.JSON_PROPERTY_CANONICAL_PRODUCT_ID,
  ProductJsonApi.JSON_PROPERTY_CMS_PAGE_ID,
  ProductJsonApi.JSON_PROPERTY_CMS_PAGE_VERSION_ID,
  ProductJsonApi.JSON_PROPERTY_PRODUCT_NUMBER,
  ProductJsonApi.JSON_PROPERTY_RESTOCK_TIME,
  ProductJsonApi.JSON_PROPERTY_ACTIVE,
  ProductJsonApi.JSON_PROPERTY_AVAILABLE,
  ProductJsonApi.JSON_PROPERTY_IS_CLOSEOUT,
  ProductJsonApi.JSON_PROPERTY_DISPLAY_GROUP,
  ProductJsonApi.JSON_PROPERTY_MANUFACTURER_NUMBER,
  ProductJsonApi.JSON_PROPERTY_EAN,
  ProductJsonApi.JSON_PROPERTY_PURCHASE_STEPS,
  ProductJsonApi.JSON_PROPERTY_MAX_PURCHASE,
  ProductJsonApi.JSON_PROPERTY_MIN_PURCHASE,
  ProductJsonApi.JSON_PROPERTY_PURCHASE_UNIT,
  ProductJsonApi.JSON_PROPERTY_REFERENCE_UNIT,
  ProductJsonApi.JSON_PROPERTY_SHIPPING_FREE,
  ProductJsonApi.JSON_PROPERTY_MARK_AS_TOPSELLER,
  ProductJsonApi.JSON_PROPERTY_WEIGHT,
  ProductJsonApi.JSON_PROPERTY_WIDTH,
  ProductJsonApi.JSON_PROPERTY_HEIGHT,
  ProductJsonApi.JSON_PROPERTY_LENGTH,
  ProductJsonApi.JSON_PROPERTY_RELEASE_DATE,
  ProductJsonApi.JSON_PROPERTY_RATING_AVERAGE,
  ProductJsonApi.JSON_PROPERTY_CATEGORY_TREE,
  ProductJsonApi.JSON_PROPERTY_PROPERTY_IDS,
  ProductJsonApi.JSON_PROPERTY_OPTION_IDS,
  ProductJsonApi.JSON_PROPERTY_STREAM_IDS,
  ProductJsonApi.JSON_PROPERTY_TAG_IDS,
  ProductJsonApi.JSON_PROPERTY_CATEGORY_IDS,
  ProductJsonApi.JSON_PROPERTY_CHILD_COUNT,
  ProductJsonApi.JSON_PROPERTY_SALES,
  ProductJsonApi.JSON_PROPERTY_STATES,
  ProductJsonApi.JSON_PROPERTY_META_DESCRIPTION,
  ProductJsonApi.JSON_PROPERTY_NAME,
  ProductJsonApi.JSON_PROPERTY_KEYWORDS,
  ProductJsonApi.JSON_PROPERTY_DESCRIPTION,
  ProductJsonApi.JSON_PROPERTY_META_TITLE,
  ProductJsonApi.JSON_PROPERTY_PACK_UNIT,
  ProductJsonApi.JSON_PROPERTY_PACK_UNIT_PLURAL,
  ProductJsonApi.JSON_PROPERTY_CUSTOM_FIELDS,
  ProductJsonApi.JSON_PROPERTY_AVAILABLE_STOCK,
  ProductJsonApi.JSON_PROPERTY_STOCK,
  ProductJsonApi.JSON_PROPERTY_CALCULATED_PRICE,
  ProductJsonApi.JSON_PROPERTY_CALCULATED_PRICES,
  ProductJsonApi.JSON_PROPERTY_CALCULATED_MAX_PURCHASE,
  ProductJsonApi.JSON_PROPERTY_CALCULATED_CHEAPEST_PRICE,
  ProductJsonApi.JSON_PROPERTY_IS_NEW,
  ProductJsonApi.JSON_PROPERTY_SORTED_PROPERTIES,
  ProductJsonApi.JSON_PROPERTY_CREATED_AT,
  ProductJsonApi.JSON_PROPERTY_UPDATED_AT,
  ProductJsonApi.JSON_PROPERTY_TRANSLATED
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-10T11:26:02.541008353+02:00[Europe/Berlin]", comments = "Generator version: 7.5.0")
public class ProductJsonApi {
  public static final String JSON_PROPERTY_TYPE = "type";
  private String type;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
  private Map<String, Object> attributes = new HashMap<>();

  public static final String JSON_PROPERTY_RELATIONSHIPS = "relationships";
  private ProductJsonApiAllOfRelationships relationships;

  public static final String JSON_PROPERTY_LINKS = "links";
  private Map<String, Link> links = new HashMap<>();

  public static final String JSON_PROPERTY_META = "meta";
  private Map<String, Object> meta = new HashMap<>();

  public static final String JSON_PROPERTY_VERSION_ID = "versionId";
  private String versionId;

  public static final String JSON_PROPERTY_PARENT_ID = "parentId";
  private String parentId;

  public static final String JSON_PROPERTY_PARENT_VERSION_ID = "parentVersionId";
  private String parentVersionId;

  public static final String JSON_PROPERTY_MANUFACTURER_ID = "manufacturerId";
  private String manufacturerId;

  public static final String JSON_PROPERTY_PRODUCT_MANUFACTURER_VERSION_ID = "productManufacturerVersionId";
  private String productManufacturerVersionId;

  public static final String JSON_PROPERTY_UNIT_ID = "unitId";
  private String unitId;

  public static final String JSON_PROPERTY_TAX_ID = "taxId";
  private String taxId;

  public static final String JSON_PROPERTY_COVER_ID = "coverId";
  private String coverId;

  public static final String JSON_PROPERTY_PRODUCT_MEDIA_VERSION_ID = "productMediaVersionId";
  private String productMediaVersionId;

  public static final String JSON_PROPERTY_DELIVERY_TIME_ID = "deliveryTimeId";
  private String deliveryTimeId;

  public static final String JSON_PROPERTY_CANONICAL_PRODUCT_ID = "canonicalProductId";
  private String canonicalProductId;

  public static final String JSON_PROPERTY_CMS_PAGE_ID = "cmsPageId";
  private String cmsPageId;

  public static final String JSON_PROPERTY_CMS_PAGE_VERSION_ID = "cmsPageVersionId";
  private String cmsPageVersionId;

  public static final String JSON_PROPERTY_PRODUCT_NUMBER = "productNumber";
  private String productNumber;

  public static final String JSON_PROPERTY_RESTOCK_TIME = "restockTime";
  private Long restockTime;

  public static final String JSON_PROPERTY_ACTIVE = "active";
  private Boolean active;

  public static final String JSON_PROPERTY_AVAILABLE = "available";
  private Boolean available;

  public static final String JSON_PROPERTY_IS_CLOSEOUT = "isCloseout";
  private Boolean isCloseout;

  public static final String JSON_PROPERTY_DISPLAY_GROUP = "displayGroup";
  private String displayGroup;

  public static final String JSON_PROPERTY_MANUFACTURER_NUMBER = "manufacturerNumber";
  private String manufacturerNumber;

  public static final String JSON_PROPERTY_EAN = "ean";
  private String ean;

  public static final String JSON_PROPERTY_PURCHASE_STEPS = "purchaseSteps";
  private Long purchaseSteps;

  public static final String JSON_PROPERTY_MAX_PURCHASE = "maxPurchase";
  private Long maxPurchase;

  public static final String JSON_PROPERTY_MIN_PURCHASE = "minPurchase";
  private Long minPurchase;

  public static final String JSON_PROPERTY_PURCHASE_UNIT = "purchaseUnit";
  private Float purchaseUnit;

  public static final String JSON_PROPERTY_REFERENCE_UNIT = "referenceUnit";
  private Float referenceUnit;

  public static final String JSON_PROPERTY_SHIPPING_FREE = "shippingFree";
  private Boolean shippingFree;

  public static final String JSON_PROPERTY_MARK_AS_TOPSELLER = "markAsTopseller";
  private Boolean markAsTopseller;

  public static final String JSON_PROPERTY_WEIGHT = "weight";
  private Float weight;

  public static final String JSON_PROPERTY_WIDTH = "width";
  private Float width;

  public static final String JSON_PROPERTY_HEIGHT = "height";
  private Float height;

  public static final String JSON_PROPERTY_LENGTH = "length";
  private Float length;

  public static final String JSON_PROPERTY_RELEASE_DATE = "releaseDate";
  private OffsetDateTime releaseDate;

  public static final String JSON_PROPERTY_RATING_AVERAGE = "ratingAverage";
  private Float ratingAverage;

  public static final String JSON_PROPERTY_CATEGORY_TREE = "categoryTree";
  private List<String> categoryTree = new ArrayList<>();

  public static final String JSON_PROPERTY_PROPERTY_IDS = "propertyIds";
  private List<String> propertyIds = new ArrayList<>();

  public static final String JSON_PROPERTY_OPTION_IDS = "optionIds";
  private List<String> optionIds = new ArrayList<>();

  public static final String JSON_PROPERTY_STREAM_IDS = "streamIds";
  private List<String> streamIds = new ArrayList<>();

  public static final String JSON_PROPERTY_TAG_IDS = "tagIds";
  private List<String> tagIds = new ArrayList<>();

  public static final String JSON_PROPERTY_CATEGORY_IDS = "categoryIds";
  private List<String> categoryIds = new ArrayList<>();

  public static final String JSON_PROPERTY_CHILD_COUNT = "childCount";
  private Long childCount;

  public static final String JSON_PROPERTY_SALES = "sales";
  private Long sales;

  public static final String JSON_PROPERTY_STATES = "states";
  private List<String> states = new ArrayList<>();

  public static final String JSON_PROPERTY_META_DESCRIPTION = "metaDescription";
  private String metaDescription;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_KEYWORDS = "keywords";
  private String keywords;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_META_TITLE = "metaTitle";
  private String metaTitle;

  public static final String JSON_PROPERTY_PACK_UNIT = "packUnit";
  private String packUnit;

  public static final String JSON_PROPERTY_PACK_UNIT_PLURAL = "packUnitPlural";
  private String packUnitPlural;

  public static final String JSON_PROPERTY_CUSTOM_FIELDS = "customFields";
  private Object customFields;

  public static final String JSON_PROPERTY_AVAILABLE_STOCK = "availableStock";
  private Long availableStock;

  public static final String JSON_PROPERTY_STOCK = "stock";
  private Long stock;

  public static final String JSON_PROPERTY_CALCULATED_PRICE = "calculatedPrice";
  private Object calculatedPrice;

  public static final String JSON_PROPERTY_CALCULATED_PRICES = "calculatedPrices";
  private List<Object> calculatedPrices = new ArrayList<>();

  public static final String JSON_PROPERTY_CALCULATED_MAX_PURCHASE = "calculatedMaxPurchase";
  private Long calculatedMaxPurchase;

  public static final String JSON_PROPERTY_CALCULATED_CHEAPEST_PRICE = "calculatedCheapestPrice";
  private Object calculatedCheapestPrice;

  public static final String JSON_PROPERTY_IS_NEW = "isNew";
  private Boolean isNew;

  public static final String JSON_PROPERTY_SORTED_PROPERTIES = "sortedProperties";
  private Object sortedProperties;

  public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
  private OffsetDateTime createdAt;

  public static final String JSON_PROPERTY_UPDATED_AT = "updatedAt";
  private OffsetDateTime updatedAt;

  public static final String JSON_PROPERTY_TRANSLATED = "translated";
  private Object translated;

  public ProductJsonApi() {
  }

  @JsonCreator
  public ProductJsonApi(
    @JsonProperty(JSON_PROPERTY_AVAILABLE) Boolean available, 
    @JsonProperty(JSON_PROPERTY_DISPLAY_GROUP) String displayGroup, 
    @JsonProperty(JSON_PROPERTY_RATING_AVERAGE) Float ratingAverage, 
    @JsonProperty(JSON_PROPERTY_CATEGORY_TREE) List<String> categoryTree, 
    @JsonProperty(JSON_PROPERTY_PROPERTY_IDS) List<String> propertyIds, 
    @JsonProperty(JSON_PROPERTY_OPTION_IDS) List<String> optionIds, 
    @JsonProperty(JSON_PROPERTY_STREAM_IDS) List<String> streamIds, 
    @JsonProperty(JSON_PROPERTY_TAG_IDS) List<String> tagIds, 
    @JsonProperty(JSON_PROPERTY_CATEGORY_IDS) List<String> categoryIds, 
    @JsonProperty(JSON_PROPERTY_CHILD_COUNT) Long childCount, 
    @JsonProperty(JSON_PROPERTY_SALES) Long sales, 
    @JsonProperty(JSON_PROPERTY_STATES) List<String> states, 
    @JsonProperty(JSON_PROPERTY_CREATED_AT) OffsetDateTime createdAt, 
    @JsonProperty(JSON_PROPERTY_UPDATED_AT) OffsetDateTime updatedAt
  ) {
    this();
    this.available = available;
    this.displayGroup = displayGroup;
    this.ratingAverage = ratingAverage;
    this.categoryTree = categoryTree;
    this.propertyIds = propertyIds;
    this.optionIds = optionIds;
    this.streamIds = streamIds;
    this.tagIds = tagIds;
    this.categoryIds = categoryIds;
    this.childCount = childCount;
    this.sales = sales;
    this.states = states;
    this.createdAt = createdAt;
    this.updatedAt = updatedAt;
  }

  public ProductJsonApi type(String type) {
    
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(String type) {
    this.type = type;
  }


  public ProductJsonApi id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setId(String id) {
    this.id = id;
  }


  public ProductJsonApi attributes(Map<String, Object> attributes) {
    
    this.attributes = attributes;
    return this;
  }

  public ProductJsonApi putAttributesItem(String key, Object attributesItem) {
    if (this.attributes == null) {
      this.attributes = new HashMap<>();
    }
    this.attributes.put(key, attributesItem);
    return this;
  }

   /**
   * Members of the attributes object (\&quot;attributes\&quot;) represent information about the resource object in which it&#39;s defined.
   * @return attributes
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ATTRIBUTES)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Object> getAttributes() {
    return attributes;
  }


  @JsonProperty(JSON_PROPERTY_ATTRIBUTES)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)
  public void setAttributes(Map<String, Object> attributes) {
    this.attributes = attributes;
  }


  public ProductJsonApi relationships(ProductJsonApiAllOfRelationships relationships) {
    
    this.relationships = relationships;
    return this;
  }

   /**
   * Get relationships
   * @return relationships
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_RELATIONSHIPS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ProductJsonApiAllOfRelationships getRelationships() {
    return relationships;
  }


  @JsonProperty(JSON_PROPERTY_RELATIONSHIPS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRelationships(ProductJsonApiAllOfRelationships relationships) {
    this.relationships = relationships;
  }


  public ProductJsonApi links(Map<String, Link> links) {
    
    this.links = links;
    return this;
  }

  public ProductJsonApi putLinksItem(String key, Link linksItem) {
    if (this.links == null) {
      this.links = new HashMap<>();
    }
    this.links.put(key, linksItem);
    return this;
  }

   /**
   * Get links
   * @return links
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Link> getLinks() {
    return links;
  }


  @JsonProperty(JSON_PROPERTY_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLinks(Map<String, Link> links) {
    this.links = links;
  }


  public ProductJsonApi meta(Map<String, Object> meta) {
    
    this.meta = meta;
    return this;
  }

  public ProductJsonApi putMetaItem(String key, Object metaItem) {
    if (this.meta == null) {
      this.meta = new HashMap<>();
    }
    this.meta.put(key, metaItem);
    return this;
  }

   /**
   * Non-standard meta-information that can not be represented as an attribute or relationship.
   * @return meta
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_META)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Object> getMeta() {
    return meta;
  }


  @JsonProperty(JSON_PROPERTY_META)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)
  public void setMeta(Map<String, Object> meta) {
    this.meta = meta;
  }


  public ProductJsonApi versionId(String versionId) {
    
    this.versionId = versionId;
    return this;
  }

   /**
   * Get versionId
   * @return versionId
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_VERSION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getVersionId() {
    return versionId;
  }


  @JsonProperty(JSON_PROPERTY_VERSION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVersionId(String versionId) {
    this.versionId = versionId;
  }


  public ProductJsonApi parentId(String parentId) {
    
    this.parentId = parentId;
    return this;
  }

   /**
   * Get parentId
   * @return parentId
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PARENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getParentId() {
    return parentId;
  }


  @JsonProperty(JSON_PROPERTY_PARENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setParentId(String parentId) {
    this.parentId = parentId;
  }


  public ProductJsonApi parentVersionId(String parentVersionId) {
    
    this.parentVersionId = parentVersionId;
    return this;
  }

   /**
   * Get parentVersionId
   * @return parentVersionId
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PARENT_VERSION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getParentVersionId() {
    return parentVersionId;
  }


  @JsonProperty(JSON_PROPERTY_PARENT_VERSION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setParentVersionId(String parentVersionId) {
    this.parentVersionId = parentVersionId;
  }


  public ProductJsonApi manufacturerId(String manufacturerId) {
    
    this.manufacturerId = manufacturerId;
    return this;
  }

   /**
   * Get manufacturerId
   * @return manufacturerId
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MANUFACTURER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getManufacturerId() {
    return manufacturerId;
  }


  @JsonProperty(JSON_PROPERTY_MANUFACTURER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setManufacturerId(String manufacturerId) {
    this.manufacturerId = manufacturerId;
  }


  public ProductJsonApi productManufacturerVersionId(String productManufacturerVersionId) {
    
    this.productManufacturerVersionId = productManufacturerVersionId;
    return this;
  }

   /**
   * Get productManufacturerVersionId
   * @return productManufacturerVersionId
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PRODUCT_MANUFACTURER_VERSION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProductManufacturerVersionId() {
    return productManufacturerVersionId;
  }


  @JsonProperty(JSON_PROPERTY_PRODUCT_MANUFACTURER_VERSION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProductManufacturerVersionId(String productManufacturerVersionId) {
    this.productManufacturerVersionId = productManufacturerVersionId;
  }


  public ProductJsonApi unitId(String unitId) {
    
    this.unitId = unitId;
    return this;
  }

   /**
   * Get unitId
   * @return unitId
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_UNIT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUnitId() {
    return unitId;
  }


  @JsonProperty(JSON_PROPERTY_UNIT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUnitId(String unitId) {
    this.unitId = unitId;
  }


  public ProductJsonApi taxId(String taxId) {
    
    this.taxId = taxId;
    return this;
  }

   /**
   * Get taxId
   * @return taxId
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_TAX_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getTaxId() {
    return taxId;
  }


  @JsonProperty(JSON_PROPERTY_TAX_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTaxId(String taxId) {
    this.taxId = taxId;
  }


  public ProductJsonApi coverId(String coverId) {
    
    this.coverId = coverId;
    return this;
  }

   /**
   * Get coverId
   * @return coverId
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_COVER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCoverId() {
    return coverId;
  }


  @JsonProperty(JSON_PROPERTY_COVER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCoverId(String coverId) {
    this.coverId = coverId;
  }


  public ProductJsonApi productMediaVersionId(String productMediaVersionId) {
    
    this.productMediaVersionId = productMediaVersionId;
    return this;
  }

   /**
   * Get productMediaVersionId
   * @return productMediaVersionId
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PRODUCT_MEDIA_VERSION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProductMediaVersionId() {
    return productMediaVersionId;
  }


  @JsonProperty(JSON_PROPERTY_PRODUCT_MEDIA_VERSION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProductMediaVersionId(String productMediaVersionId) {
    this.productMediaVersionId = productMediaVersionId;
  }


  public ProductJsonApi deliveryTimeId(String deliveryTimeId) {
    
    this.deliveryTimeId = deliveryTimeId;
    return this;
  }

   /**
   * Get deliveryTimeId
   * @return deliveryTimeId
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DELIVERY_TIME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDeliveryTimeId() {
    return deliveryTimeId;
  }


  @JsonProperty(JSON_PROPERTY_DELIVERY_TIME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeliveryTimeId(String deliveryTimeId) {
    this.deliveryTimeId = deliveryTimeId;
  }


  public ProductJsonApi canonicalProductId(String canonicalProductId) {
    
    this.canonicalProductId = canonicalProductId;
    return this;
  }

   /**
   * Get canonicalProductId
   * @return canonicalProductId
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CANONICAL_PRODUCT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCanonicalProductId() {
    return canonicalProductId;
  }


  @JsonProperty(JSON_PROPERTY_CANONICAL_PRODUCT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCanonicalProductId(String canonicalProductId) {
    this.canonicalProductId = canonicalProductId;
  }


  public ProductJsonApi cmsPageId(String cmsPageId) {
    
    this.cmsPageId = cmsPageId;
    return this;
  }

   /**
   * Get cmsPageId
   * @return cmsPageId
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CMS_PAGE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCmsPageId() {
    return cmsPageId;
  }


  @JsonProperty(JSON_PROPERTY_CMS_PAGE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCmsPageId(String cmsPageId) {
    this.cmsPageId = cmsPageId;
  }


  public ProductJsonApi cmsPageVersionId(String cmsPageVersionId) {
    
    this.cmsPageVersionId = cmsPageVersionId;
    return this;
  }

   /**
   * Get cmsPageVersionId
   * @return cmsPageVersionId
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CMS_PAGE_VERSION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCmsPageVersionId() {
    return cmsPageVersionId;
  }


  @JsonProperty(JSON_PROPERTY_CMS_PAGE_VERSION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCmsPageVersionId(String cmsPageVersionId) {
    this.cmsPageVersionId = cmsPageVersionId;
  }


  public ProductJsonApi productNumber(String productNumber) {
    
    this.productNumber = productNumber;
    return this;
  }

   /**
   * Get productNumber
   * @return productNumber
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_PRODUCT_NUMBER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getProductNumber() {
    return productNumber;
  }


  @JsonProperty(JSON_PROPERTY_PRODUCT_NUMBER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setProductNumber(String productNumber) {
    this.productNumber = productNumber;
  }


  public ProductJsonApi restockTime(Long restockTime) {
    
    this.restockTime = restockTime;
    return this;
  }

   /**
   * Get restockTime
   * @return restockTime
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_RESTOCK_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getRestockTime() {
    return restockTime;
  }


  @JsonProperty(JSON_PROPERTY_RESTOCK_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRestockTime(Long restockTime) {
    this.restockTime = restockTime;
  }


  public ProductJsonApi active(Boolean active) {
    
    this.active = active;
    return this;
  }

   /**
   * Get active
   * @return active
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getActive() {
    return active;
  }


  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setActive(Boolean active) {
    this.active = active;
  }


   /**
   * Get available
   * @return available
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAvailable() {
    return available;
  }




  public ProductJsonApi isCloseout(Boolean isCloseout) {
    
    this.isCloseout = isCloseout;
    return this;
  }

   /**
   * Get isCloseout
   * @return isCloseout
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_IS_CLOSEOUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIsCloseout() {
    return isCloseout;
  }


  @JsonProperty(JSON_PROPERTY_IS_CLOSEOUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsCloseout(Boolean isCloseout) {
    this.isCloseout = isCloseout;
  }


   /**
   * Get displayGroup
   * @return displayGroup
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DISPLAY_GROUP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDisplayGroup() {
    return displayGroup;
  }




  public ProductJsonApi manufacturerNumber(String manufacturerNumber) {
    
    this.manufacturerNumber = manufacturerNumber;
    return this;
  }

   /**
   * Get manufacturerNumber
   * @return manufacturerNumber
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MANUFACTURER_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getManufacturerNumber() {
    return manufacturerNumber;
  }


  @JsonProperty(JSON_PROPERTY_MANUFACTURER_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setManufacturerNumber(String manufacturerNumber) {
    this.manufacturerNumber = manufacturerNumber;
  }


  public ProductJsonApi ean(String ean) {
    
    this.ean = ean;
    return this;
  }

   /**
   * Get ean
   * @return ean
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_EAN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getEan() {
    return ean;
  }


  @JsonProperty(JSON_PROPERTY_EAN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEan(String ean) {
    this.ean = ean;
  }


  public ProductJsonApi purchaseSteps(Long purchaseSteps) {
    
    this.purchaseSteps = purchaseSteps;
    return this;
  }

   /**
   * Get purchaseSteps
   * @return purchaseSteps
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PURCHASE_STEPS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getPurchaseSteps() {
    return purchaseSteps;
  }


  @JsonProperty(JSON_PROPERTY_PURCHASE_STEPS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPurchaseSteps(Long purchaseSteps) {
    this.purchaseSteps = purchaseSteps;
  }


  public ProductJsonApi maxPurchase(Long maxPurchase) {
    
    this.maxPurchase = maxPurchase;
    return this;
  }

   /**
   * Get maxPurchase
   * @return maxPurchase
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MAX_PURCHASE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getMaxPurchase() {
    return maxPurchase;
  }


  @JsonProperty(JSON_PROPERTY_MAX_PURCHASE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxPurchase(Long maxPurchase) {
    this.maxPurchase = maxPurchase;
  }


  public ProductJsonApi minPurchase(Long minPurchase) {
    
    this.minPurchase = minPurchase;
    return this;
  }

   /**
   * Get minPurchase
   * @return minPurchase
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MIN_PURCHASE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getMinPurchase() {
    return minPurchase;
  }


  @JsonProperty(JSON_PROPERTY_MIN_PURCHASE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinPurchase(Long minPurchase) {
    this.minPurchase = minPurchase;
  }


  public ProductJsonApi purchaseUnit(Float purchaseUnit) {
    
    this.purchaseUnit = purchaseUnit;
    return this;
  }

   /**
   * Get purchaseUnit
   * @return purchaseUnit
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PURCHASE_UNIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getPurchaseUnit() {
    return purchaseUnit;
  }


  @JsonProperty(JSON_PROPERTY_PURCHASE_UNIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPurchaseUnit(Float purchaseUnit) {
    this.purchaseUnit = purchaseUnit;
  }


  public ProductJsonApi referenceUnit(Float referenceUnit) {
    
    this.referenceUnit = referenceUnit;
    return this;
  }

   /**
   * Get referenceUnit
   * @return referenceUnit
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_REFERENCE_UNIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getReferenceUnit() {
    return referenceUnit;
  }


  @JsonProperty(JSON_PROPERTY_REFERENCE_UNIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReferenceUnit(Float referenceUnit) {
    this.referenceUnit = referenceUnit;
  }


  public ProductJsonApi shippingFree(Boolean shippingFree) {
    
    this.shippingFree = shippingFree;
    return this;
  }

   /**
   * Get shippingFree
   * @return shippingFree
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SHIPPING_FREE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShippingFree() {
    return shippingFree;
  }


  @JsonProperty(JSON_PROPERTY_SHIPPING_FREE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShippingFree(Boolean shippingFree) {
    this.shippingFree = shippingFree;
  }


  public ProductJsonApi markAsTopseller(Boolean markAsTopseller) {
    
    this.markAsTopseller = markAsTopseller;
    return this;
  }

   /**
   * Get markAsTopseller
   * @return markAsTopseller
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MARK_AS_TOPSELLER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getMarkAsTopseller() {
    return markAsTopseller;
  }


  @JsonProperty(JSON_PROPERTY_MARK_AS_TOPSELLER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMarkAsTopseller(Boolean markAsTopseller) {
    this.markAsTopseller = markAsTopseller;
  }


  public ProductJsonApi weight(Float weight) {
    
    this.weight = weight;
    return this;
  }

   /**
   * Get weight
   * @return weight
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_WEIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getWeight() {
    return weight;
  }


  @JsonProperty(JSON_PROPERTY_WEIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWeight(Float weight) {
    this.weight = weight;
  }


  public ProductJsonApi width(Float width) {
    
    this.width = width;
    return this;
  }

   /**
   * Get width
   * @return width
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_WIDTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getWidth() {
    return width;
  }


  @JsonProperty(JSON_PROPERTY_WIDTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWidth(Float width) {
    this.width = width;
  }


  public ProductJsonApi height(Float height) {
    
    this.height = height;
    return this;
  }

   /**
   * Get height
   * @return height
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_HEIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getHeight() {
    return height;
  }


  @JsonProperty(JSON_PROPERTY_HEIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHeight(Float height) {
    this.height = height;
  }


  public ProductJsonApi length(Float length) {
    
    this.length = length;
    return this;
  }

   /**
   * Get length
   * @return length
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LENGTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getLength() {
    return length;
  }


  @JsonProperty(JSON_PROPERTY_LENGTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLength(Float length) {
    this.length = length;
  }


  public ProductJsonApi releaseDate(OffsetDateTime releaseDate) {
    
    this.releaseDate = releaseDate;
    return this;
  }

   /**
   * Get releaseDate
   * @return releaseDate
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_RELEASE_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getReleaseDate() {
    return releaseDate;
  }


  @JsonProperty(JSON_PROPERTY_RELEASE_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReleaseDate(OffsetDateTime releaseDate) {
    this.releaseDate = releaseDate;
  }


   /**
   * Get ratingAverage
   * @return ratingAverage
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_RATING_AVERAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getRatingAverage() {
    return ratingAverage;
  }




   /**
   * Get categoryTree
   * @return categoryTree
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CATEGORY_TREE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getCategoryTree() {
    return categoryTree;
  }




   /**
   * Get propertyIds
   * @return propertyIds
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROPERTY_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getPropertyIds() {
    return propertyIds;
  }




   /**
   * Get optionIds
   * @return optionIds
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_OPTION_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getOptionIds() {
    return optionIds;
  }




   /**
   * Get streamIds
   * @return streamIds
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_STREAM_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getStreamIds() {
    return streamIds;
  }




   /**
   * Get tagIds
   * @return tagIds
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TAG_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getTagIds() {
    return tagIds;
  }




   /**
   * Get categoryIds
   * @return categoryIds
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CATEGORY_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getCategoryIds() {
    return categoryIds;
  }




   /**
   * Get childCount
   * @return childCount
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CHILD_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getChildCount() {
    return childCount;
  }




   /**
   * Get sales
   * @return sales
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SALES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getSales() {
    return sales;
  }




   /**
   * Get states
   * @return states
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_STATES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getStates() {
    return states;
  }




  public ProductJsonApi metaDescription(String metaDescription) {
    
    this.metaDescription = metaDescription;
    return this;
  }

   /**
   * Get metaDescription
   * @return metaDescription
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_META_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMetaDescription() {
    return metaDescription;
  }


  @JsonProperty(JSON_PROPERTY_META_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetaDescription(String metaDescription) {
    this.metaDescription = metaDescription;
  }


  public ProductJsonApi name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public ProductJsonApi keywords(String keywords) {
    
    this.keywords = keywords;
    return this;
  }

   /**
   * Get keywords
   * @return keywords
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_KEYWORDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getKeywords() {
    return keywords;
  }


  @JsonProperty(JSON_PROPERTY_KEYWORDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setKeywords(String keywords) {
    this.keywords = keywords;
  }


  public ProductJsonApi description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * Get description
   * @return description
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }


  public ProductJsonApi metaTitle(String metaTitle) {
    
    this.metaTitle = metaTitle;
    return this;
  }

   /**
   * Get metaTitle
   * @return metaTitle
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_META_TITLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMetaTitle() {
    return metaTitle;
  }


  @JsonProperty(JSON_PROPERTY_META_TITLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetaTitle(String metaTitle) {
    this.metaTitle = metaTitle;
  }


  public ProductJsonApi packUnit(String packUnit) {
    
    this.packUnit = packUnit;
    return this;
  }

   /**
   * Get packUnit
   * @return packUnit
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PACK_UNIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPackUnit() {
    return packUnit;
  }


  @JsonProperty(JSON_PROPERTY_PACK_UNIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPackUnit(String packUnit) {
    this.packUnit = packUnit;
  }


  public ProductJsonApi packUnitPlural(String packUnitPlural) {
    
    this.packUnitPlural = packUnitPlural;
    return this;
  }

   /**
   * Get packUnitPlural
   * @return packUnitPlural
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PACK_UNIT_PLURAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPackUnitPlural() {
    return packUnitPlural;
  }


  @JsonProperty(JSON_PROPERTY_PACK_UNIT_PLURAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPackUnitPlural(String packUnitPlural) {
    this.packUnitPlural = packUnitPlural;
  }


  public ProductJsonApi customFields(Object customFields) {
    
    this.customFields = customFields;
    return this;
  }

   /**
   * Get customFields
   * @return customFields
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CUSTOM_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getCustomFields() {
    return customFields;
  }


  @JsonProperty(JSON_PROPERTY_CUSTOM_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCustomFields(Object customFields) {
    this.customFields = customFields;
  }


  public ProductJsonApi availableStock(Long availableStock) {
    
    this.availableStock = availableStock;
    return this;
  }

   /**
   * Get availableStock
   * @return availableStock
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_AVAILABLE_STOCK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getAvailableStock() {
    return availableStock;
  }


  @JsonProperty(JSON_PROPERTY_AVAILABLE_STOCK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAvailableStock(Long availableStock) {
    this.availableStock = availableStock;
  }


  public ProductJsonApi stock(Long stock) {
    
    this.stock = stock;
    return this;
  }

   /**
   * Get stock
   * @return stock
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_STOCK)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Long getStock() {
    return stock;
  }


  @JsonProperty(JSON_PROPERTY_STOCK)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStock(Long stock) {
    this.stock = stock;
  }


  public ProductJsonApi calculatedPrice(Object calculatedPrice) {
    
    this.calculatedPrice = calculatedPrice;
    return this;
  }

   /**
   * Get calculatedPrice
   * @return calculatedPrice
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CALCULATED_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getCalculatedPrice() {
    return calculatedPrice;
  }


  @JsonProperty(JSON_PROPERTY_CALCULATED_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCalculatedPrice(Object calculatedPrice) {
    this.calculatedPrice = calculatedPrice;
  }


  public ProductJsonApi calculatedPrices(List<Object> calculatedPrices) {
    
    this.calculatedPrices = calculatedPrices;
    return this;
  }

  public ProductJsonApi addCalculatedPricesItem(Object calculatedPricesItem) {
    if (this.calculatedPrices == null) {
      this.calculatedPrices = new ArrayList<>();
    }
    this.calculatedPrices.add(calculatedPricesItem);
    return this;
  }

   /**
   * Get calculatedPrices
   * @return calculatedPrices
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CALCULATED_PRICES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Object> getCalculatedPrices() {
    return calculatedPrices;
  }


  @JsonProperty(JSON_PROPERTY_CALCULATED_PRICES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCalculatedPrices(List<Object> calculatedPrices) {
    this.calculatedPrices = calculatedPrices;
  }


  public ProductJsonApi calculatedMaxPurchase(Long calculatedMaxPurchase) {
    
    this.calculatedMaxPurchase = calculatedMaxPurchase;
    return this;
  }

   /**
   * Runtime field, cannot be used as part of the criteria.
   * @return calculatedMaxPurchase
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CALCULATED_MAX_PURCHASE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getCalculatedMaxPurchase() {
    return calculatedMaxPurchase;
  }


  @JsonProperty(JSON_PROPERTY_CALCULATED_MAX_PURCHASE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCalculatedMaxPurchase(Long calculatedMaxPurchase) {
    this.calculatedMaxPurchase = calculatedMaxPurchase;
  }


  public ProductJsonApi calculatedCheapestPrice(Object calculatedCheapestPrice) {
    
    this.calculatedCheapestPrice = calculatedCheapestPrice;
    return this;
  }

   /**
   * Get calculatedCheapestPrice
   * @return calculatedCheapestPrice
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CALCULATED_CHEAPEST_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getCalculatedCheapestPrice() {
    return calculatedCheapestPrice;
  }


  @JsonProperty(JSON_PROPERTY_CALCULATED_CHEAPEST_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCalculatedCheapestPrice(Object calculatedCheapestPrice) {
    this.calculatedCheapestPrice = calculatedCheapestPrice;
  }


  public ProductJsonApi isNew(Boolean isNew) {
    
    this.isNew = isNew;
    return this;
  }

   /**
   * Runtime field, cannot be used as part of the criteria.
   * @return isNew
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_IS_NEW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIsNew() {
    return isNew;
  }


  @JsonProperty(JSON_PROPERTY_IS_NEW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsNew(Boolean isNew) {
    this.isNew = isNew;
  }


  public ProductJsonApi sortedProperties(Object sortedProperties) {
    
    this.sortedProperties = sortedProperties;
    return this;
  }

   /**
   * Get sortedProperties
   * @return sortedProperties
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SORTED_PROPERTIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getSortedProperties() {
    return sortedProperties;
  }


  @JsonProperty(JSON_PROPERTY_SORTED_PROPERTIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortedProperties(Object sortedProperties) {
    this.sortedProperties = sortedProperties;
  }


   /**
   * Get createdAt
   * @return createdAt
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }




   /**
   * Get updatedAt
   * @return updatedAt
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getUpdatedAt() {
    return updatedAt;
  }




  public ProductJsonApi translated(Object translated) {
    
    this.translated = translated;
    return this;
  }

   /**
   * Get translated
   * @return translated
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TRANSLATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getTranslated() {
    return translated;
  }


  @JsonProperty(JSON_PROPERTY_TRANSLATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTranslated(Object translated) {
    this.translated = translated;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ProductJsonApi productJsonApi = (ProductJsonApi) o;
    return Objects.equals(this.type, productJsonApi.type) &&
        Objects.equals(this.id, productJsonApi.id) &&
        Objects.equals(this.attributes, productJsonApi.attributes) &&
        Objects.equals(this.relationships, productJsonApi.relationships) &&
        Objects.equals(this.links, productJsonApi.links) &&
        Objects.equals(this.meta, productJsonApi.meta) &&
        Objects.equals(this.versionId, productJsonApi.versionId) &&
        Objects.equals(this.parentId, productJsonApi.parentId) &&
        Objects.equals(this.parentVersionId, productJsonApi.parentVersionId) &&
        Objects.equals(this.manufacturerId, productJsonApi.manufacturerId) &&
        Objects.equals(this.productManufacturerVersionId, productJsonApi.productManufacturerVersionId) &&
        Objects.equals(this.unitId, productJsonApi.unitId) &&
        Objects.equals(this.taxId, productJsonApi.taxId) &&
        Objects.equals(this.coverId, productJsonApi.coverId) &&
        Objects.equals(this.productMediaVersionId, productJsonApi.productMediaVersionId) &&
        Objects.equals(this.deliveryTimeId, productJsonApi.deliveryTimeId) &&
        Objects.equals(this.canonicalProductId, productJsonApi.canonicalProductId) &&
        Objects.equals(this.cmsPageId, productJsonApi.cmsPageId) &&
        Objects.equals(this.cmsPageVersionId, productJsonApi.cmsPageVersionId) &&
        Objects.equals(this.productNumber, productJsonApi.productNumber) &&
        Objects.equals(this.restockTime, productJsonApi.restockTime) &&
        Objects.equals(this.active, productJsonApi.active) &&
        Objects.equals(this.available, productJsonApi.available) &&
        Objects.equals(this.isCloseout, productJsonApi.isCloseout) &&
        Objects.equals(this.displayGroup, productJsonApi.displayGroup) &&
        Objects.equals(this.manufacturerNumber, productJsonApi.manufacturerNumber) &&
        Objects.equals(this.ean, productJsonApi.ean) &&
        Objects.equals(this.purchaseSteps, productJsonApi.purchaseSteps) &&
        Objects.equals(this.maxPurchase, productJsonApi.maxPurchase) &&
        Objects.equals(this.minPurchase, productJsonApi.minPurchase) &&
        Objects.equals(this.purchaseUnit, productJsonApi.purchaseUnit) &&
        Objects.equals(this.referenceUnit, productJsonApi.referenceUnit) &&
        Objects.equals(this.shippingFree, productJsonApi.shippingFree) &&
        Objects.equals(this.markAsTopseller, productJsonApi.markAsTopseller) &&
        Objects.equals(this.weight, productJsonApi.weight) &&
        Objects.equals(this.width, productJsonApi.width) &&
        Objects.equals(this.height, productJsonApi.height) &&
        Objects.equals(this.length, productJsonApi.length) &&
        Objects.equals(this.releaseDate, productJsonApi.releaseDate) &&
        Objects.equals(this.ratingAverage, productJsonApi.ratingAverage) &&
        Objects.equals(this.categoryTree, productJsonApi.categoryTree) &&
        Objects.equals(this.propertyIds, productJsonApi.propertyIds) &&
        Objects.equals(this.optionIds, productJsonApi.optionIds) &&
        Objects.equals(this.streamIds, productJsonApi.streamIds) &&
        Objects.equals(this.tagIds, productJsonApi.tagIds) &&
        Objects.equals(this.categoryIds, productJsonApi.categoryIds) &&
        Objects.equals(this.childCount, productJsonApi.childCount) &&
        Objects.equals(this.sales, productJsonApi.sales) &&
        Objects.equals(this.states, productJsonApi.states) &&
        Objects.equals(this.metaDescription, productJsonApi.metaDescription) &&
        Objects.equals(this.name, productJsonApi.name) &&
        Objects.equals(this.keywords, productJsonApi.keywords) &&
        Objects.equals(this.description, productJsonApi.description) &&
        Objects.equals(this.metaTitle, productJsonApi.metaTitle) &&
        Objects.equals(this.packUnit, productJsonApi.packUnit) &&
        Objects.equals(this.packUnitPlural, productJsonApi.packUnitPlural) &&
        Objects.equals(this.customFields, productJsonApi.customFields) &&
        Objects.equals(this.availableStock, productJsonApi.availableStock) &&
        Objects.equals(this.stock, productJsonApi.stock) &&
        Objects.equals(this.calculatedPrice, productJsonApi.calculatedPrice) &&
        Objects.equals(this.calculatedPrices, productJsonApi.calculatedPrices) &&
        Objects.equals(this.calculatedMaxPurchase, productJsonApi.calculatedMaxPurchase) &&
        Objects.equals(this.calculatedCheapestPrice, productJsonApi.calculatedCheapestPrice) &&
        Objects.equals(this.isNew, productJsonApi.isNew) &&
        Objects.equals(this.sortedProperties, productJsonApi.sortedProperties) &&
        Objects.equals(this.createdAt, productJsonApi.createdAt) &&
        Objects.equals(this.updatedAt, productJsonApi.updatedAt) &&
        Objects.equals(this.translated, productJsonApi.translated);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, id, attributes, relationships, links, meta, versionId, parentId, parentVersionId, manufacturerId, productManufacturerVersionId, unitId, taxId, coverId, productMediaVersionId, deliveryTimeId, canonicalProductId, cmsPageId, cmsPageVersionId, productNumber, restockTime, active, available, isCloseout, displayGroup, manufacturerNumber, ean, purchaseSteps, maxPurchase, minPurchase, purchaseUnit, referenceUnit, shippingFree, markAsTopseller, weight, width, height, length, releaseDate, ratingAverage, categoryTree, propertyIds, optionIds, streamIds, tagIds, categoryIds, childCount, sales, states, metaDescription, name, keywords, description, metaTitle, packUnit, packUnitPlural, customFields, availableStock, stock, calculatedPrice, calculatedPrices, calculatedMaxPurchase, calculatedCheapestPrice, isNew, sortedProperties, createdAt, updatedAt, translated);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ProductJsonApi {\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    attributes: ").append(toIndentedString(attributes)).append("\n");
    sb.append("    relationships: ").append(toIndentedString(relationships)).append("\n");
    sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("    meta: ").append(toIndentedString(meta)).append("\n");
    sb.append("    versionId: ").append(toIndentedString(versionId)).append("\n");
    sb.append("    parentId: ").append(toIndentedString(parentId)).append("\n");
    sb.append("    parentVersionId: ").append(toIndentedString(parentVersionId)).append("\n");
    sb.append("    manufacturerId: ").append(toIndentedString(manufacturerId)).append("\n");
    sb.append("    productManufacturerVersionId: ").append(toIndentedString(productManufacturerVersionId)).append("\n");
    sb.append("    unitId: ").append(toIndentedString(unitId)).append("\n");
    sb.append("    taxId: ").append(toIndentedString(taxId)).append("\n");
    sb.append("    coverId: ").append(toIndentedString(coverId)).append("\n");
    sb.append("    productMediaVersionId: ").append(toIndentedString(productMediaVersionId)).append("\n");
    sb.append("    deliveryTimeId: ").append(toIndentedString(deliveryTimeId)).append("\n");
    sb.append("    canonicalProductId: ").append(toIndentedString(canonicalProductId)).append("\n");
    sb.append("    cmsPageId: ").append(toIndentedString(cmsPageId)).append("\n");
    sb.append("    cmsPageVersionId: ").append(toIndentedString(cmsPageVersionId)).append("\n");
    sb.append("    productNumber: ").append(toIndentedString(productNumber)).append("\n");
    sb.append("    restockTime: ").append(toIndentedString(restockTime)).append("\n");
    sb.append("    active: ").append(toIndentedString(active)).append("\n");
    sb.append("    available: ").append(toIndentedString(available)).append("\n");
    sb.append("    isCloseout: ").append(toIndentedString(isCloseout)).append("\n");
    sb.append("    displayGroup: ").append(toIndentedString(displayGroup)).append("\n");
    sb.append("    manufacturerNumber: ").append(toIndentedString(manufacturerNumber)).append("\n");
    sb.append("    ean: ").append(toIndentedString(ean)).append("\n");
    sb.append("    purchaseSteps: ").append(toIndentedString(purchaseSteps)).append("\n");
    sb.append("    maxPurchase: ").append(toIndentedString(maxPurchase)).append("\n");
    sb.append("    minPurchase: ").append(toIndentedString(minPurchase)).append("\n");
    sb.append("    purchaseUnit: ").append(toIndentedString(purchaseUnit)).append("\n");
    sb.append("    referenceUnit: ").append(toIndentedString(referenceUnit)).append("\n");
    sb.append("    shippingFree: ").append(toIndentedString(shippingFree)).append("\n");
    sb.append("    markAsTopseller: ").append(toIndentedString(markAsTopseller)).append("\n");
    sb.append("    weight: ").append(toIndentedString(weight)).append("\n");
    sb.append("    width: ").append(toIndentedString(width)).append("\n");
    sb.append("    height: ").append(toIndentedString(height)).append("\n");
    sb.append("    length: ").append(toIndentedString(length)).append("\n");
    sb.append("    releaseDate: ").append(toIndentedString(releaseDate)).append("\n");
    sb.append("    ratingAverage: ").append(toIndentedString(ratingAverage)).append("\n");
    sb.append("    categoryTree: ").append(toIndentedString(categoryTree)).append("\n");
    sb.append("    propertyIds: ").append(toIndentedString(propertyIds)).append("\n");
    sb.append("    optionIds: ").append(toIndentedString(optionIds)).append("\n");
    sb.append("    streamIds: ").append(toIndentedString(streamIds)).append("\n");
    sb.append("    tagIds: ").append(toIndentedString(tagIds)).append("\n");
    sb.append("    categoryIds: ").append(toIndentedString(categoryIds)).append("\n");
    sb.append("    childCount: ").append(toIndentedString(childCount)).append("\n");
    sb.append("    sales: ").append(toIndentedString(sales)).append("\n");
    sb.append("    states: ").append(toIndentedString(states)).append("\n");
    sb.append("    metaDescription: ").append(toIndentedString(metaDescription)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    keywords: ").append(toIndentedString(keywords)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    metaTitle: ").append(toIndentedString(metaTitle)).append("\n");
    sb.append("    packUnit: ").append(toIndentedString(packUnit)).append("\n");
    sb.append("    packUnitPlural: ").append(toIndentedString(packUnitPlural)).append("\n");
    sb.append("    customFields: ").append(toIndentedString(customFields)).append("\n");
    sb.append("    availableStock: ").append(toIndentedString(availableStock)).append("\n");
    sb.append("    stock: ").append(toIndentedString(stock)).append("\n");
    sb.append("    calculatedPrice: ").append(toIndentedString(calculatedPrice)).append("\n");
    sb.append("    calculatedPrices: ").append(toIndentedString(calculatedPrices)).append("\n");
    sb.append("    calculatedMaxPurchase: ").append(toIndentedString(calculatedMaxPurchase)).append("\n");
    sb.append("    calculatedCheapestPrice: ").append(toIndentedString(calculatedCheapestPrice)).append("\n");
    sb.append("    isNew: ").append(toIndentedString(isNew)).append("\n");
    sb.append("    sortedProperties: ").append(toIndentedString(sortedProperties)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("    translated: ").append(toIndentedString(translated)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

