/*
 * Shopware Store API
 * This endpoint reference contains an overview of all endpoints comprising the Shopware Store API
 *
 * The version of the OpenAPI document: 6.5.7.3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package de.codebarista.shopware.model.core;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.openapitools.jackson.nullable.JsonNullable;

import java.util.Arrays;
import java.util.Objects;

/**
 * Additional flags for product listings
 */
@JsonPropertyOrder({
  ProductListingFlags.JSON_PROPERTY_NO_AGGREGATIONS,
  ProductListingFlags.JSON_PROPERTY_ONLY_AGGREGATIONS
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-10T11:26:02.541008353+02:00[Europe/Berlin]", comments = "Generator version: 7.5.0")
public class ProductListingFlags {
  public static final String JSON_PROPERTY_NO_AGGREGATIONS = "no-aggregations";
  private JsonNullable<String> noAggregations = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ONLY_AGGREGATIONS = "only-aggregations";
  private JsonNullable<String> onlyAggregations = JsonNullable.<String>undefined();

  public ProductListingFlags() {
  }

  public ProductListingFlags noAggregations(String noAggregations) {
    this.noAggregations = JsonNullable.<String>of(noAggregations);
    
    return this;
  }

   /**
   * Resets all aggregations in the criteria. This parameter is a flag, the value has no effect.
   * @return noAggregations
  **/
  @jakarta.annotation.Nullable
  @JsonIgnore

  public String getNoAggregations() {
        return noAggregations.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_NO_AGGREGATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getNoAggregations_JsonNullable() {
    return noAggregations;
  }
  
  @JsonProperty(JSON_PROPERTY_NO_AGGREGATIONS)
  public void setNoAggregations_JsonNullable(JsonNullable<String> noAggregations) {
    this.noAggregations = noAggregations;
  }

  public void setNoAggregations(String noAggregations) {
    this.noAggregations = JsonNullable.<String>of(noAggregations);
  }


  public ProductListingFlags onlyAggregations(String onlyAggregations) {
    this.onlyAggregations = JsonNullable.<String>of(onlyAggregations);
    
    return this;
  }

   /**
   * If this flag is set, no products are fetched. Sorting and associations are also ignored. This parameter is a flag, the value has no effect.
   * @return onlyAggregations
  **/
  @jakarta.annotation.Nullable
  @JsonIgnore

  public String getOnlyAggregations() {
        return onlyAggregations.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ONLY_AGGREGATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getOnlyAggregations_JsonNullable() {
    return onlyAggregations;
  }
  
  @JsonProperty(JSON_PROPERTY_ONLY_AGGREGATIONS)
  public void setOnlyAggregations_JsonNullable(JsonNullable<String> onlyAggregations) {
    this.onlyAggregations = onlyAggregations;
  }

  public void setOnlyAggregations(String onlyAggregations) {
    this.onlyAggregations = JsonNullable.<String>of(onlyAggregations);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ProductListingFlags productListingFlags = (ProductListingFlags) o;
    return equalsNullable(this.noAggregations, productListingFlags.noAggregations) &&
        equalsNullable(this.onlyAggregations, productListingFlags.onlyAggregations);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(noAggregations), hashCodeNullable(onlyAggregations));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ProductListingFlags {\n");
    sb.append("    noAggregations: ").append(toIndentedString(noAggregations)).append("\n");
    sb.append("    onlyAggregations: ").append(toIndentedString(onlyAggregations)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

