/*
 * Shopware Store API
 * This endpoint reference contains an overview of all endpoints comprising the Shopware Store API
 *
 * The version of the OpenAPI document: 6.5.7.3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package de.codebarista.shopware.model.core;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * ProductListingResult
 */
@JsonPropertyOrder({
  ProductListingResult.JSON_PROPERTY_API_ALIAS,
  ProductListingResult.JSON_PROPERTY_ENTITY,
  ProductListingResult.JSON_PROPERTY_TOTAL,
  ProductListingResult.JSON_PROPERTY_AGGREGATIONS,
  ProductListingResult.JSON_PROPERTY_PAGE,
  ProductListingResult.JSON_PROPERTY_LIMIT,
  ProductListingResult.JSON_PROPERTY_CURRENT_FILTERS,
  ProductListingResult.JSON_PROPERTY_AVAILABLE_SORTINGS,
  ProductListingResult.JSON_PROPERTY_SORTING,
  ProductListingResult.JSON_PROPERTY_ELEMENTS
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-10T11:26:02.541008353+02:00[Europe/Berlin]", comments = "Generator version: 7.5.0")
public class ProductListingResult {
  public static final String JSON_PROPERTY_API_ALIAS = "apiAlias";
  private String apiAlias;

  public static final String JSON_PROPERTY_ENTITY = "entity";
  private String entity;

  public static final String JSON_PROPERTY_TOTAL = "total";
  private Integer total;

  public static final String JSON_PROPERTY_AGGREGATIONS = "aggregations";
  private List<Object> aggregations = new ArrayList<>();

  public static final String JSON_PROPERTY_PAGE = "page";
  private Integer page;

  public static final String JSON_PROPERTY_LIMIT = "limit";
  private Integer limit;

  public static final String JSON_PROPERTY_CURRENT_FILTERS = "currentFilters";
  private ProductListingResultAllOfCurrentFilters currentFilters;

  public static final String JSON_PROPERTY_AVAILABLE_SORTINGS = "availableSortings";
  private List<Object> availableSortings = new ArrayList<>();

  public static final String JSON_PROPERTY_SORTING = "sorting";
  private String sorting;

  public static final String JSON_PROPERTY_ELEMENTS = "elements";
  private List<Product> elements = new ArrayList<>();

  public ProductListingResult() {
  }

  public ProductListingResult apiAlias(String apiAlias) {
    
    this.apiAlias = apiAlias;
    return this;
  }

   /**
   * Alias which can be used to restrict response fields. For more information see [includes](https://shopware.stoplight.io/docs/store-api/docs/concepts/search-queries.md#includes-apialias).
   * @return apiAlias
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_API_ALIAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getApiAlias() {
    return apiAlias;
  }


  @JsonProperty(JSON_PROPERTY_API_ALIAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setApiAlias(String apiAlias) {
    this.apiAlias = apiAlias;
  }


  public ProductListingResult entity(String entity) {
    
    this.entity = entity;
    return this;
  }

   /**
   * Get entity
   * @return entity
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ENTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getEntity() {
    return entity;
  }


  @JsonProperty(JSON_PROPERTY_ENTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEntity(String entity) {
    this.entity = entity;
  }


  public ProductListingResult total(Integer total) {
    
    this.total = total;
    return this;
  }

   /**
   * The total number of found entities
   * @return total
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getTotal() {
    return total;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotal(Integer total) {
    this.total = total;
  }


  public ProductListingResult aggregations(List<Object> aggregations) {
    
    this.aggregations = aggregations;
    return this;
  }

  public ProductListingResult addAggregationsItem(Object aggregationsItem) {
    if (this.aggregations == null) {
      this.aggregations = new ArrayList<>();
    }
    this.aggregations.add(aggregationsItem);
    return this;
  }

   /**
   * Contains aggregated data. A simple example is the determination of the average price from a product search query.
   * @return aggregations
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_AGGREGATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Object> getAggregations() {
    return aggregations;
  }


  @JsonProperty(JSON_PROPERTY_AGGREGATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAggregations(List<Object> aggregations) {
    this.aggregations = aggregations;
  }


  public ProductListingResult page(Integer page) {
    
    this.page = page;
    return this;
  }

   /**
   * The actual page. This can be used for pagination.
   * @return page
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPage() {
    return page;
  }


  @JsonProperty(JSON_PROPERTY_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPage(Integer page) {
    this.page = page;
  }


  public ProductListingResult limit(Integer limit) {
    
    this.limit = limit;
    return this;
  }

   /**
   * The actual limit. This is used for pagination and goes together with the page.
   * @return limit
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LIMIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getLimit() {
    return limit;
  }


  @JsonProperty(JSON_PROPERTY_LIMIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLimit(Integer limit) {
    this.limit = limit;
  }


  public ProductListingResult currentFilters(ProductListingResultAllOfCurrentFilters currentFilters) {
    
    this.currentFilters = currentFilters;
    return this;
  }

   /**
   * Get currentFilters
   * @return currentFilters
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CURRENT_FILTERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ProductListingResultAllOfCurrentFilters getCurrentFilters() {
    return currentFilters;
  }


  @JsonProperty(JSON_PROPERTY_CURRENT_FILTERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrentFilters(ProductListingResultAllOfCurrentFilters currentFilters) {
    this.currentFilters = currentFilters;
  }


  public ProductListingResult availableSortings(List<Object> availableSortings) {
    
    this.availableSortings = availableSortings;
    return this;
  }

  public ProductListingResult addAvailableSortingsItem(Object availableSortingsItem) {
    if (this.availableSortings == null) {
      this.availableSortings = new ArrayList<>();
    }
    this.availableSortings.add(availableSortingsItem);
    return this;
  }

   /**
   * Contains the available sorting. These can be used to show a sorting select-box in the product listing.
   * @return availableSortings
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_AVAILABLE_SORTINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Object> getAvailableSortings() {
    return availableSortings;
  }


  @JsonProperty(JSON_PROPERTY_AVAILABLE_SORTINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAvailableSortings(List<Object> availableSortings) {
    this.availableSortings = availableSortings;
  }


  public ProductListingResult sorting(String sorting) {
    
    this.sorting = sorting;
    return this;
  }

   /**
   * Get sorting
   * @return sorting
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SORTING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSorting() {
    return sorting;
  }


  @JsonProperty(JSON_PROPERTY_SORTING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSorting(String sorting) {
    this.sorting = sorting;
  }


  public ProductListingResult elements(List<Product> elements) {
    
    this.elements = elements;
    return this;
  }

  public ProductListingResult addElementsItem(Product elementsItem) {
    if (this.elements == null) {
      this.elements = new ArrayList<>();
    }
    this.elements.add(elementsItem);
    return this;
  }

   /**
   * Get elements
   * @return elements
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ELEMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Product> getElements() {
    return elements;
  }


  @JsonProperty(JSON_PROPERTY_ELEMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setElements(List<Product> elements) {
    this.elements = elements;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ProductListingResult productListingResult = (ProductListingResult) o;
    return Objects.equals(this.apiAlias, productListingResult.apiAlias) &&
        Objects.equals(this.entity, productListingResult.entity) &&
        Objects.equals(this.total, productListingResult.total) &&
        Objects.equals(this.aggregations, productListingResult.aggregations) &&
        Objects.equals(this.page, productListingResult.page) &&
        Objects.equals(this.limit, productListingResult.limit) &&
        Objects.equals(this.currentFilters, productListingResult.currentFilters) &&
        Objects.equals(this.availableSortings, productListingResult.availableSortings) &&
        Objects.equals(this.sorting, productListingResult.sorting) &&
        Objects.equals(this.elements, productListingResult.elements);
  }

  @Override
  public int hashCode() {
    return Objects.hash(apiAlias, entity, total, aggregations, page, limit, currentFilters, availableSortings, sorting, elements);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ProductListingResult {\n");
    sb.append("    apiAlias: ").append(toIndentedString(apiAlias)).append("\n");
    sb.append("    entity: ").append(toIndentedString(entity)).append("\n");
    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("    aggregations: ").append(toIndentedString(aggregations)).append("\n");
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("    limit: ").append(toIndentedString(limit)).append("\n");
    sb.append("    currentFilters: ").append(toIndentedString(currentFilters)).append("\n");
    sb.append("    availableSortings: ").append(toIndentedString(availableSortings)).append("\n");
    sb.append("    sorting: ").append(toIndentedString(sorting)).append("\n");
    sb.append("    elements: ").append(toIndentedString(elements)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

