/*
 * Shopware Store API
 * This endpoint reference contains an overview of all endpoints comprising the Shopware Store API
 *
 * The version of the OpenAPI document: 6.5.7.3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package de.codebarista.shopware.model.core;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import org.openapitools.jackson.nullable.JsonNullable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

/**
 * ReadCmsRequest
 */
@JsonPropertyOrder({
  ReadCmsRequest.JSON_PROPERTY_PAGE,
  ReadCmsRequest.JSON_PROPERTY_LIMIT,
  ReadCmsRequest.JSON_PROPERTY_FILTER,
  ReadCmsRequest.JSON_PROPERTY_SORT,
  ReadCmsRequest.JSON_PROPERTY_POST_FILTER,
  ReadCmsRequest.JSON_PROPERTY_ASSOCIATIONS,
  ReadCmsRequest.JSON_PROPERTY_AGGREGATIONS,
  ReadCmsRequest.JSON_PROPERTY_GROUPING,
  ReadCmsRequest.JSON_PROPERTY_FIELDS,
  ReadCmsRequest.JSON_PROPERTY_TOTAL_COUNT_MODE,
  ReadCmsRequest.JSON_PROPERTY_ORDER,
  ReadCmsRequest.JSON_PROPERTY_P,
  ReadCmsRequest.JSON_PROPERTY_MANUFACTURER,
  ReadCmsRequest.JSON_PROPERTY_MIN_PRICE,
  ReadCmsRequest.JSON_PROPERTY_MAX_PRICE,
  ReadCmsRequest.JSON_PROPERTY_RATING,
  ReadCmsRequest.JSON_PROPERTY_SHIPPING_FREE,
  ReadCmsRequest.JSON_PROPERTY_PROPERTIES,
  ReadCmsRequest.JSON_PROPERTY_MANUFACTURER_FILTER,
  ReadCmsRequest.JSON_PROPERTY_PRICE_FILTER,
  ReadCmsRequest.JSON_PROPERTY_RATING_FILTER,
  ReadCmsRequest.JSON_PROPERTY_SHIPPING_FREE_FILTER,
  ReadCmsRequest.JSON_PROPERTY_PROPERTY_FILTER,
  ReadCmsRequest.JSON_PROPERTY_PROPERTY_WHITELIST,
  ReadCmsRequest.JSON_PROPERTY_REDUCE_AGGREGATIONS,
  ReadCmsRequest.JSON_PROPERTY_SLOTS
})
@JsonTypeName("readCms_request")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-10T11:26:02.541008353+02:00[Europe/Berlin]", comments = "Generator version: 7.5.0")
public class ReadCmsRequest {
  public static final String JSON_PROPERTY_PAGE = "page";
  private Integer page;

  public static final String JSON_PROPERTY_LIMIT = "limit";
  private Integer limit;

  public static final String JSON_PROPERTY_FILTER = "filter";
  private List<CriteriaFilterInner> filter = new ArrayList<>();

  public static final String JSON_PROPERTY_SORT = "sort";
  private List<CriteriaSortInner> sort = new ArrayList<>();

  public static final String JSON_PROPERTY_POST_FILTER = "post-filter";
  private List<CriteriaFilterInner> postFilter = new ArrayList<>();

  public static final String JSON_PROPERTY_ASSOCIATIONS = "associations";
  private Object associations;

  public static final String JSON_PROPERTY_AGGREGATIONS = "aggregations";
  private List<CriteriaAggregationsInner> aggregations = new ArrayList<>();

  public static final String JSON_PROPERTY_GROUPING = "grouping";
  private List<String> grouping = new ArrayList<>();

  public static final String JSON_PROPERTY_FIELDS = "fields";
  private List<String> fields = new ArrayList<>();

  /**
   * Whether the total for the total number of hits should be determined for the search query. none &#x3D; disabled total count, exact &#x3D; calculate exact total amount (slow), next-pages &#x3D; calculate only for next page (fast)
   */
  public enum TotalCountModeEnum {
    NONE("none"),
    
    EXACT("exact"),
    
    NEXT_PAGES("next-pages");

    private String value;

    TotalCountModeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TotalCountModeEnum fromValue(String value) {
      for (TotalCountModeEnum b : TotalCountModeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TOTAL_COUNT_MODE = "total-count-mode";
  private TotalCountModeEnum totalCountMode = TotalCountModeEnum.NONE;

  public static final String JSON_PROPERTY_ORDER = "order";
  private String order;

  public static final String JSON_PROPERTY_P = "p";
  private Integer p = 1;

  public static final String JSON_PROPERTY_MANUFACTURER = "manufacturer";
  private String manufacturer;

  public static final String JSON_PROPERTY_MIN_PRICE = "min-price";
  private Integer minPrice = 0;

  public static final String JSON_PROPERTY_MAX_PRICE = "max-price";
  private Integer maxPrice = 0;

  public static final String JSON_PROPERTY_RATING = "rating";
  private Integer rating;

  public static final String JSON_PROPERTY_SHIPPING_FREE = "shipping-free";
  private Boolean shippingFree = false;

  public static final String JSON_PROPERTY_PROPERTIES = "properties";
  private String properties;

  public static final String JSON_PROPERTY_MANUFACTURER_FILTER = "manufacturer-filter";
  private Boolean manufacturerFilter = true;

  public static final String JSON_PROPERTY_PRICE_FILTER = "price-filter";
  private Boolean priceFilter = true;

  public static final String JSON_PROPERTY_RATING_FILTER = "rating-filter";
  private Boolean ratingFilter = true;

  public static final String JSON_PROPERTY_SHIPPING_FREE_FILTER = "shipping-free-filter";
  private Boolean shippingFreeFilter = true;

  public static final String JSON_PROPERTY_PROPERTY_FILTER = "property-filter";
  private Boolean propertyFilter = true;

  public static final String JSON_PROPERTY_PROPERTY_WHITELIST = "property-whitelist";
  private String propertyWhitelist;

  public static final String JSON_PROPERTY_REDUCE_AGGREGATIONS = "reduce-aggregations";
  private JsonNullable<String> reduceAggregations = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_SLOTS = "slots";
  private String slots;

  public ReadCmsRequest() {
  }

  public ReadCmsRequest page(Integer page) {
    
    this.page = page;
    return this;
  }

   /**
   * Search result page
   * @return page
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPage() {
    return page;
  }


  @JsonProperty(JSON_PROPERTY_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPage(Integer page) {
    this.page = page;
  }


  public ReadCmsRequest limit(Integer limit) {
    
    this.limit = limit;
    return this;
  }

   /**
   * Number of items per result page. If not set, the limit will be set according to the default products per page, defined in the system settings.
   * minimum: 0
   * @return limit
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LIMIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getLimit() {
    return limit;
  }


  @JsonProperty(JSON_PROPERTY_LIMIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLimit(Integer limit) {
    this.limit = limit;
  }


  public ReadCmsRequest filter(List<CriteriaFilterInner> filter) {
    
    this.filter = filter;
    return this;
  }

  public ReadCmsRequest addFilterItem(CriteriaFilterInner filterItem) {
    if (this.filter == null) {
      this.filter = new ArrayList<>();
    }
    this.filter.add(filterItem);
    return this;
  }

   /**
   * List of filters to restrict the search result. For more information, see [Search Queries &gt; Filter](https://shopware.stoplight.io/docs/store-api/docs/concepts/search-queries.md#filter)
   * @return filter
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FILTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<CriteriaFilterInner> getFilter() {
    return filter;
  }


  @JsonProperty(JSON_PROPERTY_FILTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFilter(List<CriteriaFilterInner> filter) {
    this.filter = filter;
  }


  public ReadCmsRequest sort(List<CriteriaSortInner> sort) {
    
    this.sort = sort;
    return this;
  }

  public ReadCmsRequest addSortItem(CriteriaSortInner sortItem) {
    if (this.sort == null) {
      this.sort = new ArrayList<>();
    }
    this.sort.add(sortItem);
    return this;
  }

   /**
   * Sorting in the search result.
   * @return sort
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<CriteriaSortInner> getSort() {
    return sort;
  }


  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSort(List<CriteriaSortInner> sort) {
    this.sort = sort;
  }


  public ReadCmsRequest postFilter(List<CriteriaFilterInner> postFilter) {
    
    this.postFilter = postFilter;
    return this;
  }

  public ReadCmsRequest addPostFilterItem(CriteriaFilterInner postFilterItem) {
    if (this.postFilter == null) {
      this.postFilter = new ArrayList<>();
    }
    this.postFilter.add(postFilterItem);
    return this;
  }

   /**
   * Filters that applied without affecting aggregations. For more information, see [Search Queries &gt; Post Filter](https://shopware.stoplight.io/docs/store-api/docs/concepts/search-queries.md#post-filter)
   * @return postFilter
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_POST_FILTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<CriteriaFilterInner> getPostFilter() {
    return postFilter;
  }


  @JsonProperty(JSON_PROPERTY_POST_FILTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPostFilter(List<CriteriaFilterInner> postFilter) {
    this.postFilter = postFilter;
  }


  public ReadCmsRequest associations(Object associations) {
    
    this.associations = associations;
    return this;
  }

   /**
   * Used to fetch associations which are not fetched by default.
   * @return associations
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ASSOCIATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getAssociations() {
    return associations;
  }


  @JsonProperty(JSON_PROPERTY_ASSOCIATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAssociations(Object associations) {
    this.associations = associations;
  }


  public ReadCmsRequest aggregations(List<CriteriaAggregationsInner> aggregations) {
    
    this.aggregations = aggregations;
    return this;
  }

  public ReadCmsRequest addAggregationsItem(CriteriaAggregationsInner aggregationsItem) {
    if (this.aggregations == null) {
      this.aggregations = new ArrayList<>();
    }
    this.aggregations.add(aggregationsItem);
    return this;
  }

   /**
   * Used to perform aggregations on the search result. For more information, see [Search Queries &gt; Aggregations](https://shopware.stoplight.io/docs/store-api/docs/concepts/search-queries.md#aggregations)
   * @return aggregations
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_AGGREGATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<CriteriaAggregationsInner> getAggregations() {
    return aggregations;
  }


  @JsonProperty(JSON_PROPERTY_AGGREGATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAggregations(List<CriteriaAggregationsInner> aggregations) {
    this.aggregations = aggregations;
  }


  public ReadCmsRequest grouping(List<String> grouping) {
    
    this.grouping = grouping;
    return this;
  }

  public ReadCmsRequest addGroupingItem(String groupingItem) {
    if (this.grouping == null) {
      this.grouping = new ArrayList<>();
    }
    this.grouping.add(groupingItem);
    return this;
  }

   /**
   * Perform groupings over certain fields
   * @return grouping
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_GROUPING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getGrouping() {
    return grouping;
  }


  @JsonProperty(JSON_PROPERTY_GROUPING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGrouping(List<String> grouping) {
    this.grouping = grouping;
  }


  public ReadCmsRequest fields(List<String> fields) {
    
    this.fields = fields;
    return this;
  }

  public ReadCmsRequest addFieldsItem(String fieldsItem) {
    if (this.fields == null) {
      this.fields = new ArrayList<>();
    }
    this.fields.add(fieldsItem);
    return this;
  }

   /**
   * Fields which should be returned in the search result.
   * @return fields
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getFields() {
    return fields;
  }


  @JsonProperty(JSON_PROPERTY_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFields(List<String> fields) {
    this.fields = fields;
  }


  public ReadCmsRequest totalCountMode(TotalCountModeEnum totalCountMode) {
    
    this.totalCountMode = totalCountMode;
    return this;
  }

   /**
   * Whether the total for the total number of hits should be determined for the search query. none &#x3D; disabled total count, exact &#x3D; calculate exact total amount (slow), next-pages &#x3D; calculate only for next page (fast)
   * @return totalCountMode
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TOTAL_COUNT_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TotalCountModeEnum getTotalCountMode() {
    return totalCountMode;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_COUNT_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalCountMode(TotalCountModeEnum totalCountMode) {
    this.totalCountMode = totalCountMode;
  }


  public ReadCmsRequest order(String order) {
    
    this.order = order;
    return this;
  }

   /**
   * Specifies the sorting of the products by &#x60;availableSortings&#x60;. If not set, the default sorting will be set according to the shop settings. The available sorting options are sent within the response under the &#x60;availableSortings&#x60; key. In order to sort by a field, consider using the &#x60;sort&#x60; parameter from the listing criteria. Do not use both parameters together, as it might lead to unexpected results.
   * @return order
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ORDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOrder() {
    return order;
  }


  @JsonProperty(JSON_PROPERTY_ORDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOrder(String order) {
    this.order = order;
  }


  public ReadCmsRequest p(Integer p) {
    
    this.p = p;
    return this;
  }

   /**
   * Search result page
   * @return p
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_P)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getP() {
    return p;
  }


  @JsonProperty(JSON_PROPERTY_P)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setP(Integer p) {
    this.p = p;
  }


  public ReadCmsRequest manufacturer(String manufacturer) {
    
    this.manufacturer = manufacturer;
    return this;
  }

   /**
   * Filter by manufacturers. List of manufacturer identifiers separated by a &#x60;|&#x60;.
   * @return manufacturer
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MANUFACTURER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getManufacturer() {
    return manufacturer;
  }


  @JsonProperty(JSON_PROPERTY_MANUFACTURER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setManufacturer(String manufacturer) {
    this.manufacturer = manufacturer;
  }


  public ReadCmsRequest minPrice(Integer minPrice) {
    
    this.minPrice = minPrice;
    return this;
  }

   /**
   * Filters by a minimum product price. Has to be lower than the &#x60;max-price&#x60; filter.
   * minimum: 0
   * @return minPrice
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MIN_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMinPrice() {
    return minPrice;
  }


  @JsonProperty(JSON_PROPERTY_MIN_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinPrice(Integer minPrice) {
    this.minPrice = minPrice;
  }


  public ReadCmsRequest maxPrice(Integer maxPrice) {
    
    this.maxPrice = maxPrice;
    return this;
  }

   /**
   * Filters by a maximum product price. Has to be higher than the &#x60;min-price&#x60; filter.
   * minimum: 0
   * @return maxPrice
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MAX_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMaxPrice() {
    return maxPrice;
  }


  @JsonProperty(JSON_PROPERTY_MAX_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxPrice(Integer maxPrice) {
    this.maxPrice = maxPrice;
  }


  public ReadCmsRequest rating(Integer rating) {
    
    this.rating = rating;
    return this;
  }

   /**
   * Filter products with a minimum average rating.
   * @return rating
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getRating() {
    return rating;
  }


  @JsonProperty(JSON_PROPERTY_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRating(Integer rating) {
    this.rating = rating;
  }


  public ReadCmsRequest shippingFree(Boolean shippingFree) {
    
    this.shippingFree = shippingFree;
    return this;
  }

   /**
   * Filters products that are marked as shipping-free.
   * @return shippingFree
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SHIPPING_FREE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShippingFree() {
    return shippingFree;
  }


  @JsonProperty(JSON_PROPERTY_SHIPPING_FREE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShippingFree(Boolean shippingFree) {
    this.shippingFree = shippingFree;
  }


  public ReadCmsRequest properties(String properties) {
    
    this.properties = properties;
    return this;
  }

   /**
   * Filters products by their properties. List of property identifiers separated by a &#x60;|&#x60;.
   * @return properties
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROPERTIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProperties() {
    return properties;
  }


  @JsonProperty(JSON_PROPERTY_PROPERTIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProperties(String properties) {
    this.properties = properties;
  }


  public ReadCmsRequest manufacturerFilter(Boolean manufacturerFilter) {
    
    this.manufacturerFilter = manufacturerFilter;
    return this;
  }

   /**
   * Enables/disabled filtering by manufacturer. If set to false, the &#x60;manufacturer&#x60; filter will be ignored. Also the &#x60;aggregations[manufacturer]&#x60; key will be removed from the response.
   * @return manufacturerFilter
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MANUFACTURER_FILTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getManufacturerFilter() {
    return manufacturerFilter;
  }


  @JsonProperty(JSON_PROPERTY_MANUFACTURER_FILTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setManufacturerFilter(Boolean manufacturerFilter) {
    this.manufacturerFilter = manufacturerFilter;
  }


  public ReadCmsRequest priceFilter(Boolean priceFilter) {
    
    this.priceFilter = priceFilter;
    return this;
  }

   /**
   * Enables/disabled filtering by price. If set to false, the &#x60;min-price&#x60; and &#x60;max-price&#x60; filter will be ignored. Also the &#x60;aggregations[price]&#x60; key will be removed from the response.
   * @return priceFilter
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PRICE_FILTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getPriceFilter() {
    return priceFilter;
  }


  @JsonProperty(JSON_PROPERTY_PRICE_FILTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPriceFilter(Boolean priceFilter) {
    this.priceFilter = priceFilter;
  }


  public ReadCmsRequest ratingFilter(Boolean ratingFilter) {
    
    this.ratingFilter = ratingFilter;
    return this;
  }

   /**
   * Enables/disabled filtering by rating. If set to false, the &#x60;rating&#x60; filter will be ignored. Also the &#x60;aggregations[rating]&#x60; key will be removed from the response.
   * @return ratingFilter
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_RATING_FILTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getRatingFilter() {
    return ratingFilter;
  }


  @JsonProperty(JSON_PROPERTY_RATING_FILTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRatingFilter(Boolean ratingFilter) {
    this.ratingFilter = ratingFilter;
  }


  public ReadCmsRequest shippingFreeFilter(Boolean shippingFreeFilter) {
    
    this.shippingFreeFilter = shippingFreeFilter;
    return this;
  }

   /**
   * Enables/disabled filtering by shipping-free products. If set to false, the &#x60;shipping-free&#x60; filter will be ignored. Also the &#x60;aggregations[shipping-free]&#x60; key will be removed from the response.
   * @return shippingFreeFilter
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SHIPPING_FREE_FILTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShippingFreeFilter() {
    return shippingFreeFilter;
  }


  @JsonProperty(JSON_PROPERTY_SHIPPING_FREE_FILTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShippingFreeFilter(Boolean shippingFreeFilter) {
    this.shippingFreeFilter = shippingFreeFilter;
  }


  public ReadCmsRequest propertyFilter(Boolean propertyFilter) {
    
    this.propertyFilter = propertyFilter;
    return this;
  }

   /**
   * Enables/disabled filtering by properties products. If set to false, the &#x60;properties&#x60; filter will be ignored. Also the &#x60;aggregations[properties]&#x60; key will be removed from the response.
   * @return propertyFilter
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROPERTY_FILTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getPropertyFilter() {
    return propertyFilter;
  }


  @JsonProperty(JSON_PROPERTY_PROPERTY_FILTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPropertyFilter(Boolean propertyFilter) {
    this.propertyFilter = propertyFilter;
  }


  public ReadCmsRequest propertyWhitelist(String propertyWhitelist) {
    
    this.propertyWhitelist = propertyWhitelist;
    return this;
  }

   /**
   * A whitelist of property identifiers which can be used for filtering. List of property identifiers separated by a &#x60;|&#x60;. The &#x60;property-filter&#x60; must be &#x60;true&#x60;, otherwise the whitelist has no effect.
   * @return propertyWhitelist
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROPERTY_WHITELIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPropertyWhitelist() {
    return propertyWhitelist;
  }


  @JsonProperty(JSON_PROPERTY_PROPERTY_WHITELIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPropertyWhitelist(String propertyWhitelist) {
    this.propertyWhitelist = propertyWhitelist;
  }


  public ReadCmsRequest reduceAggregations(String reduceAggregations) {
    this.reduceAggregations = JsonNullable.<String>of(reduceAggregations);
    
    return this;
  }

   /**
   * By sending the parameter &#x60;reduce-aggregations&#x60; , the post-filters that were applied by the customer, are also applied to the aggregations. This has the consequence that only values are returned in the aggregations that would lead to further filter results. This parameter is a flag, the value has no effect.
   * @return reduceAggregations
  **/
  @jakarta.annotation.Nullable
  @JsonIgnore

  public String getReduceAggregations() {
        return reduceAggregations.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_REDUCE_AGGREGATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getReduceAggregations_JsonNullable() {
    return reduceAggregations;
  }
  
  @JsonProperty(JSON_PROPERTY_REDUCE_AGGREGATIONS)
  public void setReduceAggregations_JsonNullable(JsonNullable<String> reduceAggregations) {
    this.reduceAggregations = reduceAggregations;
  }

  public void setReduceAggregations(String reduceAggregations) {
    this.reduceAggregations = JsonNullable.<String>of(reduceAggregations);
  }


  public ReadCmsRequest slots(String slots) {
    
    this.slots = slots;
    return this;
  }

   /**
   * Resolves only the given slot identifiers. The identifiers have to be seperated by a &#x60;|&#x60; character.
   * @return slots
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SLOTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSlots() {
    return slots;
  }


  @JsonProperty(JSON_PROPERTY_SLOTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSlots(String slots) {
    this.slots = slots;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ReadCmsRequest readCmsRequest = (ReadCmsRequest) o;
    return Objects.equals(this.page, readCmsRequest.page) &&
        Objects.equals(this.limit, readCmsRequest.limit) &&
        Objects.equals(this.filter, readCmsRequest.filter) &&
        Objects.equals(this.sort, readCmsRequest.sort) &&
        Objects.equals(this.postFilter, readCmsRequest.postFilter) &&
        Objects.equals(this.associations, readCmsRequest.associations) &&
        Objects.equals(this.aggregations, readCmsRequest.aggregations) &&
        Objects.equals(this.grouping, readCmsRequest.grouping) &&
        Objects.equals(this.fields, readCmsRequest.fields) &&
        Objects.equals(this.totalCountMode, readCmsRequest.totalCountMode) &&
        Objects.equals(this.order, readCmsRequest.order) &&
        Objects.equals(this.p, readCmsRequest.p) &&
        Objects.equals(this.manufacturer, readCmsRequest.manufacturer) &&
        Objects.equals(this.minPrice, readCmsRequest.minPrice) &&
        Objects.equals(this.maxPrice, readCmsRequest.maxPrice) &&
        Objects.equals(this.rating, readCmsRequest.rating) &&
        Objects.equals(this.shippingFree, readCmsRequest.shippingFree) &&
        Objects.equals(this.properties, readCmsRequest.properties) &&
        Objects.equals(this.manufacturerFilter, readCmsRequest.manufacturerFilter) &&
        Objects.equals(this.priceFilter, readCmsRequest.priceFilter) &&
        Objects.equals(this.ratingFilter, readCmsRequest.ratingFilter) &&
        Objects.equals(this.shippingFreeFilter, readCmsRequest.shippingFreeFilter) &&
        Objects.equals(this.propertyFilter, readCmsRequest.propertyFilter) &&
        Objects.equals(this.propertyWhitelist, readCmsRequest.propertyWhitelist) &&
        equalsNullable(this.reduceAggregations, readCmsRequest.reduceAggregations) &&
        Objects.equals(this.slots, readCmsRequest.slots);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(page, limit, filter, sort, postFilter, associations, aggregations, grouping, fields, totalCountMode, order, p, manufacturer, minPrice, maxPrice, rating, shippingFree, properties, manufacturerFilter, priceFilter, ratingFilter, shippingFreeFilter, propertyFilter, propertyWhitelist, hashCodeNullable(reduceAggregations), slots);
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ReadCmsRequest {\n");
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("    limit: ").append(toIndentedString(limit)).append("\n");
    sb.append("    filter: ").append(toIndentedString(filter)).append("\n");
    sb.append("    sort: ").append(toIndentedString(sort)).append("\n");
    sb.append("    postFilter: ").append(toIndentedString(postFilter)).append("\n");
    sb.append("    associations: ").append(toIndentedString(associations)).append("\n");
    sb.append("    aggregations: ").append(toIndentedString(aggregations)).append("\n");
    sb.append("    grouping: ").append(toIndentedString(grouping)).append("\n");
    sb.append("    fields: ").append(toIndentedString(fields)).append("\n");
    sb.append("    totalCountMode: ").append(toIndentedString(totalCountMode)).append("\n");
    sb.append("    order: ").append(toIndentedString(order)).append("\n");
    sb.append("    p: ").append(toIndentedString(p)).append("\n");
    sb.append("    manufacturer: ").append(toIndentedString(manufacturer)).append("\n");
    sb.append("    minPrice: ").append(toIndentedString(minPrice)).append("\n");
    sb.append("    maxPrice: ").append(toIndentedString(maxPrice)).append("\n");
    sb.append("    rating: ").append(toIndentedString(rating)).append("\n");
    sb.append("    shippingFree: ").append(toIndentedString(shippingFree)).append("\n");
    sb.append("    properties: ").append(toIndentedString(properties)).append("\n");
    sb.append("    manufacturerFilter: ").append(toIndentedString(manufacturerFilter)).append("\n");
    sb.append("    priceFilter: ").append(toIndentedString(priceFilter)).append("\n");
    sb.append("    ratingFilter: ").append(toIndentedString(ratingFilter)).append("\n");
    sb.append("    shippingFreeFilter: ").append(toIndentedString(shippingFreeFilter)).append("\n");
    sb.append("    propertyFilter: ").append(toIndentedString(propertyFilter)).append("\n");
    sb.append("    propertyWhitelist: ").append(toIndentedString(propertyWhitelist)).append("\n");
    sb.append("    reduceAggregations: ").append(toIndentedString(reduceAggregations)).append("\n");
    sb.append("    slots: ").append(toIndentedString(slots)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

