/*
 * Shopware Store API
 * This endpoint reference contains an overview of all endpoints comprising the Shopware Store API
 *
 * The version of the OpenAPI document: 6.5.7.3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package de.codebarista.shopware.model.core;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * ReadOrderRequest
 */
@JsonPropertyOrder({
  ReadOrderRequest.JSON_PROPERTY_PAGE,
  ReadOrderRequest.JSON_PROPERTY_LIMIT,
  ReadOrderRequest.JSON_PROPERTY_FILTER,
  ReadOrderRequest.JSON_PROPERTY_SORT,
  ReadOrderRequest.JSON_PROPERTY_POST_FILTER,
  ReadOrderRequest.JSON_PROPERTY_ASSOCIATIONS,
  ReadOrderRequest.JSON_PROPERTY_AGGREGATIONS,
  ReadOrderRequest.JSON_PROPERTY_GROUPING,
  ReadOrderRequest.JSON_PROPERTY_FIELDS,
  ReadOrderRequest.JSON_PROPERTY_TOTAL_COUNT_MODE,
  ReadOrderRequest.JSON_PROPERTY_CHECK_PROMOTION
})
@JsonTypeName("readOrder_request")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-10T11:26:02.541008353+02:00[Europe/Berlin]", comments = "Generator version: 7.5.0")
public class ReadOrderRequest {
  public static final String JSON_PROPERTY_PAGE = "page";
  private Integer page;

  public static final String JSON_PROPERTY_LIMIT = "limit";
  private Integer limit;

  public static final String JSON_PROPERTY_FILTER = "filter";
  private List<CriteriaFilterInner> filter = new ArrayList<>();

  public static final String JSON_PROPERTY_SORT = "sort";
  private List<CriteriaSortInner> sort = new ArrayList<>();

  public static final String JSON_PROPERTY_POST_FILTER = "post-filter";
  private List<CriteriaFilterInner> postFilter = new ArrayList<>();

  public static final String JSON_PROPERTY_ASSOCIATIONS = "associations";
  private Object associations;

  public static final String JSON_PROPERTY_AGGREGATIONS = "aggregations";
  private List<CriteriaAggregationsInner> aggregations = new ArrayList<>();

  public static final String JSON_PROPERTY_GROUPING = "grouping";
  private List<String> grouping = new ArrayList<>();

  public static final String JSON_PROPERTY_FIELDS = "fields";
  private List<String> fields = new ArrayList<>();

  /**
   * Whether the total for the total number of hits should be determined for the search query. none &#x3D; disabled total count, exact &#x3D; calculate exact total amount (slow), next-pages &#x3D; calculate only for next page (fast)
   */
  public enum TotalCountModeEnum {
    NONE("none"),
    
    EXACT("exact"),
    
    NEXT_PAGES("next-pages");

    private String value;

    TotalCountModeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TotalCountModeEnum fromValue(String value) {
      for (TotalCountModeEnum b : TotalCountModeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TOTAL_COUNT_MODE = "total-count-mode";
  private TotalCountModeEnum totalCountMode = TotalCountModeEnum.NONE;

  public static final String JSON_PROPERTY_CHECK_PROMOTION = "checkPromotion";
  private Boolean checkPromotion;

  public ReadOrderRequest() {
  }

  public ReadOrderRequest page(Integer page) {
    
    this.page = page;
    return this;
  }

   /**
   * Search result page
   * @return page
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPage() {
    return page;
  }


  @JsonProperty(JSON_PROPERTY_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPage(Integer page) {
    this.page = page;
  }


  public ReadOrderRequest limit(Integer limit) {
    
    this.limit = limit;
    return this;
  }

   /**
   * Number of items per result page
   * @return limit
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LIMIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getLimit() {
    return limit;
  }


  @JsonProperty(JSON_PROPERTY_LIMIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLimit(Integer limit) {
    this.limit = limit;
  }


  public ReadOrderRequest filter(List<CriteriaFilterInner> filter) {
    
    this.filter = filter;
    return this;
  }

  public ReadOrderRequest addFilterItem(CriteriaFilterInner filterItem) {
    if (this.filter == null) {
      this.filter = new ArrayList<>();
    }
    this.filter.add(filterItem);
    return this;
  }

   /**
   * List of filters to restrict the search result. For more information, see [Search Queries &gt; Filter](https://shopware.stoplight.io/docs/store-api/docs/concepts/search-queries.md#filter)
   * @return filter
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FILTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<CriteriaFilterInner> getFilter() {
    return filter;
  }


  @JsonProperty(JSON_PROPERTY_FILTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFilter(List<CriteriaFilterInner> filter) {
    this.filter = filter;
  }


  public ReadOrderRequest sort(List<CriteriaSortInner> sort) {
    
    this.sort = sort;
    return this;
  }

  public ReadOrderRequest addSortItem(CriteriaSortInner sortItem) {
    if (this.sort == null) {
      this.sort = new ArrayList<>();
    }
    this.sort.add(sortItem);
    return this;
  }

   /**
   * Sorting in the search result.
   * @return sort
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<CriteriaSortInner> getSort() {
    return sort;
  }


  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSort(List<CriteriaSortInner> sort) {
    this.sort = sort;
  }


  public ReadOrderRequest postFilter(List<CriteriaFilterInner> postFilter) {
    
    this.postFilter = postFilter;
    return this;
  }

  public ReadOrderRequest addPostFilterItem(CriteriaFilterInner postFilterItem) {
    if (this.postFilter == null) {
      this.postFilter = new ArrayList<>();
    }
    this.postFilter.add(postFilterItem);
    return this;
  }

   /**
   * Filters that applied without affecting aggregations. For more information, see [Search Queries &gt; Post Filter](https://shopware.stoplight.io/docs/store-api/docs/concepts/search-queries.md#post-filter)
   * @return postFilter
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_POST_FILTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<CriteriaFilterInner> getPostFilter() {
    return postFilter;
  }


  @JsonProperty(JSON_PROPERTY_POST_FILTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPostFilter(List<CriteriaFilterInner> postFilter) {
    this.postFilter = postFilter;
  }


  public ReadOrderRequest associations(Object associations) {
    
    this.associations = associations;
    return this;
  }

   /**
   * Used to fetch associations which are not fetched by default.
   * @return associations
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ASSOCIATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getAssociations() {
    return associations;
  }


  @JsonProperty(JSON_PROPERTY_ASSOCIATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAssociations(Object associations) {
    this.associations = associations;
  }


  public ReadOrderRequest aggregations(List<CriteriaAggregationsInner> aggregations) {
    
    this.aggregations = aggregations;
    return this;
  }

  public ReadOrderRequest addAggregationsItem(CriteriaAggregationsInner aggregationsItem) {
    if (this.aggregations == null) {
      this.aggregations = new ArrayList<>();
    }
    this.aggregations.add(aggregationsItem);
    return this;
  }

   /**
   * Used to perform aggregations on the search result. For more information, see [Search Queries &gt; Aggregations](https://shopware.stoplight.io/docs/store-api/docs/concepts/search-queries.md#aggregations)
   * @return aggregations
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_AGGREGATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<CriteriaAggregationsInner> getAggregations() {
    return aggregations;
  }


  @JsonProperty(JSON_PROPERTY_AGGREGATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAggregations(List<CriteriaAggregationsInner> aggregations) {
    this.aggregations = aggregations;
  }


  public ReadOrderRequest grouping(List<String> grouping) {
    
    this.grouping = grouping;
    return this;
  }

  public ReadOrderRequest addGroupingItem(String groupingItem) {
    if (this.grouping == null) {
      this.grouping = new ArrayList<>();
    }
    this.grouping.add(groupingItem);
    return this;
  }

   /**
   * Perform groupings over certain fields
   * @return grouping
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_GROUPING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getGrouping() {
    return grouping;
  }


  @JsonProperty(JSON_PROPERTY_GROUPING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGrouping(List<String> grouping) {
    this.grouping = grouping;
  }


  public ReadOrderRequest fields(List<String> fields) {
    
    this.fields = fields;
    return this;
  }

  public ReadOrderRequest addFieldsItem(String fieldsItem) {
    if (this.fields == null) {
      this.fields = new ArrayList<>();
    }
    this.fields.add(fieldsItem);
    return this;
  }

   /**
   * Fields which should be returned in the search result.
   * @return fields
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getFields() {
    return fields;
  }


  @JsonProperty(JSON_PROPERTY_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFields(List<String> fields) {
    this.fields = fields;
  }


  public ReadOrderRequest totalCountMode(TotalCountModeEnum totalCountMode) {
    
    this.totalCountMode = totalCountMode;
    return this;
  }

   /**
   * Whether the total for the total number of hits should be determined for the search query. none &#x3D; disabled total count, exact &#x3D; calculate exact total amount (slow), next-pages &#x3D; calculate only for next page (fast)
   * @return totalCountMode
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TOTAL_COUNT_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TotalCountModeEnum getTotalCountMode() {
    return totalCountMode;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_COUNT_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalCountMode(TotalCountModeEnum totalCountMode) {
    this.totalCountMode = totalCountMode;
  }


  public ReadOrderRequest checkPromotion(Boolean checkPromotion) {
    
    this.checkPromotion = checkPromotion;
    return this;
  }

   /**
   * Check if the payment method of the order is still changeable.
   * @return checkPromotion
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CHECK_PROMOTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCheckPromotion() {
    return checkPromotion;
  }


  @JsonProperty(JSON_PROPERTY_CHECK_PROMOTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCheckPromotion(Boolean checkPromotion) {
    this.checkPromotion = checkPromotion;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ReadOrderRequest readOrderRequest = (ReadOrderRequest) o;
    return Objects.equals(this.page, readOrderRequest.page) &&
        Objects.equals(this.limit, readOrderRequest.limit) &&
        Objects.equals(this.filter, readOrderRequest.filter) &&
        Objects.equals(this.sort, readOrderRequest.sort) &&
        Objects.equals(this.postFilter, readOrderRequest.postFilter) &&
        Objects.equals(this.associations, readOrderRequest.associations) &&
        Objects.equals(this.aggregations, readOrderRequest.aggregations) &&
        Objects.equals(this.grouping, readOrderRequest.grouping) &&
        Objects.equals(this.fields, readOrderRequest.fields) &&
        Objects.equals(this.totalCountMode, readOrderRequest.totalCountMode) &&
        Objects.equals(this.checkPromotion, readOrderRequest.checkPromotion);
  }

  @Override
  public int hashCode() {
    return Objects.hash(page, limit, filter, sort, postFilter, associations, aggregations, grouping, fields, totalCountMode, checkPromotion);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ReadOrderRequest {\n");
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("    limit: ").append(toIndentedString(limit)).append("\n");
    sb.append("    filter: ").append(toIndentedString(filter)).append("\n");
    sb.append("    sort: ").append(toIndentedString(sort)).append("\n");
    sb.append("    postFilter: ").append(toIndentedString(postFilter)).append("\n");
    sb.append("    associations: ").append(toIndentedString(associations)).append("\n");
    sb.append("    aggregations: ").append(toIndentedString(aggregations)).append("\n");
    sb.append("    grouping: ").append(toIndentedString(grouping)).append("\n");
    sb.append("    fields: ").append(toIndentedString(fields)).append("\n");
    sb.append("    totalCountMode: ").append(toIndentedString(totalCountMode)).append("\n");
    sb.append("    checkPromotion: ").append(toIndentedString(checkPromotion)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

