/*
 * Shopware Store API
 * This endpoint reference contains an overview of all endpoints comprising the Shopware Store API
 *
 * The version of the OpenAPI document: 6.5.7.3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package de.codebarista.shopware.model.core;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import org.openapitools.jackson.nullable.JsonNullable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

/**
 * ReadProductListingRequest
 */
@JsonPropertyOrder({
  ReadProductListingRequest.JSON_PROPERTY_PAGE,
  ReadProductListingRequest.JSON_PROPERTY_LIMIT,
  ReadProductListingRequest.JSON_PROPERTY_FILTER,
  ReadProductListingRequest.JSON_PROPERTY_SORT,
  ReadProductListingRequest.JSON_PROPERTY_POST_FILTER,
  ReadProductListingRequest.JSON_PROPERTY_ASSOCIATIONS,
  ReadProductListingRequest.JSON_PROPERTY_AGGREGATIONS,
  ReadProductListingRequest.JSON_PROPERTY_GROUPING,
  ReadProductListingRequest.JSON_PROPERTY_FIELDS,
  ReadProductListingRequest.JSON_PROPERTY_TOTAL_COUNT_MODE,
  ReadProductListingRequest.JSON_PROPERTY_ORDER,
  ReadProductListingRequest.JSON_PROPERTY_P,
  ReadProductListingRequest.JSON_PROPERTY_MANUFACTURER,
  ReadProductListingRequest.JSON_PROPERTY_MIN_PRICE,
  ReadProductListingRequest.JSON_PROPERTY_MAX_PRICE,
  ReadProductListingRequest.JSON_PROPERTY_RATING,
  ReadProductListingRequest.JSON_PROPERTY_SHIPPING_FREE,
  ReadProductListingRequest.JSON_PROPERTY_PROPERTIES,
  ReadProductListingRequest.JSON_PROPERTY_MANUFACTURER_FILTER,
  ReadProductListingRequest.JSON_PROPERTY_PRICE_FILTER,
  ReadProductListingRequest.JSON_PROPERTY_RATING_FILTER,
  ReadProductListingRequest.JSON_PROPERTY_SHIPPING_FREE_FILTER,
  ReadProductListingRequest.JSON_PROPERTY_PROPERTY_FILTER,
  ReadProductListingRequest.JSON_PROPERTY_PROPERTY_WHITELIST,
  ReadProductListingRequest.JSON_PROPERTY_REDUCE_AGGREGATIONS,
  ReadProductListingRequest.JSON_PROPERTY_NO_AGGREGATIONS,
  ReadProductListingRequest.JSON_PROPERTY_ONLY_AGGREGATIONS
})
@JsonTypeName("readProductListing_request")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-10T11:26:02.541008353+02:00[Europe/Berlin]", comments = "Generator version: 7.5.0")
public class ReadProductListingRequest {
  public static final String JSON_PROPERTY_PAGE = "page";
  private Integer page;

  public static final String JSON_PROPERTY_LIMIT = "limit";
  private Integer limit;

  public static final String JSON_PROPERTY_FILTER = "filter";
  private List<CriteriaFilterInner> filter = new ArrayList<>();

  public static final String JSON_PROPERTY_SORT = "sort";
  private List<CriteriaSortInner> sort = new ArrayList<>();

  public static final String JSON_PROPERTY_POST_FILTER = "post-filter";
  private List<CriteriaFilterInner> postFilter = new ArrayList<>();

  public static final String JSON_PROPERTY_ASSOCIATIONS = "associations";
  private Object associations;

  public static final String JSON_PROPERTY_AGGREGATIONS = "aggregations";
  private List<CriteriaAggregationsInner> aggregations = new ArrayList<>();

  public static final String JSON_PROPERTY_GROUPING = "grouping";
  private List<String> grouping = new ArrayList<>();

  public static final String JSON_PROPERTY_FIELDS = "fields";
  private List<String> fields = new ArrayList<>();

  /**
   * Whether the total for the total number of hits should be determined for the search query. none &#x3D; disabled total count, exact &#x3D; calculate exact total amount (slow), next-pages &#x3D; calculate only for next page (fast)
   */
  public enum TotalCountModeEnum {
    NONE("none"),
    
    EXACT("exact"),
    
    NEXT_PAGES("next-pages");

    private String value;

    TotalCountModeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TotalCountModeEnum fromValue(String value) {
      for (TotalCountModeEnum b : TotalCountModeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TOTAL_COUNT_MODE = "total-count-mode";
  private TotalCountModeEnum totalCountMode = TotalCountModeEnum.NONE;

  public static final String JSON_PROPERTY_ORDER = "order";
  private String order;

  public static final String JSON_PROPERTY_P = "p";
  private Integer p = 1;

  public static final String JSON_PROPERTY_MANUFACTURER = "manufacturer";
  private String manufacturer;

  public static final String JSON_PROPERTY_MIN_PRICE = "min-price";
  private Integer minPrice = 0;

  public static final String JSON_PROPERTY_MAX_PRICE = "max-price";
  private Integer maxPrice = 0;

  public static final String JSON_PROPERTY_RATING = "rating";
  private Integer rating;

  public static final String JSON_PROPERTY_SHIPPING_FREE = "shipping-free";
  private Boolean shippingFree = false;

  public static final String JSON_PROPERTY_PROPERTIES = "properties";
  private String properties;

  public static final String JSON_PROPERTY_MANUFACTURER_FILTER = "manufacturer-filter";
  private Boolean manufacturerFilter = true;

  public static final String JSON_PROPERTY_PRICE_FILTER = "price-filter";
  private Boolean priceFilter = true;

  public static final String JSON_PROPERTY_RATING_FILTER = "rating-filter";
  private Boolean ratingFilter = true;

  public static final String JSON_PROPERTY_SHIPPING_FREE_FILTER = "shipping-free-filter";
  private Boolean shippingFreeFilter = true;

  public static final String JSON_PROPERTY_PROPERTY_FILTER = "property-filter";
  private Boolean propertyFilter = true;

  public static final String JSON_PROPERTY_PROPERTY_WHITELIST = "property-whitelist";
  private String propertyWhitelist;

  public static final String JSON_PROPERTY_REDUCE_AGGREGATIONS = "reduce-aggregations";
  private JsonNullable<String> reduceAggregations = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_NO_AGGREGATIONS = "no-aggregations";
  private JsonNullable<String> noAggregations = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ONLY_AGGREGATIONS = "only-aggregations";
  private JsonNullable<String> onlyAggregations = JsonNullable.<String>undefined();

  public ReadProductListingRequest() {
  }

  public ReadProductListingRequest page(Integer page) {
    
    this.page = page;
    return this;
  }

   /**
   * Search result page
   * @return page
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPage() {
    return page;
  }


  @JsonProperty(JSON_PROPERTY_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPage(Integer page) {
    this.page = page;
  }


  public ReadProductListingRequest limit(Integer limit) {
    
    this.limit = limit;
    return this;
  }

   /**
   * Number of items per result page. If not set, the limit will be set according to the default products per page, defined in the system settings.
   * minimum: 0
   * @return limit
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LIMIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getLimit() {
    return limit;
  }


  @JsonProperty(JSON_PROPERTY_LIMIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLimit(Integer limit) {
    this.limit = limit;
  }


  public ReadProductListingRequest filter(List<CriteriaFilterInner> filter) {
    
    this.filter = filter;
    return this;
  }

  public ReadProductListingRequest addFilterItem(CriteriaFilterInner filterItem) {
    if (this.filter == null) {
      this.filter = new ArrayList<>();
    }
    this.filter.add(filterItem);
    return this;
  }

   /**
   * List of filters to restrict the search result. For more information, see [Search Queries &gt; Filter](https://shopware.stoplight.io/docs/store-api/docs/concepts/search-queries.md#filter)
   * @return filter
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FILTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<CriteriaFilterInner> getFilter() {
    return filter;
  }


  @JsonProperty(JSON_PROPERTY_FILTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFilter(List<CriteriaFilterInner> filter) {
    this.filter = filter;
  }


  public ReadProductListingRequest sort(List<CriteriaSortInner> sort) {
    
    this.sort = sort;
    return this;
  }

  public ReadProductListingRequest addSortItem(CriteriaSortInner sortItem) {
    if (this.sort == null) {
      this.sort = new ArrayList<>();
    }
    this.sort.add(sortItem);
    return this;
  }

   /**
   * Sorting in the search result.
   * @return sort
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<CriteriaSortInner> getSort() {
    return sort;
  }


  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSort(List<CriteriaSortInner> sort) {
    this.sort = sort;
  }


  public ReadProductListingRequest postFilter(List<CriteriaFilterInner> postFilter) {
    
    this.postFilter = postFilter;
    return this;
  }

  public ReadProductListingRequest addPostFilterItem(CriteriaFilterInner postFilterItem) {
    if (this.postFilter == null) {
      this.postFilter = new ArrayList<>();
    }
    this.postFilter.add(postFilterItem);
    return this;
  }

   /**
   * Filters that applied without affecting aggregations. For more information, see [Search Queries &gt; Post Filter](https://shopware.stoplight.io/docs/store-api/docs/concepts/search-queries.md#post-filter)
   * @return postFilter
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_POST_FILTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<CriteriaFilterInner> getPostFilter() {
    return postFilter;
  }


  @JsonProperty(JSON_PROPERTY_POST_FILTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPostFilter(List<CriteriaFilterInner> postFilter) {
    this.postFilter = postFilter;
  }


  public ReadProductListingRequest associations(Object associations) {
    
    this.associations = associations;
    return this;
  }

   /**
   * Used to fetch associations which are not fetched by default.
   * @return associations
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ASSOCIATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getAssociations() {
    return associations;
  }


  @JsonProperty(JSON_PROPERTY_ASSOCIATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAssociations(Object associations) {
    this.associations = associations;
  }


  public ReadProductListingRequest aggregations(List<CriteriaAggregationsInner> aggregations) {
    
    this.aggregations = aggregations;
    return this;
  }

  public ReadProductListingRequest addAggregationsItem(CriteriaAggregationsInner aggregationsItem) {
    if (this.aggregations == null) {
      this.aggregations = new ArrayList<>();
    }
    this.aggregations.add(aggregationsItem);
    return this;
  }

   /**
   * Used to perform aggregations on the search result. For more information, see [Search Queries &gt; Aggregations](https://shopware.stoplight.io/docs/store-api/docs/concepts/search-queries.md#aggregations)
   * @return aggregations
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_AGGREGATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<CriteriaAggregationsInner> getAggregations() {
    return aggregations;
  }


  @JsonProperty(JSON_PROPERTY_AGGREGATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAggregations(List<CriteriaAggregationsInner> aggregations) {
    this.aggregations = aggregations;
  }


  public ReadProductListingRequest grouping(List<String> grouping) {
    
    this.grouping = grouping;
    return this;
  }

  public ReadProductListingRequest addGroupingItem(String groupingItem) {
    if (this.grouping == null) {
      this.grouping = new ArrayList<>();
    }
    this.grouping.add(groupingItem);
    return this;
  }

   /**
   * Perform groupings over certain fields
   * @return grouping
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_GROUPING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getGrouping() {
    return grouping;
  }


  @JsonProperty(JSON_PROPERTY_GROUPING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGrouping(List<String> grouping) {
    this.grouping = grouping;
  }


  public ReadProductListingRequest fields(List<String> fields) {
    
    this.fields = fields;
    return this;
  }

  public ReadProductListingRequest addFieldsItem(String fieldsItem) {
    if (this.fields == null) {
      this.fields = new ArrayList<>();
    }
    this.fields.add(fieldsItem);
    return this;
  }

   /**
   * Fields which should be returned in the search result.
   * @return fields
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getFields() {
    return fields;
  }


  @JsonProperty(JSON_PROPERTY_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFields(List<String> fields) {
    this.fields = fields;
  }


  public ReadProductListingRequest totalCountMode(TotalCountModeEnum totalCountMode) {
    
    this.totalCountMode = totalCountMode;
    return this;
  }

   /**
   * Whether the total for the total number of hits should be determined for the search query. none &#x3D; disabled total count, exact &#x3D; calculate exact total amount (slow), next-pages &#x3D; calculate only for next page (fast)
   * @return totalCountMode
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TOTAL_COUNT_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TotalCountModeEnum getTotalCountMode() {
    return totalCountMode;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_COUNT_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalCountMode(TotalCountModeEnum totalCountMode) {
    this.totalCountMode = totalCountMode;
  }


  public ReadProductListingRequest order(String order) {
    
    this.order = order;
    return this;
  }

   /**
   * Specifies the sorting of the products by &#x60;availableSortings&#x60;. If not set, the default sorting will be set according to the shop settings. The available sorting options are sent within the response under the &#x60;availableSortings&#x60; key. In order to sort by a field, consider using the &#x60;sort&#x60; parameter from the listing criteria. Do not use both parameters together, as it might lead to unexpected results.
   * @return order
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ORDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOrder() {
    return order;
  }


  @JsonProperty(JSON_PROPERTY_ORDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOrder(String order) {
    this.order = order;
  }


  public ReadProductListingRequest p(Integer p) {
    
    this.p = p;
    return this;
  }

   /**
   * Search result page
   * @return p
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_P)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getP() {
    return p;
  }


  @JsonProperty(JSON_PROPERTY_P)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setP(Integer p) {
    this.p = p;
  }


  public ReadProductListingRequest manufacturer(String manufacturer) {
    
    this.manufacturer = manufacturer;
    return this;
  }

   /**
   * Filter by manufacturers. List of manufacturer identifiers separated by a &#x60;|&#x60;.
   * @return manufacturer
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MANUFACTURER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getManufacturer() {
    return manufacturer;
  }


  @JsonProperty(JSON_PROPERTY_MANUFACTURER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setManufacturer(String manufacturer) {
    this.manufacturer = manufacturer;
  }


  public ReadProductListingRequest minPrice(Integer minPrice) {
    
    this.minPrice = minPrice;
    return this;
  }

   /**
   * Filters by a minimum product price. Has to be lower than the &#x60;max-price&#x60; filter.
   * minimum: 0
   * @return minPrice
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MIN_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMinPrice() {
    return minPrice;
  }


  @JsonProperty(JSON_PROPERTY_MIN_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinPrice(Integer minPrice) {
    this.minPrice = minPrice;
  }


  public ReadProductListingRequest maxPrice(Integer maxPrice) {
    
    this.maxPrice = maxPrice;
    return this;
  }

   /**
   * Filters by a maximum product price. Has to be higher than the &#x60;min-price&#x60; filter.
   * minimum: 0
   * @return maxPrice
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MAX_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMaxPrice() {
    return maxPrice;
  }


  @JsonProperty(JSON_PROPERTY_MAX_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxPrice(Integer maxPrice) {
    this.maxPrice = maxPrice;
  }


  public ReadProductListingRequest rating(Integer rating) {
    
    this.rating = rating;
    return this;
  }

   /**
   * Filter products with a minimum average rating.
   * @return rating
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getRating() {
    return rating;
  }


  @JsonProperty(JSON_PROPERTY_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRating(Integer rating) {
    this.rating = rating;
  }


  public ReadProductListingRequest shippingFree(Boolean shippingFree) {
    
    this.shippingFree = shippingFree;
    return this;
  }

   /**
   * Filters products that are marked as shipping-free.
   * @return shippingFree
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SHIPPING_FREE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShippingFree() {
    return shippingFree;
  }


  @JsonProperty(JSON_PROPERTY_SHIPPING_FREE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShippingFree(Boolean shippingFree) {
    this.shippingFree = shippingFree;
  }


  public ReadProductListingRequest properties(String properties) {
    
    this.properties = properties;
    return this;
  }

   /**
   * Filters products by their properties. List of property identifiers separated by a &#x60;|&#x60;.
   * @return properties
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROPERTIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProperties() {
    return properties;
  }


  @JsonProperty(JSON_PROPERTY_PROPERTIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProperties(String properties) {
    this.properties = properties;
  }


  public ReadProductListingRequest manufacturerFilter(Boolean manufacturerFilter) {
    
    this.manufacturerFilter = manufacturerFilter;
    return this;
  }

   /**
   * Enables/disabled filtering by manufacturer. If set to false, the &#x60;manufacturer&#x60; filter will be ignored. Also the &#x60;aggregations[manufacturer]&#x60; key will be removed from the response.
   * @return manufacturerFilter
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MANUFACTURER_FILTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getManufacturerFilter() {
    return manufacturerFilter;
  }


  @JsonProperty(JSON_PROPERTY_MANUFACTURER_FILTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setManufacturerFilter(Boolean manufacturerFilter) {
    this.manufacturerFilter = manufacturerFilter;
  }


  public ReadProductListingRequest priceFilter(Boolean priceFilter) {
    
    this.priceFilter = priceFilter;
    return this;
  }

   /**
   * Enables/disabled filtering by price. If set to false, the &#x60;min-price&#x60; and &#x60;max-price&#x60; filter will be ignored. Also the &#x60;aggregations[price]&#x60; key will be removed from the response.
   * @return priceFilter
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PRICE_FILTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getPriceFilter() {
    return priceFilter;
  }


  @JsonProperty(JSON_PROPERTY_PRICE_FILTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPriceFilter(Boolean priceFilter) {
    this.priceFilter = priceFilter;
  }


  public ReadProductListingRequest ratingFilter(Boolean ratingFilter) {
    
    this.ratingFilter = ratingFilter;
    return this;
  }

   /**
   * Enables/disabled filtering by rating. If set to false, the &#x60;rating&#x60; filter will be ignored. Also the &#x60;aggregations[rating]&#x60; key will be removed from the response.
   * @return ratingFilter
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_RATING_FILTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getRatingFilter() {
    return ratingFilter;
  }


  @JsonProperty(JSON_PROPERTY_RATING_FILTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRatingFilter(Boolean ratingFilter) {
    this.ratingFilter = ratingFilter;
  }


  public ReadProductListingRequest shippingFreeFilter(Boolean shippingFreeFilter) {
    
    this.shippingFreeFilter = shippingFreeFilter;
    return this;
  }

   /**
   * Enables/disabled filtering by shipping-free products. If set to false, the &#x60;shipping-free&#x60; filter will be ignored. Also the &#x60;aggregations[shipping-free]&#x60; key will be removed from the response.
   * @return shippingFreeFilter
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SHIPPING_FREE_FILTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShippingFreeFilter() {
    return shippingFreeFilter;
  }


  @JsonProperty(JSON_PROPERTY_SHIPPING_FREE_FILTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShippingFreeFilter(Boolean shippingFreeFilter) {
    this.shippingFreeFilter = shippingFreeFilter;
  }


  public ReadProductListingRequest propertyFilter(Boolean propertyFilter) {
    
    this.propertyFilter = propertyFilter;
    return this;
  }

   /**
   * Enables/disabled filtering by properties products. If set to false, the &#x60;properties&#x60; filter will be ignored. Also the &#x60;aggregations[properties]&#x60; key will be removed from the response.
   * @return propertyFilter
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROPERTY_FILTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getPropertyFilter() {
    return propertyFilter;
  }


  @JsonProperty(JSON_PROPERTY_PROPERTY_FILTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPropertyFilter(Boolean propertyFilter) {
    this.propertyFilter = propertyFilter;
  }


  public ReadProductListingRequest propertyWhitelist(String propertyWhitelist) {
    
    this.propertyWhitelist = propertyWhitelist;
    return this;
  }

   /**
   * A whitelist of property identifiers which can be used for filtering. List of property identifiers separated by a &#x60;|&#x60;. The &#x60;property-filter&#x60; must be &#x60;true&#x60;, otherwise the whitelist has no effect.
   * @return propertyWhitelist
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROPERTY_WHITELIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPropertyWhitelist() {
    return propertyWhitelist;
  }


  @JsonProperty(JSON_PROPERTY_PROPERTY_WHITELIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPropertyWhitelist(String propertyWhitelist) {
    this.propertyWhitelist = propertyWhitelist;
  }


  public ReadProductListingRequest reduceAggregations(String reduceAggregations) {
    this.reduceAggregations = JsonNullable.<String>of(reduceAggregations);
    
    return this;
  }

   /**
   * By sending the parameter &#x60;reduce-aggregations&#x60; , the post-filters that were applied by the customer, are also applied to the aggregations. This has the consequence that only values are returned in the aggregations that would lead to further filter results. This parameter is a flag, the value has no effect.
   * @return reduceAggregations
  **/
  @jakarta.annotation.Nullable
  @JsonIgnore

  public String getReduceAggregations() {
        return reduceAggregations.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_REDUCE_AGGREGATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getReduceAggregations_JsonNullable() {
    return reduceAggregations;
  }
  
  @JsonProperty(JSON_PROPERTY_REDUCE_AGGREGATIONS)
  public void setReduceAggregations_JsonNullable(JsonNullable<String> reduceAggregations) {
    this.reduceAggregations = reduceAggregations;
  }

  public void setReduceAggregations(String reduceAggregations) {
    this.reduceAggregations = JsonNullable.<String>of(reduceAggregations);
  }


  public ReadProductListingRequest noAggregations(String noAggregations) {
    this.noAggregations = JsonNullable.<String>of(noAggregations);
    
    return this;
  }

   /**
   * Resets all aggregations in the criteria. This parameter is a flag, the value has no effect.
   * @return noAggregations
  **/
  @jakarta.annotation.Nullable
  @JsonIgnore

  public String getNoAggregations() {
        return noAggregations.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_NO_AGGREGATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getNoAggregations_JsonNullable() {
    return noAggregations;
  }
  
  @JsonProperty(JSON_PROPERTY_NO_AGGREGATIONS)
  public void setNoAggregations_JsonNullable(JsonNullable<String> noAggregations) {
    this.noAggregations = noAggregations;
  }

  public void setNoAggregations(String noAggregations) {
    this.noAggregations = JsonNullable.<String>of(noAggregations);
  }


  public ReadProductListingRequest onlyAggregations(String onlyAggregations) {
    this.onlyAggregations = JsonNullable.<String>of(onlyAggregations);
    
    return this;
  }

   /**
   * If this flag is set, no products are fetched. Sorting and associations are also ignored. This parameter is a flag, the value has no effect.
   * @return onlyAggregations
  **/
  @jakarta.annotation.Nullable
  @JsonIgnore

  public String getOnlyAggregations() {
        return onlyAggregations.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ONLY_AGGREGATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getOnlyAggregations_JsonNullable() {
    return onlyAggregations;
  }
  
  @JsonProperty(JSON_PROPERTY_ONLY_AGGREGATIONS)
  public void setOnlyAggregations_JsonNullable(JsonNullable<String> onlyAggregations) {
    this.onlyAggregations = onlyAggregations;
  }

  public void setOnlyAggregations(String onlyAggregations) {
    this.onlyAggregations = JsonNullable.<String>of(onlyAggregations);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ReadProductListingRequest readProductListingRequest = (ReadProductListingRequest) o;
    return Objects.equals(this.page, readProductListingRequest.page) &&
        Objects.equals(this.limit, readProductListingRequest.limit) &&
        Objects.equals(this.filter, readProductListingRequest.filter) &&
        Objects.equals(this.sort, readProductListingRequest.sort) &&
        Objects.equals(this.postFilter, readProductListingRequest.postFilter) &&
        Objects.equals(this.associations, readProductListingRequest.associations) &&
        Objects.equals(this.aggregations, readProductListingRequest.aggregations) &&
        Objects.equals(this.grouping, readProductListingRequest.grouping) &&
        Objects.equals(this.fields, readProductListingRequest.fields) &&
        Objects.equals(this.totalCountMode, readProductListingRequest.totalCountMode) &&
        Objects.equals(this.order, readProductListingRequest.order) &&
        Objects.equals(this.p, readProductListingRequest.p) &&
        Objects.equals(this.manufacturer, readProductListingRequest.manufacturer) &&
        Objects.equals(this.minPrice, readProductListingRequest.minPrice) &&
        Objects.equals(this.maxPrice, readProductListingRequest.maxPrice) &&
        Objects.equals(this.rating, readProductListingRequest.rating) &&
        Objects.equals(this.shippingFree, readProductListingRequest.shippingFree) &&
        Objects.equals(this.properties, readProductListingRequest.properties) &&
        Objects.equals(this.manufacturerFilter, readProductListingRequest.manufacturerFilter) &&
        Objects.equals(this.priceFilter, readProductListingRequest.priceFilter) &&
        Objects.equals(this.ratingFilter, readProductListingRequest.ratingFilter) &&
        Objects.equals(this.shippingFreeFilter, readProductListingRequest.shippingFreeFilter) &&
        Objects.equals(this.propertyFilter, readProductListingRequest.propertyFilter) &&
        Objects.equals(this.propertyWhitelist, readProductListingRequest.propertyWhitelist) &&
        equalsNullable(this.reduceAggregations, readProductListingRequest.reduceAggregations) &&
        equalsNullable(this.noAggregations, readProductListingRequest.noAggregations) &&
        equalsNullable(this.onlyAggregations, readProductListingRequest.onlyAggregations);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(page, limit, filter, sort, postFilter, associations, aggregations, grouping, fields, totalCountMode, order, p, manufacturer, minPrice, maxPrice, rating, shippingFree, properties, manufacturerFilter, priceFilter, ratingFilter, shippingFreeFilter, propertyFilter, propertyWhitelist, hashCodeNullable(reduceAggregations), hashCodeNullable(noAggregations), hashCodeNullable(onlyAggregations));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ReadProductListingRequest {\n");
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("    limit: ").append(toIndentedString(limit)).append("\n");
    sb.append("    filter: ").append(toIndentedString(filter)).append("\n");
    sb.append("    sort: ").append(toIndentedString(sort)).append("\n");
    sb.append("    postFilter: ").append(toIndentedString(postFilter)).append("\n");
    sb.append("    associations: ").append(toIndentedString(associations)).append("\n");
    sb.append("    aggregations: ").append(toIndentedString(aggregations)).append("\n");
    sb.append("    grouping: ").append(toIndentedString(grouping)).append("\n");
    sb.append("    fields: ").append(toIndentedString(fields)).append("\n");
    sb.append("    totalCountMode: ").append(toIndentedString(totalCountMode)).append("\n");
    sb.append("    order: ").append(toIndentedString(order)).append("\n");
    sb.append("    p: ").append(toIndentedString(p)).append("\n");
    sb.append("    manufacturer: ").append(toIndentedString(manufacturer)).append("\n");
    sb.append("    minPrice: ").append(toIndentedString(minPrice)).append("\n");
    sb.append("    maxPrice: ").append(toIndentedString(maxPrice)).append("\n");
    sb.append("    rating: ").append(toIndentedString(rating)).append("\n");
    sb.append("    shippingFree: ").append(toIndentedString(shippingFree)).append("\n");
    sb.append("    properties: ").append(toIndentedString(properties)).append("\n");
    sb.append("    manufacturerFilter: ").append(toIndentedString(manufacturerFilter)).append("\n");
    sb.append("    priceFilter: ").append(toIndentedString(priceFilter)).append("\n");
    sb.append("    ratingFilter: ").append(toIndentedString(ratingFilter)).append("\n");
    sb.append("    shippingFreeFilter: ").append(toIndentedString(shippingFreeFilter)).append("\n");
    sb.append("    propertyFilter: ").append(toIndentedString(propertyFilter)).append("\n");
    sb.append("    propertyWhitelist: ").append(toIndentedString(propertyWhitelist)).append("\n");
    sb.append("    reduceAggregations: ").append(toIndentedString(reduceAggregations)).append("\n");
    sb.append("    noAggregations: ").append(toIndentedString(noAggregations)).append("\n");
    sb.append("    onlyAggregations: ").append(toIndentedString(onlyAggregations)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

