/*
 * Shopware Store API
 * This endpoint reference contains an overview of all endpoints comprising the Shopware Store API
 *
 * The version of the OpenAPI document: 6.5.7.3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package de.codebarista.shopware.model.core;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

import java.util.Objects;

/**
 * RegisterRequest
 */
@JsonPropertyOrder({
  RegisterRequest.JSON_PROPERTY_EMAIL,
  RegisterRequest.JSON_PROPERTY_PASSWORD,
  RegisterRequest.JSON_PROPERTY_SALUTATION_ID,
  RegisterRequest.JSON_PROPERTY_FIRST_NAME,
  RegisterRequest.JSON_PROPERTY_LAST_NAME,
  RegisterRequest.JSON_PROPERTY_ACCEPTED_DATA_PROTECTION,
  RegisterRequest.JSON_PROPERTY_STOREFRONT_URL,
  RegisterRequest.JSON_PROPERTY_BILLING_ADDRESS,
  RegisterRequest.JSON_PROPERTY_SHIPPING_ADDRESS,
  RegisterRequest.JSON_PROPERTY_ACCOUNT_TYPE,
  RegisterRequest.JSON_PROPERTY_GUEST,
  RegisterRequest.JSON_PROPERTY_BIRTHDAY_DAY,
  RegisterRequest.JSON_PROPERTY_BIRTHDAY_MONTH,
  RegisterRequest.JSON_PROPERTY_BIRTHDAY_YEAR,
  RegisterRequest.JSON_PROPERTY_TITLE,
  RegisterRequest.JSON_PROPERTY_AFFILIATE_CODE,
  RegisterRequest.JSON_PROPERTY_CAMPAIGN_CODE
})
@JsonTypeName("register_request")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-10T11:26:02.541008353+02:00[Europe/Berlin]", comments = "Generator version: 7.5.0")
public class RegisterRequest {
  public static final String JSON_PROPERTY_EMAIL = "email";
  private String email;

  public static final String JSON_PROPERTY_PASSWORD = "password";
  private String password;

  public static final String JSON_PROPERTY_SALUTATION_ID = "salutationId";
  private String salutationId;

  public static final String JSON_PROPERTY_FIRST_NAME = "firstName";
  private String firstName;

  public static final String JSON_PROPERTY_LAST_NAME = "lastName";
  private String lastName;

  public static final String JSON_PROPERTY_ACCEPTED_DATA_PROTECTION = "acceptedDataProtection";
  private Boolean acceptedDataProtection;

  public static final String JSON_PROPERTY_STOREFRONT_URL = "storefrontUrl";
  private String storefrontUrl;

  public static final String JSON_PROPERTY_BILLING_ADDRESS = "billingAddress";
  private CustomerAddress billingAddress;

  public static final String JSON_PROPERTY_SHIPPING_ADDRESS = "shippingAddress";
  private CustomerAddress shippingAddress;

  public static final String JSON_PROPERTY_ACCOUNT_TYPE = "accountType";
  private String accountType = "private";

  public static final String JSON_PROPERTY_GUEST = "guest";
  private Boolean guest = false;

  public static final String JSON_PROPERTY_BIRTHDAY_DAY = "birthdayDay";
  private Integer birthdayDay;

  public static final String JSON_PROPERTY_BIRTHDAY_MONTH = "birthdayMonth";
  private Integer birthdayMonth;

  public static final String JSON_PROPERTY_BIRTHDAY_YEAR = "birthdayYear";
  private Integer birthdayYear;

  public static final String JSON_PROPERTY_TITLE = "title";
  private String title;

  public static final String JSON_PROPERTY_AFFILIATE_CODE = "affiliateCode";
  private String affiliateCode;

  public static final String JSON_PROPERTY_CAMPAIGN_CODE = "campaignCode";
  private String campaignCode;

  public RegisterRequest() {
  }

  public RegisterRequest email(String email) {
    
    this.email = email;
    return this;
  }

   /**
   * Email of the customer. Has to be unique, unless &#x60;guest&#x60; is &#x60;true&#x60;
   * @return email
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getEmail() {
    return email;
  }


  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEmail(String email) {
    this.email = email;
  }


  public RegisterRequest password(String password) {
    
    this.password = password;
    return this;
  }

   /**
   * Password for the customer. Required, unless &#x60;guest&#x60; is &#x60;true&#x60;
   * @return password
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_PASSWORD)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getPassword() {
    return password;
  }


  @JsonProperty(JSON_PROPERTY_PASSWORD)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPassword(String password) {
    this.password = password;
  }


  public RegisterRequest salutationId(String salutationId) {
    
    this.salutationId = salutationId;
    return this;
  }

   /**
   * Id of the salutation for the customer account. Fetch options using &#x60;salutation&#x60; endpoint.
   * @return salutationId
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_SALUTATION_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSalutationId() {
    return salutationId;
  }


  @JsonProperty(JSON_PROPERTY_SALUTATION_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSalutationId(String salutationId) {
    this.salutationId = salutationId;
  }


  public RegisterRequest firstName(String firstName) {
    
    this.firstName = firstName;
    return this;
  }

   /**
   * Customer first name. Value will be reused for shipping and billing address if not provided explicitly.
   * @return firstName
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_FIRST_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getFirstName() {
    return firstName;
  }


  @JsonProperty(JSON_PROPERTY_FIRST_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setFirstName(String firstName) {
    this.firstName = firstName;
  }


  public RegisterRequest lastName(String lastName) {
    
    this.lastName = lastName;
    return this;
  }

   /**
   * Customer last name. Value will be reused for shipping and billing address if not provided explicitly.
   * @return lastName
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_LAST_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getLastName() {
    return lastName;
  }


  @JsonProperty(JSON_PROPERTY_LAST_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLastName(String lastName) {
    this.lastName = lastName;
  }


  public RegisterRequest acceptedDataProtection(Boolean acceptedDataProtection) {
    
    this.acceptedDataProtection = acceptedDataProtection;
    return this;
  }

   /**
   * Flag indicating accepted data protection
   * @return acceptedDataProtection
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_ACCEPTED_DATA_PROTECTION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getAcceptedDataProtection() {
    return acceptedDataProtection;
  }


  @JsonProperty(JSON_PROPERTY_ACCEPTED_DATA_PROTECTION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAcceptedDataProtection(Boolean acceptedDataProtection) {
    this.acceptedDataProtection = acceptedDataProtection;
  }


  public RegisterRequest storefrontUrl(String storefrontUrl) {
    
    this.storefrontUrl = storefrontUrl;
    return this;
  }

   /**
   * URL of the storefront for that registration. Used in confirmation emails. Has to be one of the configured domains of the sales channel.
   * @return storefrontUrl
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_STOREFRONT_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getStorefrontUrl() {
    return storefrontUrl;
  }


  @JsonProperty(JSON_PROPERTY_STOREFRONT_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStorefrontUrl(String storefrontUrl) {
    this.storefrontUrl = storefrontUrl;
  }


  public RegisterRequest billingAddress(CustomerAddress billingAddress) {
    
    this.billingAddress = billingAddress;
    return this;
  }

   /**
   * Get billingAddress
   * @return billingAddress
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_BILLING_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CustomerAddress getBillingAddress() {
    return billingAddress;
  }


  @JsonProperty(JSON_PROPERTY_BILLING_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBillingAddress(CustomerAddress billingAddress) {
    this.billingAddress = billingAddress;
  }


  public RegisterRequest shippingAddress(CustomerAddress shippingAddress) {
    
    this.shippingAddress = shippingAddress;
    return this;
  }

   /**
   * Get shippingAddress
   * @return shippingAddress
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SHIPPING_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomerAddress getShippingAddress() {
    return shippingAddress;
  }


  @JsonProperty(JSON_PROPERTY_SHIPPING_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShippingAddress(CustomerAddress shippingAddress) {
    this.shippingAddress = shippingAddress;
  }


  public RegisterRequest accountType(String accountType) {
    
    this.accountType = accountType;
    return this;
  }

   /**
   * Account type of the customer which can be either &#x60;private&#x60; or &#x60;business&#x60;.
   * @return accountType
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ACCOUNT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAccountType() {
    return accountType;
  }


  @JsonProperty(JSON_PROPERTY_ACCOUNT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccountType(String accountType) {
    this.accountType = accountType;
  }


  public RegisterRequest guest(Boolean guest) {
    
    this.guest = guest;
    return this;
  }

   /**
   * If set, will create a guest customer. Guest customers can re-use an email address and don&#39;t need a password.
   * @return guest
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_GUEST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getGuest() {
    return guest;
  }


  @JsonProperty(JSON_PROPERTY_GUEST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGuest(Boolean guest) {
    this.guest = guest;
  }


  public RegisterRequest birthdayDay(Integer birthdayDay) {
    
    this.birthdayDay = birthdayDay;
    return this;
  }

   /**
   * Birthday day
   * @return birthdayDay
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_BIRTHDAY_DAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getBirthdayDay() {
    return birthdayDay;
  }


  @JsonProperty(JSON_PROPERTY_BIRTHDAY_DAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBirthdayDay(Integer birthdayDay) {
    this.birthdayDay = birthdayDay;
  }


  public RegisterRequest birthdayMonth(Integer birthdayMonth) {
    
    this.birthdayMonth = birthdayMonth;
    return this;
  }

   /**
   * Birthday month
   * @return birthdayMonth
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_BIRTHDAY_MONTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getBirthdayMonth() {
    return birthdayMonth;
  }


  @JsonProperty(JSON_PROPERTY_BIRTHDAY_MONTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBirthdayMonth(Integer birthdayMonth) {
    this.birthdayMonth = birthdayMonth;
  }


  public RegisterRequest birthdayYear(Integer birthdayYear) {
    
    this.birthdayYear = birthdayYear;
    return this;
  }

   /**
   * Birthday year
   * @return birthdayYear
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_BIRTHDAY_YEAR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getBirthdayYear() {
    return birthdayYear;
  }


  @JsonProperty(JSON_PROPERTY_BIRTHDAY_YEAR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBirthdayYear(Integer birthdayYear) {
    this.birthdayYear = birthdayYear;
  }


  public RegisterRequest title(String title) {
    
    this.title = title;
    return this;
  }

   /**
   * (Academic) title of the customer
   * @return title
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TITLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTitle() {
    return title;
  }


  @JsonProperty(JSON_PROPERTY_TITLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTitle(String title) {
    this.title = title;
  }


  public RegisterRequest affiliateCode(String affiliateCode) {
    
    this.affiliateCode = affiliateCode;
    return this;
  }

   /**
   * Field can be used to store an affiliate tracking code
   * @return affiliateCode
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_AFFILIATE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAffiliateCode() {
    return affiliateCode;
  }


  @JsonProperty(JSON_PROPERTY_AFFILIATE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAffiliateCode(String affiliateCode) {
    this.affiliateCode = affiliateCode;
  }


  public RegisterRequest campaignCode(String campaignCode) {
    
    this.campaignCode = campaignCode;
    return this;
  }

   /**
   * Field can be used to store a campaign tracking code
   * @return campaignCode
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CAMPAIGN_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCampaignCode() {
    return campaignCode;
  }


  @JsonProperty(JSON_PROPERTY_CAMPAIGN_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCampaignCode(String campaignCode) {
    this.campaignCode = campaignCode;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RegisterRequest registerRequest = (RegisterRequest) o;
    return Objects.equals(this.email, registerRequest.email) &&
        Objects.equals(this.password, registerRequest.password) &&
        Objects.equals(this.salutationId, registerRequest.salutationId) &&
        Objects.equals(this.firstName, registerRequest.firstName) &&
        Objects.equals(this.lastName, registerRequest.lastName) &&
        Objects.equals(this.acceptedDataProtection, registerRequest.acceptedDataProtection) &&
        Objects.equals(this.storefrontUrl, registerRequest.storefrontUrl) &&
        Objects.equals(this.billingAddress, registerRequest.billingAddress) &&
        Objects.equals(this.shippingAddress, registerRequest.shippingAddress) &&
        Objects.equals(this.accountType, registerRequest.accountType) &&
        Objects.equals(this.guest, registerRequest.guest) &&
        Objects.equals(this.birthdayDay, registerRequest.birthdayDay) &&
        Objects.equals(this.birthdayMonth, registerRequest.birthdayMonth) &&
        Objects.equals(this.birthdayYear, registerRequest.birthdayYear) &&
        Objects.equals(this.title, registerRequest.title) &&
        Objects.equals(this.affiliateCode, registerRequest.affiliateCode) &&
        Objects.equals(this.campaignCode, registerRequest.campaignCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(email, password, salutationId, firstName, lastName, acceptedDataProtection, storefrontUrl, billingAddress, shippingAddress, accountType, guest, birthdayDay, birthdayMonth, birthdayYear, title, affiliateCode, campaignCode);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RegisterRequest {\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    password: ").append(toIndentedString(password)).append("\n");
    sb.append("    salutationId: ").append(toIndentedString(salutationId)).append("\n");
    sb.append("    firstName: ").append(toIndentedString(firstName)).append("\n");
    sb.append("    lastName: ").append(toIndentedString(lastName)).append("\n");
    sb.append("    acceptedDataProtection: ").append(toIndentedString(acceptedDataProtection)).append("\n");
    sb.append("    storefrontUrl: ").append(toIndentedString(storefrontUrl)).append("\n");
    sb.append("    billingAddress: ").append(toIndentedString(billingAddress)).append("\n");
    sb.append("    shippingAddress: ").append(toIndentedString(shippingAddress)).append("\n");
    sb.append("    accountType: ").append(toIndentedString(accountType)).append("\n");
    sb.append("    guest: ").append(toIndentedString(guest)).append("\n");
    sb.append("    birthdayDay: ").append(toIndentedString(birthdayDay)).append("\n");
    sb.append("    birthdayMonth: ").append(toIndentedString(birthdayMonth)).append("\n");
    sb.append("    birthdayYear: ").append(toIndentedString(birthdayYear)).append("\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    affiliateCode: ").append(toIndentedString(affiliateCode)).append("\n");
    sb.append("    campaignCode: ").append(toIndentedString(campaignCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

