/*
 * Shopware Store API
 * This endpoint reference contains an overview of all endpoints comprising the Shopware Store API
 *
 * The version of the OpenAPI document: 6.5.7.3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package de.codebarista.shopware.model.core;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * SalesChannelContext
 */
@JsonPropertyOrder({
  SalesChannelContext.JSON_PROPERTY_API_ALIAS,
  SalesChannelContext.JSON_PROPERTY_TOKEN,
  SalesChannelContext.JSON_PROPERTY_CURRENT_CUSTOMER_GROUP,
  SalesChannelContext.JSON_PROPERTY_FALLBACK_CUSTOMER_GROUP,
  SalesChannelContext.JSON_PROPERTY_CURRENCY,
  SalesChannelContext.JSON_PROPERTY_SALES_CHANNEL,
  SalesChannelContext.JSON_PROPERTY_TAX_RULES,
  SalesChannelContext.JSON_PROPERTY_CUSTOMER,
  SalesChannelContext.JSON_PROPERTY_PAYMENT_METHOD,
  SalesChannelContext.JSON_PROPERTY_SHIPPING_METHOD,
  SalesChannelContext.JSON_PROPERTY_CONTEXT
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-10T11:26:02.541008353+02:00[Europe/Berlin]", comments = "Generator version: 7.5.0")
public class SalesChannelContext {
  public static final String JSON_PROPERTY_API_ALIAS = "apiAlias";
  private String apiAlias;

  public static final String JSON_PROPERTY_TOKEN = "token";
  private String token;

  public static final String JSON_PROPERTY_CURRENT_CUSTOMER_GROUP = "currentCustomerGroup";
  private SalesChannelContextAllOfCurrentCustomerGroup currentCustomerGroup;

  public static final String JSON_PROPERTY_FALLBACK_CUSTOMER_GROUP = "fallbackCustomerGroup";
  private SalesChannelContextAllOfFallbackCustomerGroup fallbackCustomerGroup;

  public static final String JSON_PROPERTY_CURRENCY = "currency";
  private SalesChannelContextAllOfCurrency currency;

  public static final String JSON_PROPERTY_SALES_CHANNEL = "salesChannel";
  private SalesChannelContextAllOfSalesChannel salesChannel;

  public static final String JSON_PROPERTY_TAX_RULES = "taxRules";
  private List<SalesChannelContextAllOfTaxRules> taxRules = new ArrayList<>();

  public static final String JSON_PROPERTY_CUSTOMER = "customer";
  private SalesChannelContextAllOfCustomer customer;

  public static final String JSON_PROPERTY_PAYMENT_METHOD = "paymentMethod";
  private SalesChannelContextAllOfPaymentMethod paymentMethod;

  public static final String JSON_PROPERTY_SHIPPING_METHOD = "shippingMethod";
  private SalesChannelContextAllOfShippingMethod shippingMethod;

  public static final String JSON_PROPERTY_CONTEXT = "context";
  private SalesChannelContextAllOfContext context;

  public SalesChannelContext() {
  }

  public SalesChannelContext apiAlias(String apiAlias) {
    
    this.apiAlias = apiAlias;
    return this;
  }

   /**
   * Alias which can be used to restrict response fields. For more information see [includes](https://shopware.stoplight.io/docs/store-api/docs/concepts/search-queries.md#includes-apialias).
   * @return apiAlias
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_API_ALIAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getApiAlias() {
    return apiAlias;
  }


  @JsonProperty(JSON_PROPERTY_API_ALIAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setApiAlias(String apiAlias) {
    this.apiAlias = apiAlias;
  }


  public SalesChannelContext token(String token) {
    
    this.token = token;
    return this;
  }

   /**
   * Context the user session
   * @return token
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getToken() {
    return token;
  }


  @JsonProperty(JSON_PROPERTY_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setToken(String token) {
    this.token = token;
  }


  public SalesChannelContext currentCustomerGroup(SalesChannelContextAllOfCurrentCustomerGroup currentCustomerGroup) {
    
    this.currentCustomerGroup = currentCustomerGroup;
    return this;
  }

   /**
   * Get currentCustomerGroup
   * @return currentCustomerGroup
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CURRENT_CUSTOMER_GROUP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SalesChannelContextAllOfCurrentCustomerGroup getCurrentCustomerGroup() {
    return currentCustomerGroup;
  }


  @JsonProperty(JSON_PROPERTY_CURRENT_CUSTOMER_GROUP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrentCustomerGroup(SalesChannelContextAllOfCurrentCustomerGroup currentCustomerGroup) {
    this.currentCustomerGroup = currentCustomerGroup;
  }


  public SalesChannelContext fallbackCustomerGroup(SalesChannelContextAllOfFallbackCustomerGroup fallbackCustomerGroup) {
    
    this.fallbackCustomerGroup = fallbackCustomerGroup;
    return this;
  }

   /**
   * Get fallbackCustomerGroup
   * @return fallbackCustomerGroup
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FALLBACK_CUSTOMER_GROUP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SalesChannelContextAllOfFallbackCustomerGroup getFallbackCustomerGroup() {
    return fallbackCustomerGroup;
  }


  @JsonProperty(JSON_PROPERTY_FALLBACK_CUSTOMER_GROUP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFallbackCustomerGroup(SalesChannelContextAllOfFallbackCustomerGroup fallbackCustomerGroup) {
    this.fallbackCustomerGroup = fallbackCustomerGroup;
  }


  public SalesChannelContext currency(SalesChannelContextAllOfCurrency currency) {
    
    this.currency = currency;
    return this;
  }

   /**
   * Get currency
   * @return currency
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SalesChannelContextAllOfCurrency getCurrency() {
    return currency;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrency(SalesChannelContextAllOfCurrency currency) {
    this.currency = currency;
  }


  public SalesChannelContext salesChannel(SalesChannelContextAllOfSalesChannel salesChannel) {
    
    this.salesChannel = salesChannel;
    return this;
  }

   /**
   * Get salesChannel
   * @return salesChannel
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SALES_CHANNEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SalesChannelContextAllOfSalesChannel getSalesChannel() {
    return salesChannel;
  }


  @JsonProperty(JSON_PROPERTY_SALES_CHANNEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSalesChannel(SalesChannelContextAllOfSalesChannel salesChannel) {
    this.salesChannel = salesChannel;
  }


  public SalesChannelContext taxRules(List<SalesChannelContextAllOfTaxRules> taxRules) {
    
    this.taxRules = taxRules;
    return this;
  }

  public SalesChannelContext addTaxRulesItem(SalesChannelContextAllOfTaxRules taxRulesItem) {
    if (this.taxRules == null) {
      this.taxRules = new ArrayList<>();
    }
    this.taxRules.add(taxRulesItem);
    return this;
  }

   /**
   * Currently active tax rules and/or rates
   * @return taxRules
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TAX_RULES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SalesChannelContextAllOfTaxRules> getTaxRules() {
    return taxRules;
  }


  @JsonProperty(JSON_PROPERTY_TAX_RULES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTaxRules(List<SalesChannelContextAllOfTaxRules> taxRules) {
    this.taxRules = taxRules;
  }


  public SalesChannelContext customer(SalesChannelContextAllOfCustomer customer) {
    
    this.customer = customer;
    return this;
  }

   /**
   * Get customer
   * @return customer
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CUSTOMER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SalesChannelContextAllOfCustomer getCustomer() {
    return customer;
  }


  @JsonProperty(JSON_PROPERTY_CUSTOMER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCustomer(SalesChannelContextAllOfCustomer customer) {
    this.customer = customer;
  }


  public SalesChannelContext paymentMethod(SalesChannelContextAllOfPaymentMethod paymentMethod) {
    
    this.paymentMethod = paymentMethod;
    return this;
  }

   /**
   * Get paymentMethod
   * @return paymentMethod
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PAYMENT_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SalesChannelContextAllOfPaymentMethod getPaymentMethod() {
    return paymentMethod;
  }


  @JsonProperty(JSON_PROPERTY_PAYMENT_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaymentMethod(SalesChannelContextAllOfPaymentMethod paymentMethod) {
    this.paymentMethod = paymentMethod;
  }


  public SalesChannelContext shippingMethod(SalesChannelContextAllOfShippingMethod shippingMethod) {
    
    this.shippingMethod = shippingMethod;
    return this;
  }

   /**
   * Get shippingMethod
   * @return shippingMethod
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SHIPPING_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SalesChannelContextAllOfShippingMethod getShippingMethod() {
    return shippingMethod;
  }


  @JsonProperty(JSON_PROPERTY_SHIPPING_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShippingMethod(SalesChannelContextAllOfShippingMethod shippingMethod) {
    this.shippingMethod = shippingMethod;
  }


  public SalesChannelContext context(SalesChannelContextAllOfContext context) {
    
    this.context = context;
    return this;
  }

   /**
   * Get context
   * @return context
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CONTEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SalesChannelContextAllOfContext getContext() {
    return context;
  }


  @JsonProperty(JSON_PROPERTY_CONTEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContext(SalesChannelContextAllOfContext context) {
    this.context = context;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SalesChannelContext salesChannelContext = (SalesChannelContext) o;
    return Objects.equals(this.apiAlias, salesChannelContext.apiAlias) &&
        Objects.equals(this.token, salesChannelContext.token) &&
        Objects.equals(this.currentCustomerGroup, salesChannelContext.currentCustomerGroup) &&
        Objects.equals(this.fallbackCustomerGroup, salesChannelContext.fallbackCustomerGroup) &&
        Objects.equals(this.currency, salesChannelContext.currency) &&
        Objects.equals(this.salesChannel, salesChannelContext.salesChannel) &&
        Objects.equals(this.taxRules, salesChannelContext.taxRules) &&
        Objects.equals(this.customer, salesChannelContext.customer) &&
        Objects.equals(this.paymentMethod, salesChannelContext.paymentMethod) &&
        Objects.equals(this.shippingMethod, salesChannelContext.shippingMethod) &&
        Objects.equals(this.context, salesChannelContext.context);
  }

  @Override
  public int hashCode() {
    return Objects.hash(apiAlias, token, currentCustomerGroup, fallbackCustomerGroup, currency, salesChannel, taxRules, customer, paymentMethod, shippingMethod, context);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SalesChannelContext {\n");
    sb.append("    apiAlias: ").append(toIndentedString(apiAlias)).append("\n");
    sb.append("    token: ").append(toIndentedString(token)).append("\n");
    sb.append("    currentCustomerGroup: ").append(toIndentedString(currentCustomerGroup)).append("\n");
    sb.append("    fallbackCustomerGroup: ").append(toIndentedString(fallbackCustomerGroup)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    salesChannel: ").append(toIndentedString(salesChannel)).append("\n");
    sb.append("    taxRules: ").append(toIndentedString(taxRules)).append("\n");
    sb.append("    customer: ").append(toIndentedString(customer)).append("\n");
    sb.append("    paymentMethod: ").append(toIndentedString(paymentMethod)).append("\n");
    sb.append("    shippingMethod: ").append(toIndentedString(shippingMethod)).append("\n");
    sb.append("    context: ").append(toIndentedString(context)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

