/*
 * Shopware Store API
 * This endpoint reference contains an overview of all endpoints comprising the Shopware Store API
 *
 * The version of the OpenAPI document: 6.5.7.3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package de.codebarista.shopware.model.core;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.openapitools.jackson.nullable.JsonNullable;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * Added since version: 6.0.0.0
 */
@JsonPropertyOrder({
  SalutationJsonApi.JSON_PROPERTY_TYPE,
  SalutationJsonApi.JSON_PROPERTY_ID,
  SalutationJsonApi.JSON_PROPERTY_ATTRIBUTES,
  SalutationJsonApi.JSON_PROPERTY_RELATIONSHIPS,
  SalutationJsonApi.JSON_PROPERTY_LINKS,
  SalutationJsonApi.JSON_PROPERTY_META,
  SalutationJsonApi.JSON_PROPERTY_SALUTATION_KEY,
  SalutationJsonApi.JSON_PROPERTY_DISPLAY_NAME,
  SalutationJsonApi.JSON_PROPERTY_LETTER_NAME,
  SalutationJsonApi.JSON_PROPERTY_CUSTOM_FIELDS,
  SalutationJsonApi.JSON_PROPERTY_CREATED_AT,
  SalutationJsonApi.JSON_PROPERTY_UPDATED_AT,
  SalutationJsonApi.JSON_PROPERTY_TRANSLATED
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-10T11:26:02.541008353+02:00[Europe/Berlin]", comments = "Generator version: 7.5.0")
public class SalutationJsonApi {
  public static final String JSON_PROPERTY_TYPE = "type";
  private String type;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
  private Map<String, Object> attributes = new HashMap<>();

  public static final String JSON_PROPERTY_RELATIONSHIPS = "relationships";
  private JsonNullable<Relationships> relationships = JsonNullable.<Relationships>undefined();

  public static final String JSON_PROPERTY_LINKS = "links";
  private Map<String, Link> links = new HashMap<>();

  public static final String JSON_PROPERTY_META = "meta";
  private Map<String, Object> meta = new HashMap<>();

  public static final String JSON_PROPERTY_SALUTATION_KEY = "salutationKey";
  private String salutationKey;

  public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
  private String displayName;

  public static final String JSON_PROPERTY_LETTER_NAME = "letterName";
  private String letterName;

  public static final String JSON_PROPERTY_CUSTOM_FIELDS = "customFields";
  private Object customFields;

  public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
  private OffsetDateTime createdAt;

  public static final String JSON_PROPERTY_UPDATED_AT = "updatedAt";
  private OffsetDateTime updatedAt;

  public static final String JSON_PROPERTY_TRANSLATED = "translated";
  private Object translated;

  public SalutationJsonApi() {
  }

  @JsonCreator
  public SalutationJsonApi(
    @JsonProperty(JSON_PROPERTY_CREATED_AT) OffsetDateTime createdAt, 
    @JsonProperty(JSON_PROPERTY_UPDATED_AT) OffsetDateTime updatedAt
  ) {
    this();
    this.createdAt = createdAt;
    this.updatedAt = updatedAt;
  }

  public SalutationJsonApi type(String type) {
    
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(String type) {
    this.type = type;
  }


  public SalutationJsonApi id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setId(String id) {
    this.id = id;
  }


  public SalutationJsonApi attributes(Map<String, Object> attributes) {
    
    this.attributes = attributes;
    return this;
  }

  public SalutationJsonApi putAttributesItem(String key, Object attributesItem) {
    if (this.attributes == null) {
      this.attributes = new HashMap<>();
    }
    this.attributes.put(key, attributesItem);
    return this;
  }

   /**
   * Members of the attributes object (\&quot;attributes\&quot;) represent information about the resource object in which it&#39;s defined.
   * @return attributes
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ATTRIBUTES)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Object> getAttributes() {
    return attributes;
  }


  @JsonProperty(JSON_PROPERTY_ATTRIBUTES)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)
  public void setAttributes(Map<String, Object> attributes) {
    this.attributes = attributes;
  }


  public SalutationJsonApi relationships(Relationships relationships) {
    this.relationships = JsonNullable.<Relationships>of(relationships);
    
    return this;
  }

   /**
   * Get relationships
   * @return relationships
  **/
  @jakarta.annotation.Nullable
  @JsonIgnore

  public Relationships getRelationships() {
        return relationships.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_RELATIONSHIPS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Relationships> getRelationships_JsonNullable() {
    return relationships;
  }
  
  @JsonProperty(JSON_PROPERTY_RELATIONSHIPS)
  public void setRelationships_JsonNullable(JsonNullable<Relationships> relationships) {
    this.relationships = relationships;
  }

  public void setRelationships(Relationships relationships) {
    this.relationships = JsonNullable.<Relationships>of(relationships);
  }


  public SalutationJsonApi links(Map<String, Link> links) {
    
    this.links = links;
    return this;
  }

  public SalutationJsonApi putLinksItem(String key, Link linksItem) {
    if (this.links == null) {
      this.links = new HashMap<>();
    }
    this.links.put(key, linksItem);
    return this;
  }

   /**
   * Get links
   * @return links
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Link> getLinks() {
    return links;
  }


  @JsonProperty(JSON_PROPERTY_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLinks(Map<String, Link> links) {
    this.links = links;
  }


  public SalutationJsonApi meta(Map<String, Object> meta) {
    
    this.meta = meta;
    return this;
  }

  public SalutationJsonApi putMetaItem(String key, Object metaItem) {
    if (this.meta == null) {
      this.meta = new HashMap<>();
    }
    this.meta.put(key, metaItem);
    return this;
  }

   /**
   * Non-standard meta-information that can not be represented as an attribute or relationship.
   * @return meta
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_META)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Object> getMeta() {
    return meta;
  }


  @JsonProperty(JSON_PROPERTY_META)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)
  public void setMeta(Map<String, Object> meta) {
    this.meta = meta;
  }


  public SalutationJsonApi salutationKey(String salutationKey) {
    
    this.salutationKey = salutationKey;
    return this;
  }

   /**
   * Get salutationKey
   * @return salutationKey
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_SALUTATION_KEY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSalutationKey() {
    return salutationKey;
  }


  @JsonProperty(JSON_PROPERTY_SALUTATION_KEY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSalutationKey(String salutationKey) {
    this.salutationKey = salutationKey;
  }


  public SalutationJsonApi displayName(String displayName) {
    
    this.displayName = displayName;
    return this;
  }

   /**
   * Get displayName
   * @return displayName
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDisplayName() {
    return displayName;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDisplayName(String displayName) {
    this.displayName = displayName;
  }


  public SalutationJsonApi letterName(String letterName) {
    
    this.letterName = letterName;
    return this;
  }

   /**
   * Get letterName
   * @return letterName
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_LETTER_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getLetterName() {
    return letterName;
  }


  @JsonProperty(JSON_PROPERTY_LETTER_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLetterName(String letterName) {
    this.letterName = letterName;
  }


  public SalutationJsonApi customFields(Object customFields) {
    
    this.customFields = customFields;
    return this;
  }

   /**
   * Get customFields
   * @return customFields
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CUSTOM_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getCustomFields() {
    return customFields;
  }


  @JsonProperty(JSON_PROPERTY_CUSTOM_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCustomFields(Object customFields) {
    this.customFields = customFields;
  }


   /**
   * Get createdAt
   * @return createdAt
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }




   /**
   * Get updatedAt
   * @return updatedAt
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getUpdatedAt() {
    return updatedAt;
  }




  public SalutationJsonApi translated(Object translated) {
    
    this.translated = translated;
    return this;
  }

   /**
   * Get translated
   * @return translated
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TRANSLATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getTranslated() {
    return translated;
  }


  @JsonProperty(JSON_PROPERTY_TRANSLATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTranslated(Object translated) {
    this.translated = translated;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SalutationJsonApi salutationJsonApi = (SalutationJsonApi) o;
    return Objects.equals(this.type, salutationJsonApi.type) &&
        Objects.equals(this.id, salutationJsonApi.id) &&
        Objects.equals(this.attributes, salutationJsonApi.attributes) &&
        equalsNullable(this.relationships, salutationJsonApi.relationships) &&
        Objects.equals(this.links, salutationJsonApi.links) &&
        Objects.equals(this.meta, salutationJsonApi.meta) &&
        Objects.equals(this.salutationKey, salutationJsonApi.salutationKey) &&
        Objects.equals(this.displayName, salutationJsonApi.displayName) &&
        Objects.equals(this.letterName, salutationJsonApi.letterName) &&
        Objects.equals(this.customFields, salutationJsonApi.customFields) &&
        Objects.equals(this.createdAt, salutationJsonApi.createdAt) &&
        Objects.equals(this.updatedAt, salutationJsonApi.updatedAt) &&
        Objects.equals(this.translated, salutationJsonApi.translated);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, id, attributes, hashCodeNullable(relationships), links, meta, salutationKey, displayName, letterName, customFields, createdAt, updatedAt, translated);
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SalutationJsonApi {\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    attributes: ").append(toIndentedString(attributes)).append("\n");
    sb.append("    relationships: ").append(toIndentedString(relationships)).append("\n");
    sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("    meta: ").append(toIndentedString(meta)).append("\n");
    sb.append("    salutationKey: ").append(toIndentedString(salutationKey)).append("\n");
    sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
    sb.append("    letterName: ").append(toIndentedString(letterName)).append("\n");
    sb.append("    customFields: ").append(toIndentedString(customFields)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("    translated: ").append(toIndentedString(translated)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

