/*
 * Shopware Store API
 * This endpoint reference contains an overview of all endpoints comprising the Shopware Store API
 *
 * The version of the OpenAPI document: 6.5.7.3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package de.codebarista.shopware.model.core;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

import java.util.Objects;

/**
 * SubscribeToNewsletterRequest
 */
@JsonPropertyOrder({
  SubscribeToNewsletterRequest.JSON_PROPERTY_EMAIL,
  SubscribeToNewsletterRequest.JSON_PROPERTY_OPTION,
  SubscribeToNewsletterRequest.JSON_PROPERTY_STOREFRONT_URL,
  SubscribeToNewsletterRequest.JSON_PROPERTY_SALUTATION_ID,
  SubscribeToNewsletterRequest.JSON_PROPERTY_FIRST_NAME,
  SubscribeToNewsletterRequest.JSON_PROPERTY_LAST_NAME,
  SubscribeToNewsletterRequest.JSON_PROPERTY_STREET,
  SubscribeToNewsletterRequest.JSON_PROPERTY_CITY,
  SubscribeToNewsletterRequest.JSON_PROPERTY_ZIP_CODE,
  SubscribeToNewsletterRequest.JSON_PROPERTY_TAGS,
  SubscribeToNewsletterRequest.JSON_PROPERTY_LANGUAGE_ID,
  SubscribeToNewsletterRequest.JSON_PROPERTY_CUSTOM_FIELDS
})
@JsonTypeName("subscribeToNewsletter_request")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-10T11:26:02.541008353+02:00[Europe/Berlin]", comments = "Generator version: 7.5.0")
public class SubscribeToNewsletterRequest {
  public static final String JSON_PROPERTY_EMAIL = "email";
  private String email;

  public static final String JSON_PROPERTY_OPTION = "option";
  private String option;

  public static final String JSON_PROPERTY_STOREFRONT_URL = "storefrontUrl";
  private String storefrontUrl;

  public static final String JSON_PROPERTY_SALUTATION_ID = "salutationId";
  private String salutationId;

  public static final String JSON_PROPERTY_FIRST_NAME = "firstName";
  private String firstName;

  public static final String JSON_PROPERTY_LAST_NAME = "lastName";
  private String lastName;

  public static final String JSON_PROPERTY_STREET = "street";
  private String street;

  public static final String JSON_PROPERTY_CITY = "city";
  private String city;

  public static final String JSON_PROPERTY_ZIP_CODE = "zipCode";
  private String zipCode;

  public static final String JSON_PROPERTY_TAGS = "tags";
  private String tags;

  public static final String JSON_PROPERTY_LANGUAGE_ID = "languageId";
  private String languageId;

  public static final String JSON_PROPERTY_CUSTOM_FIELDS = "customFields";
  private String customFields;

  public SubscribeToNewsletterRequest() {
  }

  public SubscribeToNewsletterRequest email(String email) {
    
    this.email = email;
    return this;
  }

   /**
   * Email address that will receive the confirmation and the newsletter.
   * @return email
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getEmail() {
    return email;
  }


  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEmail(String email) {
    this.email = email;
  }


  public SubscribeToNewsletterRequest option(String option) {
    
    this.option = option;
    return this;
  }

   /**
   * Defines what should be done.
   * @return option
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_OPTION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getOption() {
    return option;
  }


  @JsonProperty(JSON_PROPERTY_OPTION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOption(String option) {
    this.option = option;
  }


  public SubscribeToNewsletterRequest storefrontUrl(String storefrontUrl) {
    
    this.storefrontUrl = storefrontUrl;
    return this;
  }

   /**
   * Url of the storefront of the shop. This will be used for generating the link to the /newsletter/confirm inside the confirm email.
   * @return storefrontUrl
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_STOREFRONT_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getStorefrontUrl() {
    return storefrontUrl;
  }


  @JsonProperty(JSON_PROPERTY_STOREFRONT_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStorefrontUrl(String storefrontUrl) {
    this.storefrontUrl = storefrontUrl;
  }


  public SubscribeToNewsletterRequest salutationId(String salutationId) {
    
    this.salutationId = salutationId;
    return this;
  }

   /**
   * Identifier of the salutation.
   * @return salutationId
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SALUTATION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSalutationId() {
    return salutationId;
  }


  @JsonProperty(JSON_PROPERTY_SALUTATION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSalutationId(String salutationId) {
    this.salutationId = salutationId;
  }


  public SubscribeToNewsletterRequest firstName(String firstName) {
    
    this.firstName = firstName;
    return this;
  }

   /**
   * First name
   * @return firstName
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FIRST_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFirstName() {
    return firstName;
  }


  @JsonProperty(JSON_PROPERTY_FIRST_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFirstName(String firstName) {
    this.firstName = firstName;
  }


  public SubscribeToNewsletterRequest lastName(String lastName) {
    
    this.lastName = lastName;
    return this;
  }

   /**
   * Last name
   * @return lastName
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LAST_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLastName() {
    return lastName;
  }


  @JsonProperty(JSON_PROPERTY_LAST_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLastName(String lastName) {
    this.lastName = lastName;
  }


  public SubscribeToNewsletterRequest street(String street) {
    
    this.street = street;
    return this;
  }

   /**
   * Street
   * @return street
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_STREET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getStreet() {
    return street;
  }


  @JsonProperty(JSON_PROPERTY_STREET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStreet(String street) {
    this.street = street;
  }


  public SubscribeToNewsletterRequest city(String city) {
    
    this.city = city;
    return this;
  }

   /**
   * City
   * @return city
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCity() {
    return city;
  }


  @JsonProperty(JSON_PROPERTY_CITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCity(String city) {
    this.city = city;
  }


  public SubscribeToNewsletterRequest zipCode(String zipCode) {
    
    this.zipCode = zipCode;
    return this;
  }

   /**
   * Zip code
   * @return zipCode
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ZIP_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getZipCode() {
    return zipCode;
  }


  @JsonProperty(JSON_PROPERTY_ZIP_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setZipCode(String zipCode) {
    this.zipCode = zipCode;
  }


  public SubscribeToNewsletterRequest tags(String tags) {
    
    this.tags = tags;
    return this;
  }

   /**
   * Zip code
   * @return tags
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTags() {
    return tags;
  }


  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTags(String tags) {
    this.tags = tags;
  }


  public SubscribeToNewsletterRequest languageId(String languageId) {
    
    this.languageId = languageId;
    return this;
  }

   /**
   * Identifier of the language.
   * @return languageId
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LANGUAGE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLanguageId() {
    return languageId;
  }


  @JsonProperty(JSON_PROPERTY_LANGUAGE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLanguageId(String languageId) {
    this.languageId = languageId;
  }


  public SubscribeToNewsletterRequest customFields(String customFields) {
    
    this.customFields = customFields;
    return this;
  }

   /**
   * Custom field data that should be added to the subscription.
   * @return customFields
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CUSTOM_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCustomFields() {
    return customFields;
  }


  @JsonProperty(JSON_PROPERTY_CUSTOM_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCustomFields(String customFields) {
    this.customFields = customFields;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SubscribeToNewsletterRequest subscribeToNewsletterRequest = (SubscribeToNewsletterRequest) o;
    return Objects.equals(this.email, subscribeToNewsletterRequest.email) &&
        Objects.equals(this.option, subscribeToNewsletterRequest.option) &&
        Objects.equals(this.storefrontUrl, subscribeToNewsletterRequest.storefrontUrl) &&
        Objects.equals(this.salutationId, subscribeToNewsletterRequest.salutationId) &&
        Objects.equals(this.firstName, subscribeToNewsletterRequest.firstName) &&
        Objects.equals(this.lastName, subscribeToNewsletterRequest.lastName) &&
        Objects.equals(this.street, subscribeToNewsletterRequest.street) &&
        Objects.equals(this.city, subscribeToNewsletterRequest.city) &&
        Objects.equals(this.zipCode, subscribeToNewsletterRequest.zipCode) &&
        Objects.equals(this.tags, subscribeToNewsletterRequest.tags) &&
        Objects.equals(this.languageId, subscribeToNewsletterRequest.languageId) &&
        Objects.equals(this.customFields, subscribeToNewsletterRequest.customFields);
  }

  @Override
  public int hashCode() {
    return Objects.hash(email, option, storefrontUrl, salutationId, firstName, lastName, street, city, zipCode, tags, languageId, customFields);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SubscribeToNewsletterRequest {\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    option: ").append(toIndentedString(option)).append("\n");
    sb.append("    storefrontUrl: ").append(toIndentedString(storefrontUrl)).append("\n");
    sb.append("    salutationId: ").append(toIndentedString(salutationId)).append("\n");
    sb.append("    firstName: ").append(toIndentedString(firstName)).append("\n");
    sb.append("    lastName: ").append(toIndentedString(lastName)).append("\n");
    sb.append("    street: ").append(toIndentedString(street)).append("\n");
    sb.append("    city: ").append(toIndentedString(city)).append("\n");
    sb.append("    zipCode: ").append(toIndentedString(zipCode)).append("\n");
    sb.append("    tags: ").append(toIndentedString(tags)).append("\n");
    sb.append("    languageId: ").append(toIndentedString(languageId)).append("\n");
    sb.append("    customFields: ").append(toIndentedString(customFields)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

