/*
 * Decompiled with CFR 0.152.
 */
package de.codebarista.shopware.model.core;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonNode;
import de.codebarista.shopware.model.core.DocumentBaseConfig;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"id", "name", "technicalName", "createdAt", "updatedAt", "customFields", "translated"})
public class DocumentType {
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_TECHNICAL_NAME = "technicalName";
    private String technicalName;
    public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_UPDATED_AT = "updatedAt";
    private OffsetDateTime updatedAt;
    public static final String JSON_PROPERTY_CUSTOM_FIELDS = "customFields";
    private Object customFields;
    public static final String JSON_PROPERTY_TRANSLATED = "translated";
    private JsonNode translated;
    public static final String JSON_PROPERTY_BASE_CONFIGS = "documentBaseConfigs";
    private List<DocumentBaseConfig> baseConfigs = new ArrayList<DocumentBaseConfig>();

    public DocumentType() {
    }

    @JsonCreator
    public DocumentType(@JsonProperty(value="createdAt") OffsetDateTime createdAt, @JsonProperty(value="updatedAt") OffsetDateTime updatedAt) {
        this();
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    public DocumentType id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public DocumentType name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public DocumentType technicalName(String technicalName) {
        this.technicalName = technicalName;
        return this;
    }

    @Nonnull
    @JsonProperty(value="technicalName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTechnicalName() {
        return this.technicalName;
    }

    @JsonProperty(value="technicalName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTechnicalName(String technicalName) {
        this.technicalName = technicalName;
    }

    public DocumentType baseConfigs(List<DocumentBaseConfig> baseConfigs) {
        this.baseConfigs = baseConfigs;
        return this;
    }

    @JsonProperty(value="documentBaseConfigs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<DocumentBaseConfig> getBaseConfigs() {
        return this.baseConfigs;
    }

    @JsonProperty(value="documentBaseConfigs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBaseConfigs(List<DocumentBaseConfig> baseConfigs) {
        this.baseConfigs = baseConfigs;
    }

    @Nonnull
    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Nullable
    @JsonProperty(value="updatedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public DocumentType customFields(Object customFields) {
        this.customFields = customFields;
        return this;
    }

    @Nullable
    @JsonProperty(value="customFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getCustomFields() {
        return this.customFields;
    }

    @JsonProperty(value="customFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustomFields(Object customFields) {
        this.customFields = customFields;
    }

    public DocumentType translated(JsonNode translated) {
        this.translated = translated;
        return this;
    }

    @Nullable
    @JsonProperty(value="translated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNode getTranslated() {
        return this.translated;
    }

    @JsonProperty(value="translated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTranslated(JsonNode translated) {
        this.translated = translated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentType documentType = (DocumentType)o;
        return Objects.equals(this.id, documentType.id) && Objects.equals(this.name, documentType.name) && Objects.equals(this.technicalName, documentType.technicalName) && Objects.equals(this.createdAt, documentType.createdAt) && Objects.equals(this.updatedAt, documentType.updatedAt) && Objects.equals(this.customFields, documentType.customFields) && Objects.equals(this.translated, documentType.translated);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.technicalName, this.createdAt, this.updatedAt, this.customFields, this.translated);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentType {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    technicalName: ").append(this.toIndentedString(this.technicalName)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    translated: ").append(this.toIndentedString(this.translated)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

