/*
 * Decompiled with CFR 0.152.
 */
package de.codebarista.shopware.model.core;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import de.codebarista.shopware.model.core.Error;
import de.codebarista.shopware.model.core.Link;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonPropertyOrder(value={"meta", "links", "errors"})
@JsonTypeName(value="failure")
public class Failure {
    public static final String JSON_PROPERTY_META = "meta";
    private Map<String, Object> meta = new HashMap<String, Object>();
    public static final String JSON_PROPERTY_LINKS = "links";
    private Map<String, Link> links = new HashMap<String, Link>();
    public static final String JSON_PROPERTY_ERRORS = "errors";
    private Set<Error> errors = new LinkedHashSet<Error>();

    public Failure meta(Map<String, Object> meta) {
        this.meta = meta;
        return this;
    }

    public Failure putMetaItem(String key, Object metaItem) {
        if (this.meta == null) {
            this.meta = new HashMap<String, Object>();
        }
        this.meta.put(key, metaItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="meta")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getMeta() {
        return this.meta;
    }

    @JsonProperty(value="meta")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public void setMeta(Map<String, Object> meta) {
        this.meta = meta;
    }

    public Failure links(Map<String, Link> links) {
        this.links = links;
        return this;
    }

    public Failure putLinksItem(String key, Link linksItem) {
        if (this.links == null) {
            this.links = new HashMap<String, Link>();
        }
        this.links.put(key, linksItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Link> getLinks() {
        return this.links;
    }

    @JsonProperty(value="links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(Map<String, Link> links) {
        this.links = links;
    }

    public Failure errors(Set<Error> errors) {
        this.errors = errors;
        return this;
    }

    public Failure addErrorsItem(Error errorsItem) {
        if (this.errors == null) {
            this.errors = new LinkedHashSet<Error>();
        }
        this.errors.add(errorsItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="errors")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Set<Error> getErrors() {
        return this.errors;
    }

    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonProperty(value="errors")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setErrors(Set<Error> errors) {
        this.errors = errors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Failure failure = (Failure)o;
        return Objects.equals(this.meta, failure.meta) && Objects.equals(this.links, failure.links) && Objects.equals(this.errors, failure.errors);
    }

    public int hashCode() {
        return Objects.hash(this.meta, this.links, this.errors);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Failure {\n");
        sb.append("    meta: ").append(this.toIndentedString(this.meta)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

