/*
 * Decompiled with CFR 0.152.
 */
package de.codebarista.shopware.model.core;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import de.codebarista.shopware.model.core.LanguageJsonApiAllOfRelationships;
import de.codebarista.shopware.model.core.Link;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"type", "id", "attributes", "relationships", "links", "meta", "parentId", "localeId", "translationCodeId", "name", "customFields", "createdAt", "updatedAt"})
public class LanguageJsonApi {
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    private Map<String, Object> attributes = new HashMap<String, Object>();
    public static final String JSON_PROPERTY_RELATIONSHIPS = "relationships";
    private LanguageJsonApiAllOfRelationships relationships;
    public static final String JSON_PROPERTY_LINKS = "links";
    private Map<String, Link> links = new HashMap<String, Link>();
    public static final String JSON_PROPERTY_META = "meta";
    private Map<String, Object> meta = new HashMap<String, Object>();
    public static final String JSON_PROPERTY_PARENT_ID = "parentId";
    private String parentId;
    public static final String JSON_PROPERTY_LOCALE_ID = "localeId";
    private String localeId;
    public static final String JSON_PROPERTY_TRANSLATION_CODE_ID = "translationCodeId";
    private String translationCodeId;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_CUSTOM_FIELDS = "customFields";
    private Object customFields;
    public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_UPDATED_AT = "updatedAt";
    private OffsetDateTime updatedAt;

    public LanguageJsonApi() {
    }

    @JsonCreator
    public LanguageJsonApi(@JsonProperty(value="createdAt") OffsetDateTime createdAt, @JsonProperty(value="updatedAt") OffsetDateTime updatedAt) {
        this();
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    public LanguageJsonApi type(String type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(String type) {
        this.type = type;
    }

    public LanguageJsonApi id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(String id) {
        this.id = id;
    }

    public LanguageJsonApi attributes(Map<String, Object> attributes) {
        this.attributes = attributes;
        return this;
    }

    public LanguageJsonApi putAttributesItem(String key, Object attributesItem) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(key, attributesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="attributes")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @JsonProperty(value="attributes")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public LanguageJsonApi relationships(LanguageJsonApiAllOfRelationships relationships) {
        this.relationships = relationships;
        return this;
    }

    @Nullable
    @JsonProperty(value="relationships")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LanguageJsonApiAllOfRelationships getRelationships() {
        return this.relationships;
    }

    @JsonProperty(value="relationships")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRelationships(LanguageJsonApiAllOfRelationships relationships) {
        this.relationships = relationships;
    }

    public LanguageJsonApi links(Map<String, Link> links) {
        this.links = links;
        return this;
    }

    public LanguageJsonApi putLinksItem(String key, Link linksItem) {
        if (this.links == null) {
            this.links = new HashMap<String, Link>();
        }
        this.links.put(key, linksItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Link> getLinks() {
        return this.links;
    }

    @JsonProperty(value="links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(Map<String, Link> links) {
        this.links = links;
    }

    public LanguageJsonApi meta(Map<String, Object> meta) {
        this.meta = meta;
        return this;
    }

    public LanguageJsonApi putMetaItem(String key, Object metaItem) {
        if (this.meta == null) {
            this.meta = new HashMap<String, Object>();
        }
        this.meta.put(key, metaItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="meta")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getMeta() {
        return this.meta;
    }

    @JsonProperty(value="meta")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public void setMeta(Map<String, Object> meta) {
        this.meta = meta;
    }

    public LanguageJsonApi parentId(String parentId) {
        this.parentId = parentId;
        return this;
    }

    @Nullable
    @JsonProperty(value="parentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getParentId() {
        return this.parentId;
    }

    @JsonProperty(value="parentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public LanguageJsonApi localeId(String localeId) {
        this.localeId = localeId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="localeId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getLocaleId() {
        return this.localeId;
    }

    @JsonProperty(value="localeId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLocaleId(String localeId) {
        this.localeId = localeId;
    }

    public LanguageJsonApi translationCodeId(String translationCodeId) {
        this.translationCodeId = translationCodeId;
        return this;
    }

    @Nullable
    @JsonProperty(value="translationCodeId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTranslationCodeId() {
        return this.translationCodeId;
    }

    @JsonProperty(value="translationCodeId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTranslationCodeId(String translationCodeId) {
        this.translationCodeId = translationCodeId;
    }

    public LanguageJsonApi name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public LanguageJsonApi customFields(Object customFields) {
        this.customFields = customFields;
        return this;
    }

    @Nullable
    @JsonProperty(value="customFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getCustomFields() {
        return this.customFields;
    }

    @JsonProperty(value="customFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustomFields(Object customFields) {
        this.customFields = customFields;
    }

    @Nonnull
    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Nullable
    @JsonProperty(value="updatedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LanguageJsonApi languageJsonApi = (LanguageJsonApi)o;
        return Objects.equals(this.type, languageJsonApi.type) && Objects.equals(this.id, languageJsonApi.id) && Objects.equals(this.attributes, languageJsonApi.attributes) && Objects.equals(this.relationships, languageJsonApi.relationships) && Objects.equals(this.links, languageJsonApi.links) && Objects.equals(this.meta, languageJsonApi.meta) && Objects.equals(this.parentId, languageJsonApi.parentId) && Objects.equals(this.localeId, languageJsonApi.localeId) && Objects.equals(this.translationCodeId, languageJsonApi.translationCodeId) && Objects.equals(this.name, languageJsonApi.name) && Objects.equals(this.customFields, languageJsonApi.customFields) && Objects.equals(this.createdAt, languageJsonApi.createdAt) && Objects.equals(this.updatedAt, languageJsonApi.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.id, this.attributes, this.relationships, this.links, this.meta, this.parentId, this.localeId, this.translationCodeId, this.name, this.customFields, this.createdAt, this.updatedAt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LanguageJsonApi {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    relationships: ").append(this.toIndentedString(this.relationships)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    meta: ").append(this.toIndentedString(this.meta)).append("\n");
        sb.append("    parentId: ").append(this.toIndentedString(this.parentId)).append("\n");
        sb.append("    localeId: ").append(this.toIndentedString(this.localeId)).append("\n");
        sb.append("    translationCodeId: ").append(this.toIndentedString(this.translationCodeId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

