/*
 * Decompiled with CFR 0.152.
 */
package de.codebarista.shopware.model.core;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import de.codebarista.shopware.model.core.Link;
import de.codebarista.shopware.model.core.Relationships;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"type", "id", "attributes", "relationships", "links", "meta", "productId", "productVersionId", "categoryId", "categoryVersionId", "salesChannelId", "createdAt", "updatedAt"})
public class MainCategoryJsonApi {
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    private Map<String, Object> attributes = new HashMap<String, Object>();
    public static final String JSON_PROPERTY_RELATIONSHIPS = "relationships";
    private JsonNullable<Relationships> relationships = JsonNullable.undefined();
    public static final String JSON_PROPERTY_LINKS = "links";
    private Map<String, Link> links = new HashMap<String, Link>();
    public static final String JSON_PROPERTY_META = "meta";
    private Map<String, Object> meta = new HashMap<String, Object>();
    public static final String JSON_PROPERTY_PRODUCT_ID = "productId";
    private String productId;
    public static final String JSON_PROPERTY_PRODUCT_VERSION_ID = "productVersionId";
    private String productVersionId;
    public static final String JSON_PROPERTY_CATEGORY_ID = "categoryId";
    private String categoryId;
    public static final String JSON_PROPERTY_CATEGORY_VERSION_ID = "categoryVersionId";
    private String categoryVersionId;
    public static final String JSON_PROPERTY_SALES_CHANNEL_ID = "salesChannelId";
    private String salesChannelId;
    public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_UPDATED_AT = "updatedAt";
    private OffsetDateTime updatedAt;

    public MainCategoryJsonApi() {
    }

    @JsonCreator
    public MainCategoryJsonApi(@JsonProperty(value="createdAt") OffsetDateTime createdAt, @JsonProperty(value="updatedAt") OffsetDateTime updatedAt) {
        this();
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    public MainCategoryJsonApi type(String type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(String type) {
        this.type = type;
    }

    public MainCategoryJsonApi id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(String id) {
        this.id = id;
    }

    public MainCategoryJsonApi attributes(Map<String, Object> attributes) {
        this.attributes = attributes;
        return this;
    }

    public MainCategoryJsonApi putAttributesItem(String key, Object attributesItem) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(key, attributesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="attributes")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @JsonProperty(value="attributes")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public MainCategoryJsonApi relationships(Relationships relationships) {
        this.relationships = JsonNullable.of((Object)relationships);
        return this;
    }

    @Nullable
    @JsonIgnore
    public Relationships getRelationships() {
        return (Relationships)this.relationships.orElse(null);
    }

    @JsonProperty(value="relationships")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Relationships> getRelationships_JsonNullable() {
        return this.relationships;
    }

    @JsonProperty(value="relationships")
    public void setRelationships_JsonNullable(JsonNullable<Relationships> relationships) {
        this.relationships = relationships;
    }

    public void setRelationships(Relationships relationships) {
        this.relationships = JsonNullable.of((Object)relationships);
    }

    public MainCategoryJsonApi links(Map<String, Link> links) {
        this.links = links;
        return this;
    }

    public MainCategoryJsonApi putLinksItem(String key, Link linksItem) {
        if (this.links == null) {
            this.links = new HashMap<String, Link>();
        }
        this.links.put(key, linksItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Link> getLinks() {
        return this.links;
    }

    @JsonProperty(value="links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(Map<String, Link> links) {
        this.links = links;
    }

    public MainCategoryJsonApi meta(Map<String, Object> meta) {
        this.meta = meta;
        return this;
    }

    public MainCategoryJsonApi putMetaItem(String key, Object metaItem) {
        if (this.meta == null) {
            this.meta = new HashMap<String, Object>();
        }
        this.meta.put(key, metaItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="meta")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getMeta() {
        return this.meta;
    }

    @JsonProperty(value="meta")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public void setMeta(Map<String, Object> meta) {
        this.meta = meta;
    }

    public MainCategoryJsonApi productId(String productId) {
        this.productId = productId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="productId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getProductId() {
        return this.productId;
    }

    @JsonProperty(value="productId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setProductId(String productId) {
        this.productId = productId;
    }

    public MainCategoryJsonApi productVersionId(String productVersionId) {
        this.productVersionId = productVersionId;
        return this;
    }

    @Nullable
    @JsonProperty(value="productVersionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getProductVersionId() {
        return this.productVersionId;
    }

    @JsonProperty(value="productVersionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProductVersionId(String productVersionId) {
        this.productVersionId = productVersionId;
    }

    public MainCategoryJsonApi categoryId(String categoryId) {
        this.categoryId = categoryId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="categoryId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCategoryId() {
        return this.categoryId;
    }

    @JsonProperty(value="categoryId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
    }

    public MainCategoryJsonApi categoryVersionId(String categoryVersionId) {
        this.categoryVersionId = categoryVersionId;
        return this;
    }

    @Nullable
    @JsonProperty(value="categoryVersionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCategoryVersionId() {
        return this.categoryVersionId;
    }

    @JsonProperty(value="categoryVersionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCategoryVersionId(String categoryVersionId) {
        this.categoryVersionId = categoryVersionId;
    }

    public MainCategoryJsonApi salesChannelId(String salesChannelId) {
        this.salesChannelId = salesChannelId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="salesChannelId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSalesChannelId() {
        return this.salesChannelId;
    }

    @JsonProperty(value="salesChannelId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSalesChannelId(String salesChannelId) {
        this.salesChannelId = salesChannelId;
    }

    @Nonnull
    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Nullable
    @JsonProperty(value="updatedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MainCategoryJsonApi mainCategoryJsonApi = (MainCategoryJsonApi)o;
        return Objects.equals(this.type, mainCategoryJsonApi.type) && Objects.equals(this.id, mainCategoryJsonApi.id) && Objects.equals(this.attributes, mainCategoryJsonApi.attributes) && MainCategoryJsonApi.equalsNullable(this.relationships, mainCategoryJsonApi.relationships) && Objects.equals(this.links, mainCategoryJsonApi.links) && Objects.equals(this.meta, mainCategoryJsonApi.meta) && Objects.equals(this.productId, mainCategoryJsonApi.productId) && Objects.equals(this.productVersionId, mainCategoryJsonApi.productVersionId) && Objects.equals(this.categoryId, mainCategoryJsonApi.categoryId) && Objects.equals(this.categoryVersionId, mainCategoryJsonApi.categoryVersionId) && Objects.equals(this.salesChannelId, mainCategoryJsonApi.salesChannelId) && Objects.equals(this.createdAt, mainCategoryJsonApi.createdAt) && Objects.equals(this.updatedAt, mainCategoryJsonApi.updatedAt);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.type, this.id, this.attributes, MainCategoryJsonApi.hashCodeNullable(this.relationships), this.links, this.meta, this.productId, this.productVersionId, this.categoryId, this.categoryVersionId, this.salesChannelId, this.createdAt, this.updatedAt);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MainCategoryJsonApi {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    relationships: ").append(this.toIndentedString(this.relationships)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    meta: ").append(this.toIndentedString(this.meta)).append("\n");
        sb.append("    productId: ").append(this.toIndentedString(this.productId)).append("\n");
        sb.append("    productVersionId: ").append(this.toIndentedString(this.productVersionId)).append("\n");
        sb.append("    categoryId: ").append(this.toIndentedString(this.categoryId)).append("\n");
        sb.append("    categoryVersionId: ").append(this.toIndentedString(this.categoryVersionId)).append("\n");
        sb.append("    salesChannelId: ").append(this.toIndentedString(this.salesChannelId)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

