/*
 * Decompiled with CFR 0.152.
 */
package de.codebarista.shopware.model.core;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import de.codebarista.shopware.model.core.CalculatedTax;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"netPrice", "totalPrice", "calculatedTaxes", "taxRules", "positionPrice", "rawTotal", "taxStatus"})
@JsonTypeName(value="Order_price")
public class OrderPrice {
    public static final String JSON_PROPERTY_NET_PRICE = "netPrice";
    private BigDecimal netPrice;
    public static final String JSON_PROPERTY_TOTAL_PRICE = "totalPrice";
    private BigDecimal totalPrice;
    public static final String JSON_PROPERTY_CALCULATED_TAXES = "calculatedTaxes";
    private List<CalculatedTax> calculatedTaxes;
    public static final String JSON_PROPERTY_TAX_RULES = "taxRules";
    private Object taxRules;
    public static final String JSON_PROPERTY_POSITION_PRICE = "positionPrice";
    private BigDecimal positionPrice;
    public static final String JSON_PROPERTY_RAW_TOTAL = "rawTotal";
    private BigDecimal rawTotal;
    public static final String JSON_PROPERTY_TAX_STATUS = "taxStatus";
    private String taxStatus;

    public OrderPrice netPrice(BigDecimal netPrice) {
        this.netPrice = netPrice;
        return this;
    }

    @Nonnull
    @JsonProperty(value="netPrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BigDecimal getNetPrice() {
        return this.netPrice;
    }

    @JsonProperty(value="netPrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setNetPrice(BigDecimal netPrice) {
        this.netPrice = netPrice;
    }

    public OrderPrice totalPrice(BigDecimal totalPrice) {
        this.totalPrice = totalPrice;
        return this;
    }

    @Nonnull
    @JsonProperty(value="totalPrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BigDecimal getTotalPrice() {
        return this.totalPrice;
    }

    @JsonProperty(value="totalPrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTotalPrice(BigDecimal totalPrice) {
        this.totalPrice = totalPrice;
    }

    public OrderPrice calculatedTaxes(List<CalculatedTax> calculatedTaxes) {
        this.calculatedTaxes = calculatedTaxes;
        return this;
    }

    @Nullable
    @JsonProperty(value="calculatedTaxes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<CalculatedTax> getCalculatedTaxes() {
        return this.calculatedTaxes;
    }

    @JsonProperty(value="calculatedTaxes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCalculatedTaxes(List<CalculatedTax> calculatedTaxes) {
        this.calculatedTaxes = calculatedTaxes;
    }

    public OrderPrice taxRules(Object taxRules) {
        this.taxRules = taxRules;
        return this;
    }

    @Nullable
    @JsonProperty(value="taxRules")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getTaxRules() {
        return this.taxRules;
    }

    @JsonProperty(value="taxRules")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTaxRules(Object taxRules) {
        this.taxRules = taxRules;
    }

    public OrderPrice positionPrice(BigDecimal positionPrice) {
        this.positionPrice = positionPrice;
        return this;
    }

    @Nonnull
    @JsonProperty(value="positionPrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BigDecimal getPositionPrice() {
        return this.positionPrice;
    }

    @JsonProperty(value="positionPrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPositionPrice(BigDecimal positionPrice) {
        this.positionPrice = positionPrice;
    }

    public OrderPrice rawTotal(BigDecimal rawTotal) {
        this.rawTotal = rawTotal;
        return this;
    }

    @Nonnull
    @JsonProperty(value="rawTotal")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BigDecimal getRawTotal() {
        return this.rawTotal;
    }

    @JsonProperty(value="rawTotal")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRawTotal(BigDecimal rawTotal) {
        this.rawTotal = rawTotal;
    }

    public OrderPrice taxStatus(String taxStatus) {
        this.taxStatus = taxStatus;
        return this;
    }

    @Nonnull
    @JsonProperty(value="taxStatus")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTaxStatus() {
        return this.taxStatus;
    }

    @JsonProperty(value="taxStatus")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTaxStatus(String taxStatus) {
        this.taxStatus = taxStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderPrice orderPrice = (OrderPrice)o;
        return Objects.equals(this.netPrice, orderPrice.netPrice) && Objects.equals(this.totalPrice, orderPrice.totalPrice) && Objects.equals(this.calculatedTaxes, orderPrice.calculatedTaxes) && Objects.equals(this.taxRules, orderPrice.taxRules) && Objects.equals(this.positionPrice, orderPrice.positionPrice) && Objects.equals(this.rawTotal, orderPrice.rawTotal) && Objects.equals(this.taxStatus, orderPrice.taxStatus);
    }

    public int hashCode() {
        return Objects.hash(this.netPrice, this.totalPrice, this.calculatedTaxes, this.taxRules, this.positionPrice, this.rawTotal, this.taxStatus);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderPrice {\n");
        sb.append("    netPrice: ").append(this.toIndentedString(this.netPrice)).append("\n");
        sb.append("    totalPrice: ").append(this.toIndentedString(this.totalPrice)).append("\n");
        sb.append("    calculatedTaxes: ").append(this.toIndentedString(this.calculatedTaxes)).append("\n");
        sb.append("    taxRules: ").append(this.toIndentedString(this.taxRules)).append("\n");
        sb.append("    positionPrice: ").append(this.toIndentedString(this.positionPrice)).append("\n");
        sb.append("    rawTotal: ").append(this.toIndentedString(this.rawTotal)).append("\n");
        sb.append("    taxStatus: ").append(this.toIndentedString(this.taxStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

