/*
 * Decompiled with CFR 0.152.
 */
package de.codebarista.shopware.model.core;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import de.codebarista.shopware.model.core.Order;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"orders", "paymentChangeable"})
public class OrderRouteResponse {
    public static final String JSON_PROPERTY_ORDERS = "orders";
    private List<Order> orders = new ArrayList<Order>();
    public static final String JSON_PROPERTY_PAYMENT_CHANGEABLE = "paymentChangeable";
    private Map<String, Boolean> paymentChangeable = new HashMap<String, Boolean>();

    public OrderRouteResponse orders(List<Order> orders) {
        this.orders = orders;
        return this;
    }

    public OrderRouteResponse addOrdersItem(Order ordersItem) {
        if (this.orders == null) {
            this.orders = new ArrayList<Order>();
        }
        this.orders.add(ordersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="orders")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Order> getOrders() {
        return this.orders;
    }

    @JsonProperty(value="orders")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOrders(List<Order> orders) {
        this.orders = orders;
    }

    public OrderRouteResponse paymentChangeable(Map<String, Boolean> paymentChangeable) {
        this.paymentChangeable = paymentChangeable;
        return this;
    }

    public OrderRouteResponse putPaymentChangeableItem(String key, Boolean paymentChangeableItem) {
        if (this.paymentChangeable == null) {
            this.paymentChangeable = new HashMap<String, Boolean>();
        }
        this.paymentChangeable.put(key, paymentChangeableItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="paymentChangeable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Boolean> getPaymentChangeable() {
        return this.paymentChangeable;
    }

    @JsonProperty(value="paymentChangeable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentChangeable(Map<String, Boolean> paymentChangeable) {
        this.paymentChangeable = paymentChangeable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderRouteResponse orderRouteResponse = (OrderRouteResponse)o;
        return Objects.equals(this.orders, orderRouteResponse.orders) && Objects.equals(this.paymentChangeable, orderRouteResponse.paymentChangeable);
    }

    public int hashCode() {
        return Objects.hash(this.orders, this.paymentChangeable);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderRouteResponse {\n");
        sb.append("    orders: ").append(this.toIndentedString(this.orders)).append("\n");
        sb.append("    paymentChangeable: ").append(this.toIndentedString(this.paymentChangeable)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

