/*
 * Decompiled with CFR 0.152.
 */
package de.codebarista.shopware.model.core;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import de.codebarista.shopware.model.core.Link;
import de.codebarista.shopware.model.core.Relationships;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"type", "id", "attributes", "relationships", "links", "meta", "salesChannelId", "languageId", "foreignKey", "routeName", "pathInfo", "seoPathInfo", "isCanonical", "isModified", "isDeleted", "url", "customFields", "isValid", "createdAt", "updatedAt"})
public class SeoUrlJsonApi {
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    private Map<String, Object> attributes = new HashMap<String, Object>();
    public static final String JSON_PROPERTY_RELATIONSHIPS = "relationships";
    private JsonNullable<Relationships> relationships = JsonNullable.undefined();
    public static final String JSON_PROPERTY_LINKS = "links";
    private Map<String, Link> links = new HashMap<String, Link>();
    public static final String JSON_PROPERTY_META = "meta";
    private Map<String, Object> meta = new HashMap<String, Object>();
    public static final String JSON_PROPERTY_SALES_CHANNEL_ID = "salesChannelId";
    private String salesChannelId;
    public static final String JSON_PROPERTY_LANGUAGE_ID = "languageId";
    private String languageId;
    public static final String JSON_PROPERTY_FOREIGN_KEY = "foreignKey";
    private String foreignKey;
    public static final String JSON_PROPERTY_ROUTE_NAME = "routeName";
    private String routeName;
    public static final String JSON_PROPERTY_PATH_INFO = "pathInfo";
    private String pathInfo;
    public static final String JSON_PROPERTY_SEO_PATH_INFO = "seoPathInfo";
    private String seoPathInfo;
    public static final String JSON_PROPERTY_IS_CANONICAL = "isCanonical";
    private Boolean isCanonical;
    public static final String JSON_PROPERTY_IS_MODIFIED = "isModified";
    private Boolean isModified;
    public static final String JSON_PROPERTY_IS_DELETED = "isDeleted";
    private Boolean isDeleted;
    public static final String JSON_PROPERTY_URL = "url";
    private String url;
    public static final String JSON_PROPERTY_CUSTOM_FIELDS = "customFields";
    private Object customFields;
    public static final String JSON_PROPERTY_IS_VALID = "isValid";
    private Boolean isValid;
    public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_UPDATED_AT = "updatedAt";
    private OffsetDateTime updatedAt;

    public SeoUrlJsonApi() {
    }

    @JsonCreator
    public SeoUrlJsonApi(@JsonProperty(value="createdAt") OffsetDateTime createdAt, @JsonProperty(value="updatedAt") OffsetDateTime updatedAt) {
        this();
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    public SeoUrlJsonApi type(String type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(String type) {
        this.type = type;
    }

    public SeoUrlJsonApi id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(String id) {
        this.id = id;
    }

    public SeoUrlJsonApi attributes(Map<String, Object> attributes) {
        this.attributes = attributes;
        return this;
    }

    public SeoUrlJsonApi putAttributesItem(String key, Object attributesItem) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(key, attributesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="attributes")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @JsonProperty(value="attributes")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public SeoUrlJsonApi relationships(Relationships relationships) {
        this.relationships = JsonNullable.of((Object)relationships);
        return this;
    }

    @Nullable
    @JsonIgnore
    public Relationships getRelationships() {
        return (Relationships)this.relationships.orElse(null);
    }

    @JsonProperty(value="relationships")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Relationships> getRelationships_JsonNullable() {
        return this.relationships;
    }

    @JsonProperty(value="relationships")
    public void setRelationships_JsonNullable(JsonNullable<Relationships> relationships) {
        this.relationships = relationships;
    }

    public void setRelationships(Relationships relationships) {
        this.relationships = JsonNullable.of((Object)relationships);
    }

    public SeoUrlJsonApi links(Map<String, Link> links) {
        this.links = links;
        return this;
    }

    public SeoUrlJsonApi putLinksItem(String key, Link linksItem) {
        if (this.links == null) {
            this.links = new HashMap<String, Link>();
        }
        this.links.put(key, linksItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Link> getLinks() {
        return this.links;
    }

    @JsonProperty(value="links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(Map<String, Link> links) {
        this.links = links;
    }

    public SeoUrlJsonApi meta(Map<String, Object> meta) {
        this.meta = meta;
        return this;
    }

    public SeoUrlJsonApi putMetaItem(String key, Object metaItem) {
        if (this.meta == null) {
            this.meta = new HashMap<String, Object>();
        }
        this.meta.put(key, metaItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="meta")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getMeta() {
        return this.meta;
    }

    @JsonProperty(value="meta")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public void setMeta(Map<String, Object> meta) {
        this.meta = meta;
    }

    public SeoUrlJsonApi salesChannelId(String salesChannelId) {
        this.salesChannelId = salesChannelId;
        return this;
    }

    @Nullable
    @JsonProperty(value="salesChannelId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSalesChannelId() {
        return this.salesChannelId;
    }

    @JsonProperty(value="salesChannelId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSalesChannelId(String salesChannelId) {
        this.salesChannelId = salesChannelId;
    }

    public SeoUrlJsonApi languageId(String languageId) {
        this.languageId = languageId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="languageId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getLanguageId() {
        return this.languageId;
    }

    @JsonProperty(value="languageId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLanguageId(String languageId) {
        this.languageId = languageId;
    }

    public SeoUrlJsonApi foreignKey(String foreignKey) {
        this.foreignKey = foreignKey;
        return this;
    }

    @Nonnull
    @JsonProperty(value="foreignKey")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getForeignKey() {
        return this.foreignKey;
    }

    @JsonProperty(value="foreignKey")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setForeignKey(String foreignKey) {
        this.foreignKey = foreignKey;
    }

    public SeoUrlJsonApi routeName(String routeName) {
        this.routeName = routeName;
        return this;
    }

    @Nonnull
    @JsonProperty(value="routeName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRouteName() {
        return this.routeName;
    }

    @JsonProperty(value="routeName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRouteName(String routeName) {
        this.routeName = routeName;
    }

    public SeoUrlJsonApi pathInfo(String pathInfo) {
        this.pathInfo = pathInfo;
        return this;
    }

    @Nonnull
    @JsonProperty(value="pathInfo")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getPathInfo() {
        return this.pathInfo;
    }

    @JsonProperty(value="pathInfo")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPathInfo(String pathInfo) {
        this.pathInfo = pathInfo;
    }

    public SeoUrlJsonApi seoPathInfo(String seoPathInfo) {
        this.seoPathInfo = seoPathInfo;
        return this;
    }

    @Nonnull
    @JsonProperty(value="seoPathInfo")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSeoPathInfo() {
        return this.seoPathInfo;
    }

    @JsonProperty(value="seoPathInfo")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSeoPathInfo(String seoPathInfo) {
        this.seoPathInfo = seoPathInfo;
    }

    public SeoUrlJsonApi isCanonical(Boolean isCanonical) {
        this.isCanonical = isCanonical;
        return this;
    }

    @Nullable
    @JsonProperty(value="isCanonical")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsCanonical() {
        return this.isCanonical;
    }

    @JsonProperty(value="isCanonical")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIsCanonical(Boolean isCanonical) {
        this.isCanonical = isCanonical;
    }

    public SeoUrlJsonApi isModified(Boolean isModified) {
        this.isModified = isModified;
        return this;
    }

    @Nullable
    @JsonProperty(value="isModified")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsModified() {
        return this.isModified;
    }

    @JsonProperty(value="isModified")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIsModified(Boolean isModified) {
        this.isModified = isModified;
    }

    public SeoUrlJsonApi isDeleted(Boolean isDeleted) {
        this.isDeleted = isDeleted;
        return this;
    }

    @Nullable
    @JsonProperty(value="isDeleted")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsDeleted() {
        return this.isDeleted;
    }

    @JsonProperty(value="isDeleted")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIsDeleted(Boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    public SeoUrlJsonApi url(String url) {
        this.url = url;
        return this;
    }

    @Nullable
    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUrl(String url) {
        this.url = url;
    }

    public SeoUrlJsonApi customFields(Object customFields) {
        this.customFields = customFields;
        return this;
    }

    @Nullable
    @JsonProperty(value="customFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getCustomFields() {
        return this.customFields;
    }

    @JsonProperty(value="customFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustomFields(Object customFields) {
        this.customFields = customFields;
    }

    public SeoUrlJsonApi isValid(Boolean isValid) {
        this.isValid = isValid;
        return this;
    }

    @Nullable
    @JsonProperty(value="isValid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsValid() {
        return this.isValid;
    }

    @JsonProperty(value="isValid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    @Nonnull
    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Nullable
    @JsonProperty(value="updatedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SeoUrlJsonApi seoUrlJsonApi = (SeoUrlJsonApi)o;
        return Objects.equals(this.type, seoUrlJsonApi.type) && Objects.equals(this.id, seoUrlJsonApi.id) && Objects.equals(this.attributes, seoUrlJsonApi.attributes) && SeoUrlJsonApi.equalsNullable(this.relationships, seoUrlJsonApi.relationships) && Objects.equals(this.links, seoUrlJsonApi.links) && Objects.equals(this.meta, seoUrlJsonApi.meta) && Objects.equals(this.salesChannelId, seoUrlJsonApi.salesChannelId) && Objects.equals(this.languageId, seoUrlJsonApi.languageId) && Objects.equals(this.foreignKey, seoUrlJsonApi.foreignKey) && Objects.equals(this.routeName, seoUrlJsonApi.routeName) && Objects.equals(this.pathInfo, seoUrlJsonApi.pathInfo) && Objects.equals(this.seoPathInfo, seoUrlJsonApi.seoPathInfo) && Objects.equals(this.isCanonical, seoUrlJsonApi.isCanonical) && Objects.equals(this.isModified, seoUrlJsonApi.isModified) && Objects.equals(this.isDeleted, seoUrlJsonApi.isDeleted) && Objects.equals(this.url, seoUrlJsonApi.url) && Objects.equals(this.customFields, seoUrlJsonApi.customFields) && Objects.equals(this.isValid, seoUrlJsonApi.isValid) && Objects.equals(this.createdAt, seoUrlJsonApi.createdAt) && Objects.equals(this.updatedAt, seoUrlJsonApi.updatedAt);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.type, this.id, this.attributes, SeoUrlJsonApi.hashCodeNullable(this.relationships), this.links, this.meta, this.salesChannelId, this.languageId, this.foreignKey, this.routeName, this.pathInfo, this.seoPathInfo, this.isCanonical, this.isModified, this.isDeleted, this.url, this.customFields, this.isValid, this.createdAt, this.updatedAt);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SeoUrlJsonApi {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    relationships: ").append(this.toIndentedString(this.relationships)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    meta: ").append(this.toIndentedString(this.meta)).append("\n");
        sb.append("    salesChannelId: ").append(this.toIndentedString(this.salesChannelId)).append("\n");
        sb.append("    languageId: ").append(this.toIndentedString(this.languageId)).append("\n");
        sb.append("    foreignKey: ").append(this.toIndentedString(this.foreignKey)).append("\n");
        sb.append("    routeName: ").append(this.toIndentedString(this.routeName)).append("\n");
        sb.append("    pathInfo: ").append(this.toIndentedString(this.pathInfo)).append("\n");
        sb.append("    seoPathInfo: ").append(this.toIndentedString(this.seoPathInfo)).append("\n");
        sb.append("    isCanonical: ").append(this.toIndentedString(this.isCanonical)).append("\n");
        sb.append("    isModified: ").append(this.toIndentedString(this.isModified)).append("\n");
        sb.append("    isDeleted: ").append(this.toIndentedString(this.isDeleted)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    isValid: ").append(this.toIndentedString(this.isValid)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

