/*
 * Decompiled with CFR 0.152.
 */
package de.codebarista.shopware.model.core;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import de.codebarista.shopware.model.core.Data;
import de.codebarista.shopware.model.core.Resource;
import de.codebarista.shopware.model.core.SuccessLinks;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonPropertyOrder(value={"meta", "links", "data", "included"})
@JsonTypeName(value="success")
public class Success {
    public static final String JSON_PROPERTY_META = "meta";
    private Map<String, Object> meta = new HashMap<String, Object>();
    public static final String JSON_PROPERTY_LINKS = "links";
    private SuccessLinks links;
    public static final String JSON_PROPERTY_DATA = "data";
    private Data data;
    public static final String JSON_PROPERTY_INCLUDED = "included";
    private Set<Resource> included = new LinkedHashSet<Resource>();

    public Success meta(Map<String, Object> meta) {
        this.meta = meta;
        return this;
    }

    public Success putMetaItem(String key, Object metaItem) {
        if (this.meta == null) {
            this.meta = new HashMap<String, Object>();
        }
        this.meta.put(key, metaItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="meta")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getMeta() {
        return this.meta;
    }

    @JsonProperty(value="meta")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public void setMeta(Map<String, Object> meta) {
        this.meta = meta;
    }

    public Success links(SuccessLinks links) {
        this.links = links;
        return this;
    }

    @Nullable
    @JsonProperty(value="links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SuccessLinks getLinks() {
        return this.links;
    }

    @JsonProperty(value="links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(SuccessLinks links) {
        this.links = links;
    }

    public Success data(Data data) {
        this.data = data;
        return this;
    }

    @Nonnull
    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Data getData() {
        return this.data;
    }

    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setData(Data data) {
        this.data = data;
    }

    public Success included(Set<Resource> included) {
        this.included = included;
        return this;
    }

    public Success addIncludedItem(Resource includedItem) {
        if (this.included == null) {
            this.included = new LinkedHashSet<Resource>();
        }
        this.included.add(includedItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="included")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Set<Resource> getIncluded() {
        return this.included;
    }

    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonProperty(value="included")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncluded(Set<Resource> included) {
        this.included = included;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Success success = (Success)o;
        return Objects.equals(this.meta, success.meta) && Objects.equals(this.links, success.links) && Objects.equals(this.data, success.data) && Objects.equals(this.included, success.included);
    }

    public int hashCode() {
        return Objects.hash(this.meta, this.links, this.data, this.included);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Success {\n");
        sb.append("    meta: ").append(this.toIndentedString(this.meta)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    included: ").append(this.toIndentedString(this.included)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

