/*
 * Decompiled with CFR 0.152.
 */
package de.codebarista.shopware.model.core;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.codebarista.shopware.model.core.CalculatedTax;
import de.codebarista.shopware.model.extension.ShopwareTaxStatus;
import jakarta.annotation.Nullable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;

public record CalculatedPrice(@JsonProperty(value="quantity") BigDecimal quantity, @JsonProperty(value="totalPrice") BigDecimal totalPrice, @JsonProperty(value="unitPrice") BigDecimal unitPrice, @JsonProperty(value="calculatedTaxes") List<CalculatedTax> calculatedTaxes) {
    @Nullable
    public BigDecimal singleTaxRate() {
        CalculatedTax singleCalculatedTax = this.singleCalculatedTax();
        return singleCalculatedTax != null ? singleCalculatedTax.taxRate() : null;
    }

    public BigDecimal netUnitPrice(ShopwareTaxStatus taxStatus) {
        return this.totalNetPrice(taxStatus).divide(this.quantity, 4, RoundingMode.HALF_UP);
    }

    public BigDecimal totalNetPrice(ShopwareTaxStatus taxStatus) {
        if (taxStatus == ShopwareTaxStatus.NET) {
            return this.totalPrice;
        }
        return this.totalPrice.subtract(this.totalTaxAmount());
    }

    public BigDecimal totalTaxAmount() {
        return this.calculatedTaxes.stream().map(CalculatedTax::tax).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
    }

    @Nullable
    private CalculatedTax singleCalculatedTax() {
        if (this.calculatedTaxes.isEmpty()) {
            return null;
        }
        if (this.calculatedTaxes.size() == 1) {
            return this.calculatedTaxes.get(0);
        }
        throw new RuntimeException("Has more than one calculated tax");
    }
}

