/*
 * Decompiled with CFR 0.152.
 */
package de.codebarista.shopware.model.core;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import de.codebarista.shopware.model.core.Link;
import de.codebarista.shopware.model.core.Relationships;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"type", "id", "attributes", "relationships", "links", "meta", "countryId", "shortCode", "name", "position", "active", "customFields", "createdAt", "updatedAt", "translated"})
public class CountryStateJsonApi {
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    private Map<String, Object> attributes = new HashMap<String, Object>();
    public static final String JSON_PROPERTY_RELATIONSHIPS = "relationships";
    private JsonNullable<Relationships> relationships = JsonNullable.undefined();
    public static final String JSON_PROPERTY_LINKS = "links";
    private Map<String, Link> links = new HashMap<String, Link>();
    public static final String JSON_PROPERTY_META = "meta";
    private Map<String, Object> meta = new HashMap<String, Object>();
    public static final String JSON_PROPERTY_COUNTRY_ID = "countryId";
    private String countryId;
    public static final String JSON_PROPERTY_SHORT_CODE = "shortCode";
    private String shortCode;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_POSITION = "position";
    private Long position;
    public static final String JSON_PROPERTY_ACTIVE = "active";
    private Boolean active;
    public static final String JSON_PROPERTY_CUSTOM_FIELDS = "customFields";
    private Object customFields;
    public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_UPDATED_AT = "updatedAt";
    private OffsetDateTime updatedAt;
    public static final String JSON_PROPERTY_TRANSLATED = "translated";
    private Object translated;

    public CountryStateJsonApi() {
    }

    @JsonCreator
    public CountryStateJsonApi(@JsonProperty(value="createdAt") OffsetDateTime createdAt, @JsonProperty(value="updatedAt") OffsetDateTime updatedAt) {
        this();
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    public CountryStateJsonApi type(String type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(String type) {
        this.type = type;
    }

    public CountryStateJsonApi id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(String id) {
        this.id = id;
    }

    public CountryStateJsonApi attributes(Map<String, Object> attributes) {
        this.attributes = attributes;
        return this;
    }

    public CountryStateJsonApi putAttributesItem(String key, Object attributesItem) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(key, attributesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="attributes")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @JsonProperty(value="attributes")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public CountryStateJsonApi relationships(Relationships relationships) {
        this.relationships = JsonNullable.of((Object)relationships);
        return this;
    }

    @Nullable
    @JsonIgnore
    public Relationships getRelationships() {
        return (Relationships)this.relationships.orElse(null);
    }

    @JsonProperty(value="relationships")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Relationships> getRelationships_JsonNullable() {
        return this.relationships;
    }

    @JsonProperty(value="relationships")
    public void setRelationships_JsonNullable(JsonNullable<Relationships> relationships) {
        this.relationships = relationships;
    }

    public void setRelationships(Relationships relationships) {
        this.relationships = JsonNullable.of((Object)relationships);
    }

    public CountryStateJsonApi links(Map<String, Link> links) {
        this.links = links;
        return this;
    }

    public CountryStateJsonApi putLinksItem(String key, Link linksItem) {
        if (this.links == null) {
            this.links = new HashMap<String, Link>();
        }
        this.links.put(key, linksItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Link> getLinks() {
        return this.links;
    }

    @JsonProperty(value="links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(Map<String, Link> links) {
        this.links = links;
    }

    public CountryStateJsonApi meta(Map<String, Object> meta) {
        this.meta = meta;
        return this;
    }

    public CountryStateJsonApi putMetaItem(String key, Object metaItem) {
        if (this.meta == null) {
            this.meta = new HashMap<String, Object>();
        }
        this.meta.put(key, metaItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="meta")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getMeta() {
        return this.meta;
    }

    @JsonProperty(value="meta")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public void setMeta(Map<String, Object> meta) {
        this.meta = meta;
    }

    public CountryStateJsonApi countryId(String countryId) {
        this.countryId = countryId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="countryId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCountryId() {
        return this.countryId;
    }

    @JsonProperty(value="countryId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCountryId(String countryId) {
        this.countryId = countryId;
    }

    public CountryStateJsonApi shortCode(String shortCode) {
        this.shortCode = shortCode;
        return this;
    }

    @Nonnull
    @JsonProperty(value="shortCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getShortCode() {
        return this.shortCode;
    }

    @JsonProperty(value="shortCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setShortCode(String shortCode) {
        this.shortCode = shortCode;
    }

    public CountryStateJsonApi name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public CountryStateJsonApi position(Long position) {
        this.position = position;
        return this;
    }

    @Nullable
    @JsonProperty(value="position")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getPosition() {
        return this.position;
    }

    @JsonProperty(value="position")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPosition(Long position) {
        this.position = position;
    }

    public CountryStateJsonApi active(Boolean active) {
        this.active = active;
        return this;
    }

    @Nullable
    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getActive() {
        return this.active;
    }

    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setActive(Boolean active) {
        this.active = active;
    }

    public CountryStateJsonApi customFields(Object customFields) {
        this.customFields = customFields;
        return this;
    }

    @Nullable
    @JsonProperty(value="customFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getCustomFields() {
        return this.customFields;
    }

    @JsonProperty(value="customFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustomFields(Object customFields) {
        this.customFields = customFields;
    }

    @Nonnull
    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Nullable
    @JsonProperty(value="updatedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public CountryStateJsonApi translated(Object translated) {
        this.translated = translated;
        return this;
    }

    @Nullable
    @JsonProperty(value="translated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getTranslated() {
        return this.translated;
    }

    @JsonProperty(value="translated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTranslated(Object translated) {
        this.translated = translated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CountryStateJsonApi countryStateJsonApi = (CountryStateJsonApi)o;
        return Objects.equals(this.type, countryStateJsonApi.type) && Objects.equals(this.id, countryStateJsonApi.id) && Objects.equals(this.attributes, countryStateJsonApi.attributes) && CountryStateJsonApi.equalsNullable(this.relationships, countryStateJsonApi.relationships) && Objects.equals(this.links, countryStateJsonApi.links) && Objects.equals(this.meta, countryStateJsonApi.meta) && Objects.equals(this.countryId, countryStateJsonApi.countryId) && Objects.equals(this.shortCode, countryStateJsonApi.shortCode) && Objects.equals(this.name, countryStateJsonApi.name) && Objects.equals(this.position, countryStateJsonApi.position) && Objects.equals(this.active, countryStateJsonApi.active) && Objects.equals(this.customFields, countryStateJsonApi.customFields) && Objects.equals(this.createdAt, countryStateJsonApi.createdAt) && Objects.equals(this.updatedAt, countryStateJsonApi.updatedAt) && Objects.equals(this.translated, countryStateJsonApi.translated);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.type, this.id, this.attributes, CountryStateJsonApi.hashCodeNullable(this.relationships), this.links, this.meta, this.countryId, this.shortCode, this.name, this.position, this.active, this.customFields, this.createdAt, this.updatedAt, this.translated);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CountryStateJsonApi {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    relationships: ").append(this.toIndentedString(this.relationships)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    meta: ").append(this.toIndentedString(this.meta)).append("\n");
        sb.append("    countryId: ").append(this.toIndentedString(this.countryId)).append("\n");
        sb.append("    shortCode: ").append(this.toIndentedString(this.shortCode)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    position: ").append(this.toIndentedString(this.position)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    translated: ").append(this.toIndentedString(this.translated)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

