/*
 * Decompiled with CFR 0.152.
 */
package de.codebarista.shopware.model.core;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import de.codebarista.shopware.model.core.CurrencyJsonApiAllOfItemRounding;
import de.codebarista.shopware.model.core.Link;
import de.codebarista.shopware.model.core.Relationships;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"type", "id", "attributes", "relationships", "links", "meta", "factor", "symbol", "isoCode", "shortName", "name", "position", "isSystemDefault", "taxFreeFrom", "customFields", "itemRounding", "totalRounding", "createdAt", "updatedAt", "translated"})
public class CurrencyJsonApi {
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    private Map<String, Object> attributes = new HashMap<String, Object>();
    public static final String JSON_PROPERTY_RELATIONSHIPS = "relationships";
    private JsonNullable<Relationships> relationships = JsonNullable.undefined();
    public static final String JSON_PROPERTY_LINKS = "links";
    private Map<String, Link> links = new HashMap<String, Link>();
    public static final String JSON_PROPERTY_META = "meta";
    private Map<String, Object> meta = new HashMap<String, Object>();
    public static final String JSON_PROPERTY_FACTOR = "factor";
    private Float factor;
    public static final String JSON_PROPERTY_SYMBOL = "symbol";
    private String symbol;
    public static final String JSON_PROPERTY_ISO_CODE = "isoCode";
    private String isoCode;
    public static final String JSON_PROPERTY_SHORT_NAME = "shortName";
    private String shortName;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_POSITION = "position";
    private Long position;
    public static final String JSON_PROPERTY_IS_SYSTEM_DEFAULT = "isSystemDefault";
    private Boolean isSystemDefault;
    public static final String JSON_PROPERTY_TAX_FREE_FROM = "taxFreeFrom";
    private Float taxFreeFrom;
    public static final String JSON_PROPERTY_CUSTOM_FIELDS = "customFields";
    private Object customFields;
    public static final String JSON_PROPERTY_ITEM_ROUNDING = "itemRounding";
    private CurrencyJsonApiAllOfItemRounding itemRounding;
    public static final String JSON_PROPERTY_TOTAL_ROUNDING = "totalRounding";
    private CurrencyJsonApiAllOfItemRounding totalRounding;
    public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_UPDATED_AT = "updatedAt";
    private OffsetDateTime updatedAt;
    public static final String JSON_PROPERTY_TRANSLATED = "translated";
    private Object translated;

    public CurrencyJsonApi() {
    }

    @JsonCreator
    public CurrencyJsonApi(@JsonProperty(value="createdAt") OffsetDateTime createdAt, @JsonProperty(value="updatedAt") OffsetDateTime updatedAt) {
        this();
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    public CurrencyJsonApi type(String type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(String type) {
        this.type = type;
    }

    public CurrencyJsonApi id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(String id) {
        this.id = id;
    }

    public CurrencyJsonApi attributes(Map<String, Object> attributes) {
        this.attributes = attributes;
        return this;
    }

    public CurrencyJsonApi putAttributesItem(String key, Object attributesItem) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(key, attributesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="attributes")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @JsonProperty(value="attributes")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public CurrencyJsonApi relationships(Relationships relationships) {
        this.relationships = JsonNullable.of((Object)relationships);
        return this;
    }

    @Nullable
    @JsonIgnore
    public Relationships getRelationships() {
        return (Relationships)this.relationships.orElse(null);
    }

    @JsonProperty(value="relationships")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Relationships> getRelationships_JsonNullable() {
        return this.relationships;
    }

    @JsonProperty(value="relationships")
    public void setRelationships_JsonNullable(JsonNullable<Relationships> relationships) {
        this.relationships = relationships;
    }

    public void setRelationships(Relationships relationships) {
        this.relationships = JsonNullable.of((Object)relationships);
    }

    public CurrencyJsonApi links(Map<String, Link> links) {
        this.links = links;
        return this;
    }

    public CurrencyJsonApi putLinksItem(String key, Link linksItem) {
        if (this.links == null) {
            this.links = new HashMap<String, Link>();
        }
        this.links.put(key, linksItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Link> getLinks() {
        return this.links;
    }

    @JsonProperty(value="links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(Map<String, Link> links) {
        this.links = links;
    }

    public CurrencyJsonApi meta(Map<String, Object> meta) {
        this.meta = meta;
        return this;
    }

    public CurrencyJsonApi putMetaItem(String key, Object metaItem) {
        if (this.meta == null) {
            this.meta = new HashMap<String, Object>();
        }
        this.meta.put(key, metaItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="meta")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getMeta() {
        return this.meta;
    }

    @JsonProperty(value="meta")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public void setMeta(Map<String, Object> meta) {
        this.meta = meta;
    }

    public CurrencyJsonApi factor(Float factor) {
        this.factor = factor;
        return this;
    }

    @Nonnull
    @JsonProperty(value="factor")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Float getFactor() {
        return this.factor;
    }

    @JsonProperty(value="factor")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFactor(Float factor) {
        this.factor = factor;
    }

    public CurrencyJsonApi symbol(String symbol) {
        this.symbol = symbol;
        return this;
    }

    @Nonnull
    @JsonProperty(value="symbol")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSymbol() {
        return this.symbol;
    }

    @JsonProperty(value="symbol")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public CurrencyJsonApi isoCode(String isoCode) {
        this.isoCode = isoCode;
        return this;
    }

    @Nonnull
    @JsonProperty(value="isoCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getIsoCode() {
        return this.isoCode;
    }

    @JsonProperty(value="isoCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIsoCode(String isoCode) {
        this.isoCode = isoCode;
    }

    public CurrencyJsonApi shortName(String shortName) {
        this.shortName = shortName;
        return this;
    }

    @Nonnull
    @JsonProperty(value="shortName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getShortName() {
        return this.shortName;
    }

    @JsonProperty(value="shortName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public CurrencyJsonApi name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public CurrencyJsonApi position(Long position) {
        this.position = position;
        return this;
    }

    @Nullable
    @JsonProperty(value="position")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getPosition() {
        return this.position;
    }

    @JsonProperty(value="position")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPosition(Long position) {
        this.position = position;
    }

    public CurrencyJsonApi isSystemDefault(Boolean isSystemDefault) {
        this.isSystemDefault = isSystemDefault;
        return this;
    }

    @Nullable
    @JsonProperty(value="isSystemDefault")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsSystemDefault() {
        return this.isSystemDefault;
    }

    @JsonProperty(value="isSystemDefault")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIsSystemDefault(Boolean isSystemDefault) {
        this.isSystemDefault = isSystemDefault;
    }

    public CurrencyJsonApi taxFreeFrom(Float taxFreeFrom) {
        this.taxFreeFrom = taxFreeFrom;
        return this;
    }

    @Nullable
    @JsonProperty(value="taxFreeFrom")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Float getTaxFreeFrom() {
        return this.taxFreeFrom;
    }

    @JsonProperty(value="taxFreeFrom")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTaxFreeFrom(Float taxFreeFrom) {
        this.taxFreeFrom = taxFreeFrom;
    }

    public CurrencyJsonApi customFields(Object customFields) {
        this.customFields = customFields;
        return this;
    }

    @Nullable
    @JsonProperty(value="customFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getCustomFields() {
        return this.customFields;
    }

    @JsonProperty(value="customFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustomFields(Object customFields) {
        this.customFields = customFields;
    }

    public CurrencyJsonApi itemRounding(CurrencyJsonApiAllOfItemRounding itemRounding) {
        this.itemRounding = itemRounding;
        return this;
    }

    @Nonnull
    @JsonProperty(value="itemRounding")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CurrencyJsonApiAllOfItemRounding getItemRounding() {
        return this.itemRounding;
    }

    @JsonProperty(value="itemRounding")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setItemRounding(CurrencyJsonApiAllOfItemRounding itemRounding) {
        this.itemRounding = itemRounding;
    }

    public CurrencyJsonApi totalRounding(CurrencyJsonApiAllOfItemRounding totalRounding) {
        this.totalRounding = totalRounding;
        return this;
    }

    @Nonnull
    @JsonProperty(value="totalRounding")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CurrencyJsonApiAllOfItemRounding getTotalRounding() {
        return this.totalRounding;
    }

    @JsonProperty(value="totalRounding")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTotalRounding(CurrencyJsonApiAllOfItemRounding totalRounding) {
        this.totalRounding = totalRounding;
    }

    @Nonnull
    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Nullable
    @JsonProperty(value="updatedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public CurrencyJsonApi translated(Object translated) {
        this.translated = translated;
        return this;
    }

    @Nullable
    @JsonProperty(value="translated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getTranslated() {
        return this.translated;
    }

    @JsonProperty(value="translated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTranslated(Object translated) {
        this.translated = translated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CurrencyJsonApi currencyJsonApi = (CurrencyJsonApi)o;
        return Objects.equals(this.type, currencyJsonApi.type) && Objects.equals(this.id, currencyJsonApi.id) && Objects.equals(this.attributes, currencyJsonApi.attributes) && CurrencyJsonApi.equalsNullable(this.relationships, currencyJsonApi.relationships) && Objects.equals(this.links, currencyJsonApi.links) && Objects.equals(this.meta, currencyJsonApi.meta) && Objects.equals(this.factor, currencyJsonApi.factor) && Objects.equals(this.symbol, currencyJsonApi.symbol) && Objects.equals(this.isoCode, currencyJsonApi.isoCode) && Objects.equals(this.shortName, currencyJsonApi.shortName) && Objects.equals(this.name, currencyJsonApi.name) && Objects.equals(this.position, currencyJsonApi.position) && Objects.equals(this.isSystemDefault, currencyJsonApi.isSystemDefault) && Objects.equals(this.taxFreeFrom, currencyJsonApi.taxFreeFrom) && Objects.equals(this.customFields, currencyJsonApi.customFields) && Objects.equals(this.itemRounding, currencyJsonApi.itemRounding) && Objects.equals(this.totalRounding, currencyJsonApi.totalRounding) && Objects.equals(this.createdAt, currencyJsonApi.createdAt) && Objects.equals(this.updatedAt, currencyJsonApi.updatedAt) && Objects.equals(this.translated, currencyJsonApi.translated);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.type, this.id, this.attributes, CurrencyJsonApi.hashCodeNullable(this.relationships), this.links, this.meta, this.factor, this.symbol, this.isoCode, this.shortName, this.name, this.position, this.isSystemDefault, this.taxFreeFrom, this.customFields, this.itemRounding, this.totalRounding, this.createdAt, this.updatedAt, this.translated);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CurrencyJsonApi {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    relationships: ").append(this.toIndentedString(this.relationships)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    meta: ").append(this.toIndentedString(this.meta)).append("\n");
        sb.append("    factor: ").append(this.toIndentedString(this.factor)).append("\n");
        sb.append("    symbol: ").append(this.toIndentedString(this.symbol)).append("\n");
        sb.append("    isoCode: ").append(this.toIndentedString(this.isoCode)).append("\n");
        sb.append("    shortName: ").append(this.toIndentedString(this.shortName)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    position: ").append(this.toIndentedString(this.position)).append("\n");
        sb.append("    isSystemDefault: ").append(this.toIndentedString(this.isSystemDefault)).append("\n");
        sb.append("    taxFreeFrom: ").append(this.toIndentedString(this.taxFreeFrom)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    itemRounding: ").append(this.toIndentedString(this.itemRounding)).append("\n");
        sb.append("    totalRounding: ").append(this.toIndentedString(this.totalRounding)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    translated: ").append(this.toIndentedString(this.translated)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

