/*
 * Decompiled with CFR 0.152.
 */
package de.codebarista.shopware.model.core;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import de.codebarista.shopware.model.core.DocumentConfig;
import de.codebarista.shopware.model.core.DocumentConfigDeserializer;
import de.codebarista.shopware.model.core.DocumentType;
import de.codebarista.shopware.model.core.Media;
import de.codebarista.shopware.model.core.Order;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"id", "documentTypeId", "fileType", "referencedDocumentId", "orderId", "documentMediaFileId", "orderVersionId", "config", "sent", "static", "deepLinkCode", "documentNumber", "customFields", "createdAt", "updatedAt", "documentType", "order", "referencedDocument", "dependentDocuments", "documentMediaFile"})
public class Document {
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_DOCUMENT_TYPE_ID = "documentTypeId";
    private String documentTypeId;
    public static final String JSON_PROPERTY_FILE_TYPE = "fileType";
    private String fileType;
    public static final String JSON_PROPERTY_REFERENCED_DOCUMENT_ID = "referencedDocumentId";
    private String referencedDocumentId;
    public static final String JSON_PROPERTY_ORDER_ID = "orderId";
    private String orderId;
    public static final String JSON_PROPERTY_DOCUMENT_MEDIA_FILE_ID = "documentMediaFileId";
    private String documentMediaFileId;
    public static final String JSON_PROPERTY_ORDER_VERSION_ID = "orderVersionId";
    private String orderVersionId;
    public static final String JSON_PROPERTY_CONFIG = "config";
    @JsonDeserialize(using=DocumentConfigDeserializer.class)
    private DocumentConfig config;
    public static final String JSON_PROPERTY_SENT = "sent";
    private Boolean sent;
    public static final String JSON_PROPERTY_STATIC = "static";
    private Boolean _static;
    public static final String JSON_PROPERTY_DEEP_LINK_CODE = "deepLinkCode";
    private String deepLinkCode;
    public static final String JSON_PROPERTY_DOCUMENT_NUMBER = "documentNumber";
    private String documentNumber;
    public static final String JSON_PROPERTY_CUSTOM_FIELDS = "customFields";
    private Object customFields;
    public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_UPDATED_AT = "updatedAt";
    private OffsetDateTime updatedAt;
    public static final String JSON_PROPERTY_DOCUMENT_TYPE = "documentType";
    private DocumentType documentType;
    public static final String JSON_PROPERTY_ORDER = "order";
    private Order order;
    public static final String JSON_PROPERTY_REFERENCED_DOCUMENT = "referencedDocument";
    private Document referencedDocument;
    public static final String JSON_PROPERTY_DEPENDENT_DOCUMENTS = "dependentDocuments";
    private List<Document> dependentDocuments = new ArrayList<Document>();
    public static final String JSON_PROPERTY_DOCUMENT_MEDIA_FILE = "documentMediaFile";
    private Media documentMediaFile;

    public Document() {
    }

    @JsonCreator
    public Document(@JsonProperty(value="createdAt") OffsetDateTime createdAt, @JsonProperty(value="updatedAt") OffsetDateTime updatedAt) {
        this();
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    public Document id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public Document documentTypeId(String documentTypeId) {
        this.documentTypeId = documentTypeId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="documentTypeId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDocumentTypeId() {
        return this.documentTypeId;
    }

    @JsonProperty(value="documentTypeId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDocumentTypeId(String documentTypeId) {
        this.documentTypeId = documentTypeId;
    }

    public Document fileType(String fileType) {
        this.fileType = fileType;
        return this;
    }

    @Nonnull
    @JsonProperty(value="fileType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getFileType() {
        return this.fileType;
    }

    @JsonProperty(value="fileType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public Document referencedDocumentId(String referencedDocumentId) {
        this.referencedDocumentId = referencedDocumentId;
        return this;
    }

    @Nullable
    @JsonProperty(value="referencedDocumentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReferencedDocumentId() {
        return this.referencedDocumentId;
    }

    @JsonProperty(value="referencedDocumentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReferencedDocumentId(String referencedDocumentId) {
        this.referencedDocumentId = referencedDocumentId;
    }

    public Document orderId(String orderId) {
        this.orderId = orderId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="orderId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getOrderId() {
        return this.orderId;
    }

    @JsonProperty(value="orderId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public Document documentMediaFileId(String documentMediaFileId) {
        this.documentMediaFileId = documentMediaFileId;
        return this;
    }

    @Nullable
    @JsonProperty(value="documentMediaFileId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDocumentMediaFileId() {
        return this.documentMediaFileId;
    }

    @JsonProperty(value="documentMediaFileId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDocumentMediaFileId(String documentMediaFileId) {
        this.documentMediaFileId = documentMediaFileId;
    }

    public Document orderVersionId(String orderVersionId) {
        this.orderVersionId = orderVersionId;
        return this;
    }

    @Nullable
    @JsonProperty(value="orderVersionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOrderVersionId() {
        return this.orderVersionId;
    }

    @JsonProperty(value="orderVersionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOrderVersionId(String orderVersionId) {
        this.orderVersionId = orderVersionId;
    }

    public Document config(DocumentConfig config) {
        this.config = config;
        return this;
    }

    @Nonnull
    @JsonProperty(value="config")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public DocumentConfig getConfig() {
        return this.config;
    }

    @JsonProperty(value="config")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setConfig(DocumentConfig config) {
        this.config = config;
    }

    public Document sent(Boolean sent) {
        this.sent = sent;
        return this;
    }

    @Nullable
    @JsonProperty(value="sent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSent() {
        return this.sent;
    }

    @JsonProperty(value="sent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSent(Boolean sent) {
        this.sent = sent;
    }

    public Document _static(Boolean _static) {
        this._static = _static;
        return this;
    }

    @Nullable
    @JsonProperty(value="static")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getStatic() {
        return this._static;
    }

    @JsonProperty(value="static")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatic(Boolean _static) {
        this._static = _static;
    }

    public Document deepLinkCode(String deepLinkCode) {
        this.deepLinkCode = deepLinkCode;
        return this;
    }

    @Nonnull
    @JsonProperty(value="deepLinkCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDeepLinkCode() {
        return this.deepLinkCode;
    }

    @JsonProperty(value="deepLinkCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDeepLinkCode(String deepLinkCode) {
        this.deepLinkCode = deepLinkCode;
    }

    public Document documentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
        return this;
    }

    @Nullable
    @JsonProperty(value="documentNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDocumentNumber() {
        return this.documentNumber;
    }

    @JsonProperty(value="documentNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public Document customFields(Object customFields) {
        this.customFields = customFields;
        return this;
    }

    @Nullable
    @JsonProperty(value="customFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getCustomFields() {
        return this.customFields;
    }

    @JsonProperty(value="customFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustomFields(Object customFields) {
        this.customFields = customFields;
    }

    @Nonnull
    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Nullable
    @JsonProperty(value="updatedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public Document documentType(DocumentType documentType) {
        this.documentType = documentType;
        return this;
    }

    @Nullable
    @JsonProperty(value="documentType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DocumentType getDocumentType() {
        return this.documentType;
    }

    @JsonProperty(value="documentType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDocumentType(DocumentType documentType) {
        this.documentType = documentType;
    }

    public Document order(Order order) {
        this.order = order;
        return this;
    }

    @Nullable
    @JsonProperty(value="order")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Order getOrder() {
        return this.order;
    }

    @JsonProperty(value="order")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOrder(Order order) {
        this.order = order;
    }

    public Document referencedDocument(Document referencedDocument) {
        this.referencedDocument = referencedDocument;
        return this;
    }

    @Nullable
    @JsonProperty(value="referencedDocument")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Document getReferencedDocument() {
        return this.referencedDocument;
    }

    @JsonProperty(value="referencedDocument")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReferencedDocument(Document referencedDocument) {
        this.referencedDocument = referencedDocument;
    }

    public Document dependentDocuments(List<Document> dependentDocuments) {
        this.dependentDocuments = dependentDocuments;
        return this;
    }

    public Document addDependentDocumentsItem(Document dependentDocumentsItem) {
        if (this.dependentDocuments == null) {
            this.dependentDocuments = new ArrayList<Document>();
        }
        this.dependentDocuments.add(dependentDocumentsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="dependentDocuments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Document> getDependentDocuments() {
        return this.dependentDocuments;
    }

    @JsonProperty(value="dependentDocuments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDependentDocuments(List<Document> dependentDocuments) {
        this.dependentDocuments = dependentDocuments;
    }

    public Document documentMediaFile(Media documentMediaFile) {
        this.documentMediaFile = documentMediaFile;
        return this;
    }

    @Nullable
    @JsonProperty(value="documentMediaFile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Media getDocumentMediaFile() {
        return this.documentMediaFile;
    }

    @JsonProperty(value="documentMediaFile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDocumentMediaFile(Media documentMediaFile) {
        this.documentMediaFile = documentMediaFile;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Document document = (Document)o;
        return Objects.equals(this.id, document.id) && Objects.equals(this.documentTypeId, document.documentTypeId) && Objects.equals(this.fileType, document.fileType) && Objects.equals(this.referencedDocumentId, document.referencedDocumentId) && Objects.equals(this.orderId, document.orderId) && Objects.equals(this.documentMediaFileId, document.documentMediaFileId) && Objects.equals(this.orderVersionId, document.orderVersionId) && Objects.equals(this.config, document.config) && Objects.equals(this.sent, document.sent) && Objects.equals(this._static, document._static) && Objects.equals(this.deepLinkCode, document.deepLinkCode) && Objects.equals(this.documentNumber, document.documentNumber) && Objects.equals(this.customFields, document.customFields) && Objects.equals(this.createdAt, document.createdAt) && Objects.equals(this.updatedAt, document.updatedAt) && Objects.equals(this.documentType, document.documentType) && Objects.equals(this.order, document.order) && Objects.equals(this.referencedDocument, document.referencedDocument) && Objects.equals(this.dependentDocuments, document.dependentDocuments) && Objects.equals(this.documentMediaFile, document.documentMediaFile);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.documentTypeId, this.fileType, this.referencedDocumentId, this.orderId, this.documentMediaFileId, this.orderVersionId, this.config, this.sent, this._static, this.deepLinkCode, this.documentNumber, this.customFields, this.createdAt, this.updatedAt, this.documentType, this.order, this.referencedDocument, this.dependentDocuments, this.documentMediaFile);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Document {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    documentTypeId: ").append(this.toIndentedString(this.documentTypeId)).append("\n");
        sb.append("    fileType: ").append(this.toIndentedString(this.fileType)).append("\n");
        sb.append("    referencedDocumentId: ").append(this.toIndentedString(this.referencedDocumentId)).append("\n");
        sb.append("    orderId: ").append(this.toIndentedString(this.orderId)).append("\n");
        sb.append("    documentMediaFileId: ").append(this.toIndentedString(this.documentMediaFileId)).append("\n");
        sb.append("    orderVersionId: ").append(this.toIndentedString(this.orderVersionId)).append("\n");
        sb.append("    config: ").append(this.toIndentedString(this.config)).append("\n");
        sb.append("    sent: ").append(this.toIndentedString(this.sent)).append("\n");
        sb.append("    _static: ").append(this.toIndentedString(this._static)).append("\n");
        sb.append("    deepLinkCode: ").append(this.toIndentedString(this.deepLinkCode)).append("\n");
        sb.append("    documentNumber: ").append(this.toIndentedString(this.documentNumber)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    documentType: ").append(this.toIndentedString(this.documentType)).append("\n");
        sb.append("    order: ").append(this.toIndentedString(this.order)).append("\n");
        sb.append("    referencedDocument: ").append(this.toIndentedString(this.referencedDocument)).append("\n");
        sb.append("    dependentDocuments: ").append(this.toIndentedString(this.dependentDocuments)).append("\n");
        sb.append("    documentMediaFile: ").append(this.toIndentedString(this.documentMediaFile)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

