/*
 * Decompiled with CFR 0.152.
 */
package de.codebarista.shopware.model.core;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonNode;
import de.codebarista.shopware.model.core.OrderShippingCosts;
import de.codebarista.shopware.model.core.OrderTransactionCapture;
import de.codebarista.shopware.model.core.PaymentMethod;
import de.codebarista.shopware.model.core.StateMachineState;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"id", "versionId", "orderId", "orderVersionId", "paymentMethodId", "amount", "stateId", "customFields", "createdAt", "updatedAt", "stateMachineState", "paymentMethod", "captures"})
public class OrderTransaction {
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_VERSION_ID = "versionId";
    private String versionId;
    public static final String JSON_PROPERTY_ORDER_ID = "orderId";
    private String orderId;
    public static final String JSON_PROPERTY_ORDER_VERSION_ID = "orderVersionId";
    private String orderVersionId;
    public static final String JSON_PROPERTY_PAYMENT_METHOD_ID = "paymentMethodId";
    private String paymentMethodId;
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private OrderShippingCosts amount;
    public static final String JSON_PROPERTY_STATE_ID = "stateId";
    private String stateId;
    public static final String JSON_PROPERTY_CUSTOM_FIELDS = "customFields";
    private JsonNode customFields;
    public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_UPDATED_AT = "updatedAt";
    private OffsetDateTime updatedAt;
    public static final String JSON_PROPERTY_STATE_MACHINE_STATE = "stateMachineState";
    private StateMachineState stateMachineState;
    public static final String JSON_PROPERTY_PAYMENT_METHOD = "paymentMethod";
    private PaymentMethod paymentMethod;
    public static final String JSON_PROPERTY_CAPTURES = "captures";
    private List<OrderTransactionCapture> captures = new ArrayList<OrderTransactionCapture>();

    public OrderTransaction() {
    }

    @JsonCreator
    public OrderTransaction(@JsonProperty(value="createdAt") OffsetDateTime createdAt, @JsonProperty(value="updatedAt") OffsetDateTime updatedAt) {
        this();
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    public OrderTransaction id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public OrderTransaction versionId(String versionId) {
        this.versionId = versionId;
        return this;
    }

    @Nullable
    @JsonProperty(value="versionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getVersionId() {
        return this.versionId;
    }

    @JsonProperty(value="versionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    public OrderTransaction orderId(String orderId) {
        this.orderId = orderId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="orderId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getOrderId() {
        return this.orderId;
    }

    @JsonProperty(value="orderId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public OrderTransaction orderVersionId(String orderVersionId) {
        this.orderVersionId = orderVersionId;
        return this;
    }

    @Nullable
    @JsonProperty(value="orderVersionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOrderVersionId() {
        return this.orderVersionId;
    }

    @JsonProperty(value="orderVersionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOrderVersionId(String orderVersionId) {
        this.orderVersionId = orderVersionId;
    }

    public OrderTransaction paymentMethodId(String paymentMethodId) {
        this.paymentMethodId = paymentMethodId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="paymentMethodId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getPaymentMethodId() {
        return this.paymentMethodId;
    }

    @JsonProperty(value="paymentMethodId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPaymentMethodId(String paymentMethodId) {
        this.paymentMethodId = paymentMethodId;
    }

    public OrderTransaction amount(OrderShippingCosts amount) {
        this.amount = amount;
        return this;
    }

    @Nonnull
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OrderShippingCosts getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAmount(OrderShippingCosts amount) {
        this.amount = amount;
    }

    public OrderTransaction stateId(String stateId) {
        this.stateId = stateId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="stateId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getStateId() {
        return this.stateId;
    }

    @JsonProperty(value="stateId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStateId(String stateId) {
        this.stateId = stateId;
    }

    public OrderTransaction customFields(JsonNode customFields) {
        this.customFields = customFields;
        return this;
    }

    @Nullable
    @JsonProperty(value="customFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNode getCustomFields() {
        return this.customFields;
    }

    @JsonProperty(value="customFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustomFields(JsonNode customFields) {
        this.customFields = customFields;
    }

    @Nonnull
    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Nullable
    @JsonProperty(value="updatedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public OrderTransaction stateMachineState(StateMachineState stateMachineState) {
        this.stateMachineState = stateMachineState;
        return this;
    }

    @Nullable
    @JsonProperty(value="stateMachineState")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StateMachineState getStateMachineState() {
        return this.stateMachineState;
    }

    @JsonProperty(value="stateMachineState")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStateMachineState(StateMachineState stateMachineState) {
        this.stateMachineState = stateMachineState;
    }

    public OrderTransaction paymentMethod(PaymentMethod paymentMethod) {
        this.paymentMethod = paymentMethod;
        return this;
    }

    @Nullable
    @JsonProperty(value="paymentMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PaymentMethod getPaymentMethod() {
        return this.paymentMethod;
    }

    @JsonProperty(value="paymentMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentMethod(PaymentMethod paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public OrderTransaction captures(List<OrderTransactionCapture> captures) {
        this.captures = captures;
        return this;
    }

    public OrderTransaction addCapturesItem(OrderTransactionCapture capturesItem) {
        if (this.captures == null) {
            this.captures = new ArrayList<OrderTransactionCapture>();
        }
        this.captures.add(capturesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="captures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<OrderTransactionCapture> getCaptures() {
        return this.captures;
    }

    @JsonProperty(value="captures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCaptures(List<OrderTransactionCapture> captures) {
        this.captures = captures;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderTransaction orderTransaction = (OrderTransaction)o;
        return Objects.equals(this.id, orderTransaction.id) && Objects.equals(this.versionId, orderTransaction.versionId) && Objects.equals(this.orderId, orderTransaction.orderId) && Objects.equals(this.orderVersionId, orderTransaction.orderVersionId) && Objects.equals(this.paymentMethodId, orderTransaction.paymentMethodId) && Objects.equals(this.amount, orderTransaction.amount) && Objects.equals(this.stateId, orderTransaction.stateId) && Objects.equals(this.customFields, orderTransaction.customFields) && Objects.equals(this.createdAt, orderTransaction.createdAt) && Objects.equals(this.updatedAt, orderTransaction.updatedAt) && Objects.equals(this.stateMachineState, orderTransaction.stateMachineState) && Objects.equals(this.paymentMethod, orderTransaction.paymentMethod) && Objects.equals(this.captures, orderTransaction.captures);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.versionId, this.orderId, this.orderVersionId, this.paymentMethodId, this.amount, this.stateId, this.customFields, this.createdAt, this.updatedAt, this.stateMachineState, this.paymentMethod, this.captures);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderTransaction {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    versionId: ").append(this.toIndentedString(this.versionId)).append("\n");
        sb.append("    orderId: ").append(this.toIndentedString(this.orderId)).append("\n");
        sb.append("    orderVersionId: ").append(this.toIndentedString(this.orderVersionId)).append("\n");
        sb.append("    paymentMethodId: ").append(this.toIndentedString(this.paymentMethodId)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    stateId: ").append(this.toIndentedString(this.stateId)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    stateMachineState: ").append(this.toIndentedString(this.stateMachineState)).append("\n");
        sb.append("    paymentMethod: ").append(this.toIndentedString(this.paymentMethod)).append("\n");
        sb.append("    captures: ").append(this.toIndentedString(this.captures)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

