/*
 * Decompiled with CFR 0.152.
 */
package de.codebarista.shopware.model.core;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import de.codebarista.shopware.model.core.Link;
import de.codebarista.shopware.model.core.ProductJsonApiAllOfRelationships;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"type", "id", "attributes", "relationships", "links", "meta", "versionId", "parentId", "parentVersionId", "manufacturerId", "productManufacturerVersionId", "unitId", "taxId", "coverId", "productMediaVersionId", "deliveryTimeId", "canonicalProductId", "cmsPageId", "cmsPageVersionId", "productNumber", "restockTime", "active", "available", "isCloseout", "displayGroup", "manufacturerNumber", "ean", "purchaseSteps", "maxPurchase", "minPurchase", "purchaseUnit", "referenceUnit", "shippingFree", "markAsTopseller", "weight", "width", "height", "length", "releaseDate", "ratingAverage", "categoryTree", "propertyIds", "optionIds", "streamIds", "tagIds", "categoryIds", "childCount", "sales", "states", "metaDescription", "name", "keywords", "description", "metaTitle", "packUnit", "packUnitPlural", "customFields", "availableStock", "stock", "calculatedPrice", "calculatedPrices", "calculatedMaxPurchase", "calculatedCheapestPrice", "isNew", "sortedProperties", "createdAt", "updatedAt", "translated"})
public class ProductJsonApi {
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    private Map<String, Object> attributes = new HashMap<String, Object>();
    public static final String JSON_PROPERTY_RELATIONSHIPS = "relationships";
    private ProductJsonApiAllOfRelationships relationships;
    public static final String JSON_PROPERTY_LINKS = "links";
    private Map<String, Link> links = new HashMap<String, Link>();
    public static final String JSON_PROPERTY_META = "meta";
    private Map<String, Object> meta = new HashMap<String, Object>();
    public static final String JSON_PROPERTY_VERSION_ID = "versionId";
    private String versionId;
    public static final String JSON_PROPERTY_PARENT_ID = "parentId";
    private String parentId;
    public static final String JSON_PROPERTY_PARENT_VERSION_ID = "parentVersionId";
    private String parentVersionId;
    public static final String JSON_PROPERTY_MANUFACTURER_ID = "manufacturerId";
    private String manufacturerId;
    public static final String JSON_PROPERTY_PRODUCT_MANUFACTURER_VERSION_ID = "productManufacturerVersionId";
    private String productManufacturerVersionId;
    public static final String JSON_PROPERTY_UNIT_ID = "unitId";
    private String unitId;
    public static final String JSON_PROPERTY_TAX_ID = "taxId";
    private String taxId;
    public static final String JSON_PROPERTY_COVER_ID = "coverId";
    private String coverId;
    public static final String JSON_PROPERTY_PRODUCT_MEDIA_VERSION_ID = "productMediaVersionId";
    private String productMediaVersionId;
    public static final String JSON_PROPERTY_DELIVERY_TIME_ID = "deliveryTimeId";
    private String deliveryTimeId;
    public static final String JSON_PROPERTY_CANONICAL_PRODUCT_ID = "canonicalProductId";
    private String canonicalProductId;
    public static final String JSON_PROPERTY_CMS_PAGE_ID = "cmsPageId";
    private String cmsPageId;
    public static final String JSON_PROPERTY_CMS_PAGE_VERSION_ID = "cmsPageVersionId";
    private String cmsPageVersionId;
    public static final String JSON_PROPERTY_PRODUCT_NUMBER = "productNumber";
    private String productNumber;
    public static final String JSON_PROPERTY_RESTOCK_TIME = "restockTime";
    private Long restockTime;
    public static final String JSON_PROPERTY_ACTIVE = "active";
    private Boolean active;
    public static final String JSON_PROPERTY_AVAILABLE = "available";
    private Boolean available;
    public static final String JSON_PROPERTY_IS_CLOSEOUT = "isCloseout";
    private Boolean isCloseout;
    public static final String JSON_PROPERTY_DISPLAY_GROUP = "displayGroup";
    private String displayGroup;
    public static final String JSON_PROPERTY_MANUFACTURER_NUMBER = "manufacturerNumber";
    private String manufacturerNumber;
    public static final String JSON_PROPERTY_EAN = "ean";
    private String ean;
    public static final String JSON_PROPERTY_PURCHASE_STEPS = "purchaseSteps";
    private Long purchaseSteps;
    public static final String JSON_PROPERTY_MAX_PURCHASE = "maxPurchase";
    private Long maxPurchase;
    public static final String JSON_PROPERTY_MIN_PURCHASE = "minPurchase";
    private Long minPurchase;
    public static final String JSON_PROPERTY_PURCHASE_UNIT = "purchaseUnit";
    private Float purchaseUnit;
    public static final String JSON_PROPERTY_REFERENCE_UNIT = "referenceUnit";
    private Float referenceUnit;
    public static final String JSON_PROPERTY_SHIPPING_FREE = "shippingFree";
    private Boolean shippingFree;
    public static final String JSON_PROPERTY_MARK_AS_TOPSELLER = "markAsTopseller";
    private Boolean markAsTopseller;
    public static final String JSON_PROPERTY_WEIGHT = "weight";
    private Float weight;
    public static final String JSON_PROPERTY_WIDTH = "width";
    private Float width;
    public static final String JSON_PROPERTY_HEIGHT = "height";
    private Float height;
    public static final String JSON_PROPERTY_LENGTH = "length";
    private Float length;
    public static final String JSON_PROPERTY_RELEASE_DATE = "releaseDate";
    private OffsetDateTime releaseDate;
    public static final String JSON_PROPERTY_RATING_AVERAGE = "ratingAverage";
    private Float ratingAverage;
    public static final String JSON_PROPERTY_CATEGORY_TREE = "categoryTree";
    private List<String> categoryTree = new ArrayList<String>();
    public static final String JSON_PROPERTY_PROPERTY_IDS = "propertyIds";
    private List<String> propertyIds = new ArrayList<String>();
    public static final String JSON_PROPERTY_OPTION_IDS = "optionIds";
    private List<String> optionIds = new ArrayList<String>();
    public static final String JSON_PROPERTY_STREAM_IDS = "streamIds";
    private List<String> streamIds = new ArrayList<String>();
    public static final String JSON_PROPERTY_TAG_IDS = "tagIds";
    private List<String> tagIds = new ArrayList<String>();
    public static final String JSON_PROPERTY_CATEGORY_IDS = "categoryIds";
    private List<String> categoryIds = new ArrayList<String>();
    public static final String JSON_PROPERTY_CHILD_COUNT = "childCount";
    private Long childCount;
    public static final String JSON_PROPERTY_SALES = "sales";
    private Long sales;
    public static final String JSON_PROPERTY_STATES = "states";
    private List<String> states = new ArrayList<String>();
    public static final String JSON_PROPERTY_META_DESCRIPTION = "metaDescription";
    private String metaDescription;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_KEYWORDS = "keywords";
    private String keywords;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_META_TITLE = "metaTitle";
    private String metaTitle;
    public static final String JSON_PROPERTY_PACK_UNIT = "packUnit";
    private String packUnit;
    public static final String JSON_PROPERTY_PACK_UNIT_PLURAL = "packUnitPlural";
    private String packUnitPlural;
    public static final String JSON_PROPERTY_CUSTOM_FIELDS = "customFields";
    private Object customFields;
    public static final String JSON_PROPERTY_AVAILABLE_STOCK = "availableStock";
    private Long availableStock;
    public static final String JSON_PROPERTY_STOCK = "stock";
    private Long stock;
    public static final String JSON_PROPERTY_CALCULATED_PRICE = "calculatedPrice";
    private Object calculatedPrice;
    public static final String JSON_PROPERTY_CALCULATED_PRICES = "calculatedPrices";
    private List<Object> calculatedPrices = new ArrayList<Object>();
    public static final String JSON_PROPERTY_CALCULATED_MAX_PURCHASE = "calculatedMaxPurchase";
    private Long calculatedMaxPurchase;
    public static final String JSON_PROPERTY_CALCULATED_CHEAPEST_PRICE = "calculatedCheapestPrice";
    private Object calculatedCheapestPrice;
    public static final String JSON_PROPERTY_IS_NEW = "isNew";
    private Boolean isNew;
    public static final String JSON_PROPERTY_SORTED_PROPERTIES = "sortedProperties";
    private Object sortedProperties;
    public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_UPDATED_AT = "updatedAt";
    private OffsetDateTime updatedAt;
    public static final String JSON_PROPERTY_TRANSLATED = "translated";
    private Object translated;

    public ProductJsonApi() {
    }

    @JsonCreator
    public ProductJsonApi(@JsonProperty(value="available") Boolean available, @JsonProperty(value="displayGroup") String displayGroup, @JsonProperty(value="ratingAverage") Float ratingAverage, @JsonProperty(value="categoryTree") List<String> categoryTree, @JsonProperty(value="propertyIds") List<String> propertyIds, @JsonProperty(value="optionIds") List<String> optionIds, @JsonProperty(value="streamIds") List<String> streamIds, @JsonProperty(value="tagIds") List<String> tagIds, @JsonProperty(value="categoryIds") List<String> categoryIds, @JsonProperty(value="childCount") Long childCount, @JsonProperty(value="sales") Long sales, @JsonProperty(value="states") List<String> states, @JsonProperty(value="createdAt") OffsetDateTime createdAt, @JsonProperty(value="updatedAt") OffsetDateTime updatedAt) {
        this();
        this.available = available;
        this.displayGroup = displayGroup;
        this.ratingAverage = ratingAverage;
        this.categoryTree = categoryTree;
        this.propertyIds = propertyIds;
        this.optionIds = optionIds;
        this.streamIds = streamIds;
        this.tagIds = tagIds;
        this.categoryIds = categoryIds;
        this.childCount = childCount;
        this.sales = sales;
        this.states = states;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    public ProductJsonApi type(String type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(String type) {
        this.type = type;
    }

    public ProductJsonApi id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(String id) {
        this.id = id;
    }

    public ProductJsonApi attributes(Map<String, Object> attributes) {
        this.attributes = attributes;
        return this;
    }

    public ProductJsonApi putAttributesItem(String key, Object attributesItem) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(key, attributesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="attributes")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @JsonProperty(value="attributes")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public ProductJsonApi relationships(ProductJsonApiAllOfRelationships relationships) {
        this.relationships = relationships;
        return this;
    }

    @Nullable
    @JsonProperty(value="relationships")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ProductJsonApiAllOfRelationships getRelationships() {
        return this.relationships;
    }

    @JsonProperty(value="relationships")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRelationships(ProductJsonApiAllOfRelationships relationships) {
        this.relationships = relationships;
    }

    public ProductJsonApi links(Map<String, Link> links) {
        this.links = links;
        return this;
    }

    public ProductJsonApi putLinksItem(String key, Link linksItem) {
        if (this.links == null) {
            this.links = new HashMap<String, Link>();
        }
        this.links.put(key, linksItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Link> getLinks() {
        return this.links;
    }

    @JsonProperty(value="links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(Map<String, Link> links) {
        this.links = links;
    }

    public ProductJsonApi meta(Map<String, Object> meta) {
        this.meta = meta;
        return this;
    }

    public ProductJsonApi putMetaItem(String key, Object metaItem) {
        if (this.meta == null) {
            this.meta = new HashMap<String, Object>();
        }
        this.meta.put(key, metaItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="meta")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getMeta() {
        return this.meta;
    }

    @JsonProperty(value="meta")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public void setMeta(Map<String, Object> meta) {
        this.meta = meta;
    }

    public ProductJsonApi versionId(String versionId) {
        this.versionId = versionId;
        return this;
    }

    @Nullable
    @JsonProperty(value="versionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getVersionId() {
        return this.versionId;
    }

    @JsonProperty(value="versionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    public ProductJsonApi parentId(String parentId) {
        this.parentId = parentId;
        return this;
    }

    @Nullable
    @JsonProperty(value="parentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getParentId() {
        return this.parentId;
    }

    @JsonProperty(value="parentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public ProductJsonApi parentVersionId(String parentVersionId) {
        this.parentVersionId = parentVersionId;
        return this;
    }

    @Nullable
    @JsonProperty(value="parentVersionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getParentVersionId() {
        return this.parentVersionId;
    }

    @JsonProperty(value="parentVersionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setParentVersionId(String parentVersionId) {
        this.parentVersionId = parentVersionId;
    }

    public ProductJsonApi manufacturerId(String manufacturerId) {
        this.manufacturerId = manufacturerId;
        return this;
    }

    @Nullable
    @JsonProperty(value="manufacturerId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getManufacturerId() {
        return this.manufacturerId;
    }

    @JsonProperty(value="manufacturerId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setManufacturerId(String manufacturerId) {
        this.manufacturerId = manufacturerId;
    }

    public ProductJsonApi productManufacturerVersionId(String productManufacturerVersionId) {
        this.productManufacturerVersionId = productManufacturerVersionId;
        return this;
    }

    @Nullable
    @JsonProperty(value="productManufacturerVersionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getProductManufacturerVersionId() {
        return this.productManufacturerVersionId;
    }

    @JsonProperty(value="productManufacturerVersionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProductManufacturerVersionId(String productManufacturerVersionId) {
        this.productManufacturerVersionId = productManufacturerVersionId;
    }

    public ProductJsonApi unitId(String unitId) {
        this.unitId = unitId;
        return this;
    }

    @Nullable
    @JsonProperty(value="unitId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUnitId() {
        return this.unitId;
    }

    @JsonProperty(value="unitId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUnitId(String unitId) {
        this.unitId = unitId;
    }

    public ProductJsonApi taxId(String taxId) {
        this.taxId = taxId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="taxId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTaxId() {
        return this.taxId;
    }

    @JsonProperty(value="taxId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTaxId(String taxId) {
        this.taxId = taxId;
    }

    public ProductJsonApi coverId(String coverId) {
        this.coverId = coverId;
        return this;
    }

    @Nullable
    @JsonProperty(value="coverId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCoverId() {
        return this.coverId;
    }

    @JsonProperty(value="coverId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCoverId(String coverId) {
        this.coverId = coverId;
    }

    public ProductJsonApi productMediaVersionId(String productMediaVersionId) {
        this.productMediaVersionId = productMediaVersionId;
        return this;
    }

    @Nullable
    @JsonProperty(value="productMediaVersionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getProductMediaVersionId() {
        return this.productMediaVersionId;
    }

    @JsonProperty(value="productMediaVersionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProductMediaVersionId(String productMediaVersionId) {
        this.productMediaVersionId = productMediaVersionId;
    }

    public ProductJsonApi deliveryTimeId(String deliveryTimeId) {
        this.deliveryTimeId = deliveryTimeId;
        return this;
    }

    @Nullable
    @JsonProperty(value="deliveryTimeId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDeliveryTimeId() {
        return this.deliveryTimeId;
    }

    @JsonProperty(value="deliveryTimeId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeliveryTimeId(String deliveryTimeId) {
        this.deliveryTimeId = deliveryTimeId;
    }

    public ProductJsonApi canonicalProductId(String canonicalProductId) {
        this.canonicalProductId = canonicalProductId;
        return this;
    }

    @Nullable
    @JsonProperty(value="canonicalProductId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCanonicalProductId() {
        return this.canonicalProductId;
    }

    @JsonProperty(value="canonicalProductId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCanonicalProductId(String canonicalProductId) {
        this.canonicalProductId = canonicalProductId;
    }

    public ProductJsonApi cmsPageId(String cmsPageId) {
        this.cmsPageId = cmsPageId;
        return this;
    }

    @Nullable
    @JsonProperty(value="cmsPageId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCmsPageId() {
        return this.cmsPageId;
    }

    @JsonProperty(value="cmsPageId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCmsPageId(String cmsPageId) {
        this.cmsPageId = cmsPageId;
    }

    public ProductJsonApi cmsPageVersionId(String cmsPageVersionId) {
        this.cmsPageVersionId = cmsPageVersionId;
        return this;
    }

    @Nullable
    @JsonProperty(value="cmsPageVersionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCmsPageVersionId() {
        return this.cmsPageVersionId;
    }

    @JsonProperty(value="cmsPageVersionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCmsPageVersionId(String cmsPageVersionId) {
        this.cmsPageVersionId = cmsPageVersionId;
    }

    public ProductJsonApi productNumber(String productNumber) {
        this.productNumber = productNumber;
        return this;
    }

    @Nonnull
    @JsonProperty(value="productNumber")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getProductNumber() {
        return this.productNumber;
    }

    @JsonProperty(value="productNumber")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setProductNumber(String productNumber) {
        this.productNumber = productNumber;
    }

    public ProductJsonApi restockTime(Long restockTime) {
        this.restockTime = restockTime;
        return this;
    }

    @Nullable
    @JsonProperty(value="restockTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getRestockTime() {
        return this.restockTime;
    }

    @JsonProperty(value="restockTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRestockTime(Long restockTime) {
        this.restockTime = restockTime;
    }

    public ProductJsonApi active(Boolean active) {
        this.active = active;
        return this;
    }

    @Nullable
    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getActive() {
        return this.active;
    }

    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setActive(Boolean active) {
        this.active = active;
    }

    @Nullable
    @JsonProperty(value="available")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAvailable() {
        return this.available;
    }

    public ProductJsonApi isCloseout(Boolean isCloseout) {
        this.isCloseout = isCloseout;
        return this;
    }

    @Nullable
    @JsonProperty(value="isCloseout")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsCloseout() {
        return this.isCloseout;
    }

    @JsonProperty(value="isCloseout")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIsCloseout(Boolean isCloseout) {
        this.isCloseout = isCloseout;
    }

    @Nullable
    @JsonProperty(value="displayGroup")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDisplayGroup() {
        return this.displayGroup;
    }

    public ProductJsonApi manufacturerNumber(String manufacturerNumber) {
        this.manufacturerNumber = manufacturerNumber;
        return this;
    }

    @Nullable
    @JsonProperty(value="manufacturerNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getManufacturerNumber() {
        return this.manufacturerNumber;
    }

    @JsonProperty(value="manufacturerNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setManufacturerNumber(String manufacturerNumber) {
        this.manufacturerNumber = manufacturerNumber;
    }

    public ProductJsonApi ean(String ean) {
        this.ean = ean;
        return this;
    }

    @Nullable
    @JsonProperty(value="ean")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEan() {
        return this.ean;
    }

    @JsonProperty(value="ean")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEan(String ean) {
        this.ean = ean;
    }

    public ProductJsonApi purchaseSteps(Long purchaseSteps) {
        this.purchaseSteps = purchaseSteps;
        return this;
    }

    @Nullable
    @JsonProperty(value="purchaseSteps")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getPurchaseSteps() {
        return this.purchaseSteps;
    }

    @JsonProperty(value="purchaseSteps")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPurchaseSteps(Long purchaseSteps) {
        this.purchaseSteps = purchaseSteps;
    }

    public ProductJsonApi maxPurchase(Long maxPurchase) {
        this.maxPurchase = maxPurchase;
        return this;
    }

    @Nullable
    @JsonProperty(value="maxPurchase")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getMaxPurchase() {
        return this.maxPurchase;
    }

    @JsonProperty(value="maxPurchase")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMaxPurchase(Long maxPurchase) {
        this.maxPurchase = maxPurchase;
    }

    public ProductJsonApi minPurchase(Long minPurchase) {
        this.minPurchase = minPurchase;
        return this;
    }

    @Nullable
    @JsonProperty(value="minPurchase")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getMinPurchase() {
        return this.minPurchase;
    }

    @JsonProperty(value="minPurchase")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMinPurchase(Long minPurchase) {
        this.minPurchase = minPurchase;
    }

    public ProductJsonApi purchaseUnit(Float purchaseUnit) {
        this.purchaseUnit = purchaseUnit;
        return this;
    }

    @Nullable
    @JsonProperty(value="purchaseUnit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Float getPurchaseUnit() {
        return this.purchaseUnit;
    }

    @JsonProperty(value="purchaseUnit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPurchaseUnit(Float purchaseUnit) {
        this.purchaseUnit = purchaseUnit;
    }

    public ProductJsonApi referenceUnit(Float referenceUnit) {
        this.referenceUnit = referenceUnit;
        return this;
    }

    @Nullable
    @JsonProperty(value="referenceUnit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Float getReferenceUnit() {
        return this.referenceUnit;
    }

    @JsonProperty(value="referenceUnit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReferenceUnit(Float referenceUnit) {
        this.referenceUnit = referenceUnit;
    }

    public ProductJsonApi shippingFree(Boolean shippingFree) {
        this.shippingFree = shippingFree;
        return this;
    }

    @Nullable
    @JsonProperty(value="shippingFree")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getShippingFree() {
        return this.shippingFree;
    }

    @JsonProperty(value="shippingFree")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShippingFree(Boolean shippingFree) {
        this.shippingFree = shippingFree;
    }

    public ProductJsonApi markAsTopseller(Boolean markAsTopseller) {
        this.markAsTopseller = markAsTopseller;
        return this;
    }

    @Nullable
    @JsonProperty(value="markAsTopseller")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getMarkAsTopseller() {
        return this.markAsTopseller;
    }

    @JsonProperty(value="markAsTopseller")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMarkAsTopseller(Boolean markAsTopseller) {
        this.markAsTopseller = markAsTopseller;
    }

    public ProductJsonApi weight(Float weight) {
        this.weight = weight;
        return this;
    }

    @Nullable
    @JsonProperty(value="weight")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Float getWeight() {
        return this.weight;
    }

    @JsonProperty(value="weight")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWeight(Float weight) {
        this.weight = weight;
    }

    public ProductJsonApi width(Float width) {
        this.width = width;
        return this;
    }

    @Nullable
    @JsonProperty(value="width")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Float getWidth() {
        return this.width;
    }

    @JsonProperty(value="width")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWidth(Float width) {
        this.width = width;
    }

    public ProductJsonApi height(Float height) {
        this.height = height;
        return this;
    }

    @Nullable
    @JsonProperty(value="height")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Float getHeight() {
        return this.height;
    }

    @JsonProperty(value="height")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHeight(Float height) {
        this.height = height;
    }

    public ProductJsonApi length(Float length) {
        this.length = length;
        return this;
    }

    @Nullable
    @JsonProperty(value="length")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Float getLength() {
        return this.length;
    }

    @JsonProperty(value="length")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLength(Float length) {
        this.length = length;
    }

    public ProductJsonApi releaseDate(OffsetDateTime releaseDate) {
        this.releaseDate = releaseDate;
        return this;
    }

    @Nullable
    @JsonProperty(value="releaseDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getReleaseDate() {
        return this.releaseDate;
    }

    @JsonProperty(value="releaseDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReleaseDate(OffsetDateTime releaseDate) {
        this.releaseDate = releaseDate;
    }

    @Nullable
    @JsonProperty(value="ratingAverage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Float getRatingAverage() {
        return this.ratingAverage;
    }

    @Nullable
    @JsonProperty(value="categoryTree")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getCategoryTree() {
        return this.categoryTree;
    }

    @Nullable
    @JsonProperty(value="propertyIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getPropertyIds() {
        return this.propertyIds;
    }

    @Nullable
    @JsonProperty(value="optionIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getOptionIds() {
        return this.optionIds;
    }

    @Nullable
    @JsonProperty(value="streamIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getStreamIds() {
        return this.streamIds;
    }

    @Nullable
    @JsonProperty(value="tagIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTagIds() {
        return this.tagIds;
    }

    @Nullable
    @JsonProperty(value="categoryIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getCategoryIds() {
        return this.categoryIds;
    }

    @Nullable
    @JsonProperty(value="childCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getChildCount() {
        return this.childCount;
    }

    @Nullable
    @JsonProperty(value="sales")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getSales() {
        return this.sales;
    }

    @Nullable
    @JsonProperty(value="states")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getStates() {
        return this.states;
    }

    public ProductJsonApi metaDescription(String metaDescription) {
        this.metaDescription = metaDescription;
        return this;
    }

    @Nullable
    @JsonProperty(value="metaDescription")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMetaDescription() {
        return this.metaDescription;
    }

    @JsonProperty(value="metaDescription")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetaDescription(String metaDescription) {
        this.metaDescription = metaDescription;
    }

    public ProductJsonApi name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public ProductJsonApi keywords(String keywords) {
        this.keywords = keywords;
        return this;
    }

    @Nullable
    @JsonProperty(value="keywords")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getKeywords() {
        return this.keywords;
    }

    @JsonProperty(value="keywords")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public ProductJsonApi description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public ProductJsonApi metaTitle(String metaTitle) {
        this.metaTitle = metaTitle;
        return this;
    }

    @Nullable
    @JsonProperty(value="metaTitle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMetaTitle() {
        return this.metaTitle;
    }

    @JsonProperty(value="metaTitle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetaTitle(String metaTitle) {
        this.metaTitle = metaTitle;
    }

    public ProductJsonApi packUnit(String packUnit) {
        this.packUnit = packUnit;
        return this;
    }

    @Nullable
    @JsonProperty(value="packUnit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPackUnit() {
        return this.packUnit;
    }

    @JsonProperty(value="packUnit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPackUnit(String packUnit) {
        this.packUnit = packUnit;
    }

    public ProductJsonApi packUnitPlural(String packUnitPlural) {
        this.packUnitPlural = packUnitPlural;
        return this;
    }

    @Nullable
    @JsonProperty(value="packUnitPlural")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPackUnitPlural() {
        return this.packUnitPlural;
    }

    @JsonProperty(value="packUnitPlural")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPackUnitPlural(String packUnitPlural) {
        this.packUnitPlural = packUnitPlural;
    }

    public ProductJsonApi customFields(Object customFields) {
        this.customFields = customFields;
        return this;
    }

    @Nullable
    @JsonProperty(value="customFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getCustomFields() {
        return this.customFields;
    }

    @JsonProperty(value="customFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustomFields(Object customFields) {
        this.customFields = customFields;
    }

    public ProductJsonApi availableStock(Long availableStock) {
        this.availableStock = availableStock;
        return this;
    }

    @Nullable
    @JsonProperty(value="availableStock")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getAvailableStock() {
        return this.availableStock;
    }

    @JsonProperty(value="availableStock")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAvailableStock(Long availableStock) {
        this.availableStock = availableStock;
    }

    public ProductJsonApi stock(Long stock) {
        this.stock = stock;
        return this;
    }

    @Nonnull
    @JsonProperty(value="stock")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getStock() {
        return this.stock;
    }

    @JsonProperty(value="stock")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStock(Long stock) {
        this.stock = stock;
    }

    public ProductJsonApi calculatedPrice(Object calculatedPrice) {
        this.calculatedPrice = calculatedPrice;
        return this;
    }

    @Nullable
    @JsonProperty(value="calculatedPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getCalculatedPrice() {
        return this.calculatedPrice;
    }

    @JsonProperty(value="calculatedPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCalculatedPrice(Object calculatedPrice) {
        this.calculatedPrice = calculatedPrice;
    }

    public ProductJsonApi calculatedPrices(List<Object> calculatedPrices) {
        this.calculatedPrices = calculatedPrices;
        return this;
    }

    public ProductJsonApi addCalculatedPricesItem(Object calculatedPricesItem) {
        if (this.calculatedPrices == null) {
            this.calculatedPrices = new ArrayList<Object>();
        }
        this.calculatedPrices.add(calculatedPricesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="calculatedPrices")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Object> getCalculatedPrices() {
        return this.calculatedPrices;
    }

    @JsonProperty(value="calculatedPrices")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCalculatedPrices(List<Object> calculatedPrices) {
        this.calculatedPrices = calculatedPrices;
    }

    public ProductJsonApi calculatedMaxPurchase(Long calculatedMaxPurchase) {
        this.calculatedMaxPurchase = calculatedMaxPurchase;
        return this;
    }

    @Nullable
    @JsonProperty(value="calculatedMaxPurchase")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getCalculatedMaxPurchase() {
        return this.calculatedMaxPurchase;
    }

    @JsonProperty(value="calculatedMaxPurchase")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCalculatedMaxPurchase(Long calculatedMaxPurchase) {
        this.calculatedMaxPurchase = calculatedMaxPurchase;
    }

    public ProductJsonApi calculatedCheapestPrice(Object calculatedCheapestPrice) {
        this.calculatedCheapestPrice = calculatedCheapestPrice;
        return this;
    }

    @Nullable
    @JsonProperty(value="calculatedCheapestPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getCalculatedCheapestPrice() {
        return this.calculatedCheapestPrice;
    }

    @JsonProperty(value="calculatedCheapestPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCalculatedCheapestPrice(Object calculatedCheapestPrice) {
        this.calculatedCheapestPrice = calculatedCheapestPrice;
    }

    public ProductJsonApi isNew(Boolean isNew) {
        this.isNew = isNew;
        return this;
    }

    @Nullable
    @JsonProperty(value="isNew")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsNew() {
        return this.isNew;
    }

    @JsonProperty(value="isNew")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIsNew(Boolean isNew) {
        this.isNew = isNew;
    }

    public ProductJsonApi sortedProperties(Object sortedProperties) {
        this.sortedProperties = sortedProperties;
        return this;
    }

    @Nullable
    @JsonProperty(value="sortedProperties")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getSortedProperties() {
        return this.sortedProperties;
    }

    @JsonProperty(value="sortedProperties")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSortedProperties(Object sortedProperties) {
        this.sortedProperties = sortedProperties;
    }

    @Nonnull
    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Nullable
    @JsonProperty(value="updatedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public ProductJsonApi translated(Object translated) {
        this.translated = translated;
        return this;
    }

    @Nullable
    @JsonProperty(value="translated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getTranslated() {
        return this.translated;
    }

    @JsonProperty(value="translated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTranslated(Object translated) {
        this.translated = translated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductJsonApi productJsonApi = (ProductJsonApi)o;
        return Objects.equals(this.type, productJsonApi.type) && Objects.equals(this.id, productJsonApi.id) && Objects.equals(this.attributes, productJsonApi.attributes) && Objects.equals(this.relationships, productJsonApi.relationships) && Objects.equals(this.links, productJsonApi.links) && Objects.equals(this.meta, productJsonApi.meta) && Objects.equals(this.versionId, productJsonApi.versionId) && Objects.equals(this.parentId, productJsonApi.parentId) && Objects.equals(this.parentVersionId, productJsonApi.parentVersionId) && Objects.equals(this.manufacturerId, productJsonApi.manufacturerId) && Objects.equals(this.productManufacturerVersionId, productJsonApi.productManufacturerVersionId) && Objects.equals(this.unitId, productJsonApi.unitId) && Objects.equals(this.taxId, productJsonApi.taxId) && Objects.equals(this.coverId, productJsonApi.coverId) && Objects.equals(this.productMediaVersionId, productJsonApi.productMediaVersionId) && Objects.equals(this.deliveryTimeId, productJsonApi.deliveryTimeId) && Objects.equals(this.canonicalProductId, productJsonApi.canonicalProductId) && Objects.equals(this.cmsPageId, productJsonApi.cmsPageId) && Objects.equals(this.cmsPageVersionId, productJsonApi.cmsPageVersionId) && Objects.equals(this.productNumber, productJsonApi.productNumber) && Objects.equals(this.restockTime, productJsonApi.restockTime) && Objects.equals(this.active, productJsonApi.active) && Objects.equals(this.available, productJsonApi.available) && Objects.equals(this.isCloseout, productJsonApi.isCloseout) && Objects.equals(this.displayGroup, productJsonApi.displayGroup) && Objects.equals(this.manufacturerNumber, productJsonApi.manufacturerNumber) && Objects.equals(this.ean, productJsonApi.ean) && Objects.equals(this.purchaseSteps, productJsonApi.purchaseSteps) && Objects.equals(this.maxPurchase, productJsonApi.maxPurchase) && Objects.equals(this.minPurchase, productJsonApi.minPurchase) && Objects.equals(this.purchaseUnit, productJsonApi.purchaseUnit) && Objects.equals(this.referenceUnit, productJsonApi.referenceUnit) && Objects.equals(this.shippingFree, productJsonApi.shippingFree) && Objects.equals(this.markAsTopseller, productJsonApi.markAsTopseller) && Objects.equals(this.weight, productJsonApi.weight) && Objects.equals(this.width, productJsonApi.width) && Objects.equals(this.height, productJsonApi.height) && Objects.equals(this.length, productJsonApi.length) && Objects.equals(this.releaseDate, productJsonApi.releaseDate) && Objects.equals(this.ratingAverage, productJsonApi.ratingAverage) && Objects.equals(this.categoryTree, productJsonApi.categoryTree) && Objects.equals(this.propertyIds, productJsonApi.propertyIds) && Objects.equals(this.optionIds, productJsonApi.optionIds) && Objects.equals(this.streamIds, productJsonApi.streamIds) && Objects.equals(this.tagIds, productJsonApi.tagIds) && Objects.equals(this.categoryIds, productJsonApi.categoryIds) && Objects.equals(this.childCount, productJsonApi.childCount) && Objects.equals(this.sales, productJsonApi.sales) && Objects.equals(this.states, productJsonApi.states) && Objects.equals(this.metaDescription, productJsonApi.metaDescription) && Objects.equals(this.name, productJsonApi.name) && Objects.equals(this.keywords, productJsonApi.keywords) && Objects.equals(this.description, productJsonApi.description) && Objects.equals(this.metaTitle, productJsonApi.metaTitle) && Objects.equals(this.packUnit, productJsonApi.packUnit) && Objects.equals(this.packUnitPlural, productJsonApi.packUnitPlural) && Objects.equals(this.customFields, productJsonApi.customFields) && Objects.equals(this.availableStock, productJsonApi.availableStock) && Objects.equals(this.stock, productJsonApi.stock) && Objects.equals(this.calculatedPrice, productJsonApi.calculatedPrice) && Objects.equals(this.calculatedPrices, productJsonApi.calculatedPrices) && Objects.equals(this.calculatedMaxPurchase, productJsonApi.calculatedMaxPurchase) && Objects.equals(this.calculatedCheapestPrice, productJsonApi.calculatedCheapestPrice) && Objects.equals(this.isNew, productJsonApi.isNew) && Objects.equals(this.sortedProperties, productJsonApi.sortedProperties) && Objects.equals(this.createdAt, productJsonApi.createdAt) && Objects.equals(this.updatedAt, productJsonApi.updatedAt) && Objects.equals(this.translated, productJsonApi.translated);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.id, this.attributes, this.relationships, this.links, this.meta, this.versionId, this.parentId, this.parentVersionId, this.manufacturerId, this.productManufacturerVersionId, this.unitId, this.taxId, this.coverId, this.productMediaVersionId, this.deliveryTimeId, this.canonicalProductId, this.cmsPageId, this.cmsPageVersionId, this.productNumber, this.restockTime, this.active, this.available, this.isCloseout, this.displayGroup, this.manufacturerNumber, this.ean, this.purchaseSteps, this.maxPurchase, this.minPurchase, this.purchaseUnit, this.referenceUnit, this.shippingFree, this.markAsTopseller, this.weight, this.width, this.height, this.length, this.releaseDate, this.ratingAverage, this.categoryTree, this.propertyIds, this.optionIds, this.streamIds, this.tagIds, this.categoryIds, this.childCount, this.sales, this.states, this.metaDescription, this.name, this.keywords, this.description, this.metaTitle, this.packUnit, this.packUnitPlural, this.customFields, this.availableStock, this.stock, this.calculatedPrice, this.calculatedPrices, this.calculatedMaxPurchase, this.calculatedCheapestPrice, this.isNew, this.sortedProperties, this.createdAt, this.updatedAt, this.translated);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProductJsonApi {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    relationships: ").append(this.toIndentedString(this.relationships)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    meta: ").append(this.toIndentedString(this.meta)).append("\n");
        sb.append("    versionId: ").append(this.toIndentedString(this.versionId)).append("\n");
        sb.append("    parentId: ").append(this.toIndentedString(this.parentId)).append("\n");
        sb.append("    parentVersionId: ").append(this.toIndentedString(this.parentVersionId)).append("\n");
        sb.append("    manufacturerId: ").append(this.toIndentedString(this.manufacturerId)).append("\n");
        sb.append("    productManufacturerVersionId: ").append(this.toIndentedString(this.productManufacturerVersionId)).append("\n");
        sb.append("    unitId: ").append(this.toIndentedString(this.unitId)).append("\n");
        sb.append("    taxId: ").append(this.toIndentedString(this.taxId)).append("\n");
        sb.append("    coverId: ").append(this.toIndentedString(this.coverId)).append("\n");
        sb.append("    productMediaVersionId: ").append(this.toIndentedString(this.productMediaVersionId)).append("\n");
        sb.append("    deliveryTimeId: ").append(this.toIndentedString(this.deliveryTimeId)).append("\n");
        sb.append("    canonicalProductId: ").append(this.toIndentedString(this.canonicalProductId)).append("\n");
        sb.append("    cmsPageId: ").append(this.toIndentedString(this.cmsPageId)).append("\n");
        sb.append("    cmsPageVersionId: ").append(this.toIndentedString(this.cmsPageVersionId)).append("\n");
        sb.append("    productNumber: ").append(this.toIndentedString(this.productNumber)).append("\n");
        sb.append("    restockTime: ").append(this.toIndentedString(this.restockTime)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    available: ").append(this.toIndentedString(this.available)).append("\n");
        sb.append("    isCloseout: ").append(this.toIndentedString(this.isCloseout)).append("\n");
        sb.append("    displayGroup: ").append(this.toIndentedString(this.displayGroup)).append("\n");
        sb.append("    manufacturerNumber: ").append(this.toIndentedString(this.manufacturerNumber)).append("\n");
        sb.append("    ean: ").append(this.toIndentedString(this.ean)).append("\n");
        sb.append("    purchaseSteps: ").append(this.toIndentedString(this.purchaseSteps)).append("\n");
        sb.append("    maxPurchase: ").append(this.toIndentedString(this.maxPurchase)).append("\n");
        sb.append("    minPurchase: ").append(this.toIndentedString(this.minPurchase)).append("\n");
        sb.append("    purchaseUnit: ").append(this.toIndentedString(this.purchaseUnit)).append("\n");
        sb.append("    referenceUnit: ").append(this.toIndentedString(this.referenceUnit)).append("\n");
        sb.append("    shippingFree: ").append(this.toIndentedString(this.shippingFree)).append("\n");
        sb.append("    markAsTopseller: ").append(this.toIndentedString(this.markAsTopseller)).append("\n");
        sb.append("    weight: ").append(this.toIndentedString(this.weight)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    length: ").append(this.toIndentedString(this.length)).append("\n");
        sb.append("    releaseDate: ").append(this.toIndentedString(this.releaseDate)).append("\n");
        sb.append("    ratingAverage: ").append(this.toIndentedString(this.ratingAverage)).append("\n");
        sb.append("    categoryTree: ").append(this.toIndentedString(this.categoryTree)).append("\n");
        sb.append("    propertyIds: ").append(this.toIndentedString(this.propertyIds)).append("\n");
        sb.append("    optionIds: ").append(this.toIndentedString(this.optionIds)).append("\n");
        sb.append("    streamIds: ").append(this.toIndentedString(this.streamIds)).append("\n");
        sb.append("    tagIds: ").append(this.toIndentedString(this.tagIds)).append("\n");
        sb.append("    categoryIds: ").append(this.toIndentedString(this.categoryIds)).append("\n");
        sb.append("    childCount: ").append(this.toIndentedString(this.childCount)).append("\n");
        sb.append("    sales: ").append(this.toIndentedString(this.sales)).append("\n");
        sb.append("    states: ").append(this.toIndentedString(this.states)).append("\n");
        sb.append("    metaDescription: ").append(this.toIndentedString(this.metaDescription)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    keywords: ").append(this.toIndentedString(this.keywords)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    metaTitle: ").append(this.toIndentedString(this.metaTitle)).append("\n");
        sb.append("    packUnit: ").append(this.toIndentedString(this.packUnit)).append("\n");
        sb.append("    packUnitPlural: ").append(this.toIndentedString(this.packUnitPlural)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    availableStock: ").append(this.toIndentedString(this.availableStock)).append("\n");
        sb.append("    stock: ").append(this.toIndentedString(this.stock)).append("\n");
        sb.append("    calculatedPrice: ").append(this.toIndentedString(this.calculatedPrice)).append("\n");
        sb.append("    calculatedPrices: ").append(this.toIndentedString(this.calculatedPrices)).append("\n");
        sb.append("    calculatedMaxPurchase: ").append(this.toIndentedString(this.calculatedMaxPurchase)).append("\n");
        sb.append("    calculatedCheapestPrice: ").append(this.toIndentedString(this.calculatedCheapestPrice)).append("\n");
        sb.append("    isNew: ").append(this.toIndentedString(this.isNew)).append("\n");
        sb.append("    sortedProperties: ").append(this.toIndentedString(this.sortedProperties)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    translated: ").append(this.toIndentedString(this.translated)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

