/*
 * Decompiled with CFR 0.152.
 */
package de.codebarista.shopware.model.core;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import de.codebarista.shopware.model.core.Link;
import de.codebarista.shopware.model.core.Relationships;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"type", "id", "attributes", "relationships", "links", "meta"})
@JsonTypeName(value="resource")
public class Resource {
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    private Map<String, Object> attributes = new HashMap<String, Object>();
    public static final String JSON_PROPERTY_RELATIONSHIPS = "relationships";
    private JsonNullable<Relationships> relationships = JsonNullable.undefined();
    public static final String JSON_PROPERTY_LINKS = "links";
    private Map<String, Link> links = new HashMap<String, Link>();
    public static final String JSON_PROPERTY_META = "meta";
    private Map<String, Object> meta = new HashMap<String, Object>();

    public Resource type(String type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(String type) {
        this.type = type;
    }

    public Resource id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(String id) {
        this.id = id;
    }

    public Resource attributes(Map<String, Object> attributes) {
        this.attributes = attributes;
        return this;
    }

    public Resource putAttributesItem(String key, Object attributesItem) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(key, attributesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="attributes")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @JsonProperty(value="attributes")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public Resource relationships(Relationships relationships) {
        this.relationships = JsonNullable.of((Object)relationships);
        return this;
    }

    @Nullable
    @JsonIgnore
    public Relationships getRelationships() {
        return (Relationships)this.relationships.orElse(null);
    }

    @JsonProperty(value="relationships")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Relationships> getRelationships_JsonNullable() {
        return this.relationships;
    }

    @JsonProperty(value="relationships")
    public void setRelationships_JsonNullable(JsonNullable<Relationships> relationships) {
        this.relationships = relationships;
    }

    public void setRelationships(Relationships relationships) {
        this.relationships = JsonNullable.of((Object)relationships);
    }

    public Resource links(Map<String, Link> links) {
        this.links = links;
        return this;
    }

    public Resource putLinksItem(String key, Link linksItem) {
        if (this.links == null) {
            this.links = new HashMap<String, Link>();
        }
        this.links.put(key, linksItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Link> getLinks() {
        return this.links;
    }

    @JsonProperty(value="links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(Map<String, Link> links) {
        this.links = links;
    }

    public Resource meta(Map<String, Object> meta) {
        this.meta = meta;
        return this;
    }

    public Resource putMetaItem(String key, Object metaItem) {
        if (this.meta == null) {
            this.meta = new HashMap<String, Object>();
        }
        this.meta.put(key, metaItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="meta")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getMeta() {
        return this.meta;
    }

    @JsonProperty(value="meta")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public void setMeta(Map<String, Object> meta) {
        this.meta = meta;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Resource resource = (Resource)o;
        return Objects.equals(this.type, resource.type) && Objects.equals(this.id, resource.id) && Objects.equals(this.attributes, resource.attributes) && Resource.equalsNullable(this.relationships, resource.relationships) && Objects.equals(this.links, resource.links) && Objects.equals(this.meta, resource.meta);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.type, this.id, this.attributes, Resource.hashCodeNullable(this.relationships), this.links, this.meta);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Resource {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    relationships: ").append(this.toIndentedString(this.relationships)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    meta: ").append(this.toIndentedString(this.meta)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

