/*
 * Decompiled with CFR 0.152.
 */
package de.codebarista.shopware.model.core;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import de.codebarista.shopware.model.core.Link;
import de.codebarista.shopware.model.core.Relationships;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"type", "id", "attributes", "relationships", "links", "meta", "salutationKey", "displayName", "letterName", "customFields", "createdAt", "updatedAt", "translated"})
public class SalutationJsonApi {
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    private Map<String, Object> attributes = new HashMap<String, Object>();
    public static final String JSON_PROPERTY_RELATIONSHIPS = "relationships";
    private JsonNullable<Relationships> relationships = JsonNullable.undefined();
    public static final String JSON_PROPERTY_LINKS = "links";
    private Map<String, Link> links = new HashMap<String, Link>();
    public static final String JSON_PROPERTY_META = "meta";
    private Map<String, Object> meta = new HashMap<String, Object>();
    public static final String JSON_PROPERTY_SALUTATION_KEY = "salutationKey";
    private String salutationKey;
    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    private String displayName;
    public static final String JSON_PROPERTY_LETTER_NAME = "letterName";
    private String letterName;
    public static final String JSON_PROPERTY_CUSTOM_FIELDS = "customFields";
    private Object customFields;
    public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_UPDATED_AT = "updatedAt";
    private OffsetDateTime updatedAt;
    public static final String JSON_PROPERTY_TRANSLATED = "translated";
    private Object translated;

    public SalutationJsonApi() {
    }

    @JsonCreator
    public SalutationJsonApi(@JsonProperty(value="createdAt") OffsetDateTime createdAt, @JsonProperty(value="updatedAt") OffsetDateTime updatedAt) {
        this();
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    public SalutationJsonApi type(String type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(String type) {
        this.type = type;
    }

    public SalutationJsonApi id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(String id) {
        this.id = id;
    }

    public SalutationJsonApi attributes(Map<String, Object> attributes) {
        this.attributes = attributes;
        return this;
    }

    public SalutationJsonApi putAttributesItem(String key, Object attributesItem) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(key, attributesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="attributes")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @JsonProperty(value="attributes")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public SalutationJsonApi relationships(Relationships relationships) {
        this.relationships = JsonNullable.of((Object)relationships);
        return this;
    }

    @Nullable
    @JsonIgnore
    public Relationships getRelationships() {
        return (Relationships)this.relationships.orElse(null);
    }

    @JsonProperty(value="relationships")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Relationships> getRelationships_JsonNullable() {
        return this.relationships;
    }

    @JsonProperty(value="relationships")
    public void setRelationships_JsonNullable(JsonNullable<Relationships> relationships) {
        this.relationships = relationships;
    }

    public void setRelationships(Relationships relationships) {
        this.relationships = JsonNullable.of((Object)relationships);
    }

    public SalutationJsonApi links(Map<String, Link> links) {
        this.links = links;
        return this;
    }

    public SalutationJsonApi putLinksItem(String key, Link linksItem) {
        if (this.links == null) {
            this.links = new HashMap<String, Link>();
        }
        this.links.put(key, linksItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Link> getLinks() {
        return this.links;
    }

    @JsonProperty(value="links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(Map<String, Link> links) {
        this.links = links;
    }

    public SalutationJsonApi meta(Map<String, Object> meta) {
        this.meta = meta;
        return this;
    }

    public SalutationJsonApi putMetaItem(String key, Object metaItem) {
        if (this.meta == null) {
            this.meta = new HashMap<String, Object>();
        }
        this.meta.put(key, metaItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="meta")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getMeta() {
        return this.meta;
    }

    @JsonProperty(value="meta")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public void setMeta(Map<String, Object> meta) {
        this.meta = meta;
    }

    public SalutationJsonApi salutationKey(String salutationKey) {
        this.salutationKey = salutationKey;
        return this;
    }

    @Nonnull
    @JsonProperty(value="salutationKey")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSalutationKey() {
        return this.salutationKey;
    }

    @JsonProperty(value="salutationKey")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSalutationKey(String salutationKey) {
        this.salutationKey = salutationKey;
    }

    public SalutationJsonApi displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Nonnull
    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public SalutationJsonApi letterName(String letterName) {
        this.letterName = letterName;
        return this;
    }

    @Nonnull
    @JsonProperty(value="letterName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getLetterName() {
        return this.letterName;
    }

    @JsonProperty(value="letterName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLetterName(String letterName) {
        this.letterName = letterName;
    }

    public SalutationJsonApi customFields(Object customFields) {
        this.customFields = customFields;
        return this;
    }

    @Nullable
    @JsonProperty(value="customFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getCustomFields() {
        return this.customFields;
    }

    @JsonProperty(value="customFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustomFields(Object customFields) {
        this.customFields = customFields;
    }

    @Nonnull
    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Nullable
    @JsonProperty(value="updatedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public SalutationJsonApi translated(Object translated) {
        this.translated = translated;
        return this;
    }

    @Nullable
    @JsonProperty(value="translated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getTranslated() {
        return this.translated;
    }

    @JsonProperty(value="translated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTranslated(Object translated) {
        this.translated = translated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SalutationJsonApi salutationJsonApi = (SalutationJsonApi)o;
        return Objects.equals(this.type, salutationJsonApi.type) && Objects.equals(this.id, salutationJsonApi.id) && Objects.equals(this.attributes, salutationJsonApi.attributes) && SalutationJsonApi.equalsNullable(this.relationships, salutationJsonApi.relationships) && Objects.equals(this.links, salutationJsonApi.links) && Objects.equals(this.meta, salutationJsonApi.meta) && Objects.equals(this.salutationKey, salutationJsonApi.salutationKey) && Objects.equals(this.displayName, salutationJsonApi.displayName) && Objects.equals(this.letterName, salutationJsonApi.letterName) && Objects.equals(this.customFields, salutationJsonApi.customFields) && Objects.equals(this.createdAt, salutationJsonApi.createdAt) && Objects.equals(this.updatedAt, salutationJsonApi.updatedAt) && Objects.equals(this.translated, salutationJsonApi.translated);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.type, this.id, this.attributes, SalutationJsonApi.hashCodeNullable(this.relationships), this.links, this.meta, this.salutationKey, this.displayName, this.letterName, this.customFields, this.createdAt, this.updatedAt, this.translated);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SalutationJsonApi {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    relationships: ").append(this.toIndentedString(this.relationships)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    meta: ").append(this.toIndentedString(this.meta)).append("\n");
        sb.append("    salutationKey: ").append(this.toIndentedString(this.salutationKey)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    letterName: ").append(this.toIndentedString(this.letterName)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    translated: ").append(this.toIndentedString(this.translated)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

