/*
 * Decompiled with CFR 0.152.
 */
package de.codebarista.shopware.model.core;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import de.codebarista.shopware.model.core.Snippet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"id", "name", "iso", "customFields", "createdAt", "updatedAt", "snippets"})
public class SnippetSet {
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_ISO = "iso";
    private String iso;
    public static final String JSON_PROPERTY_CUSTOM_FIELDS = "customFields";
    private Object customFields;
    public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_UPDATED_AT = "updatedAt";
    private OffsetDateTime updatedAt;
    public static final String JSON_PROPERTY_SNIPPETS = "snippets";
    private List<Snippet> snippets = new ArrayList<Snippet>();

    public SnippetSet() {
    }

    @JsonCreator
    public SnippetSet(@JsonProperty(value="createdAt") OffsetDateTime createdAt, @JsonProperty(value="updatedAt") OffsetDateTime updatedAt) {
        this();
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    public SnippetSet id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public SnippetSet name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public SnippetSet iso(String iso) {
        this.iso = iso;
        return this;
    }

    @Nonnull
    @JsonProperty(value="iso")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getIso() {
        return this.iso;
    }

    @JsonProperty(value="iso")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIso(String iso) {
        this.iso = iso;
    }

    public SnippetSet customFields(Object customFields) {
        this.customFields = customFields;
        return this;
    }

    @Nullable
    @JsonProperty(value="customFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getCustomFields() {
        return this.customFields;
    }

    @JsonProperty(value="customFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustomFields(Object customFields) {
        this.customFields = customFields;
    }

    @Nonnull
    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Nullable
    @JsonProperty(value="updatedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public SnippetSet snippets(List<Snippet> snippets) {
        this.snippets = snippets;
        return this;
    }

    public SnippetSet addSnippetsItem(Snippet snippetsItem) {
        if (this.snippets == null) {
            this.snippets = new ArrayList<Snippet>();
        }
        this.snippets.add(snippetsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="snippets")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Snippet> getSnippets() {
        return this.snippets;
    }

    @JsonProperty(value="snippets")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSnippets(List<Snippet> snippets) {
        this.snippets = snippets;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnippetSet snippetSet = (SnippetSet)o;
        return Objects.equals(this.id, snippetSet.id) && Objects.equals(this.name, snippetSet.name) && Objects.equals(this.iso, snippetSet.iso) && Objects.equals(this.customFields, snippetSet.customFields) && Objects.equals(this.createdAt, snippetSet.createdAt) && Objects.equals(this.updatedAt, snippetSet.updatedAt) && Objects.equals(this.snippets, snippetSet.snippets);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.iso, this.customFields, this.createdAt, this.updatedAt, this.snippets);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SnippetSet {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    iso: ").append(this.toIndentedString(this.iso)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    snippets: ").append(this.toIndentedString(this.snippets)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

