/*
 * Decompiled with CFR 0.152.
 */
package de.codebarista.shopware.model.core;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import de.codebarista.shopware.model.core.StateMachineState;
import de.codebarista.shopware.model.core.StateMachineTransition;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"id", "createdAt", "updatedAt", "translated", "states", "transitions"})
public class StateMachine {
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_UPDATED_AT = "updatedAt";
    private OffsetDateTime updatedAt;
    public static final String JSON_PROPERTY_TRANSLATED = "translated";
    private Object translated;
    public static final String JSON_PROPERTY_STATES = "states";
    private List<StateMachineState> states = new ArrayList<StateMachineState>();
    public static final String JSON_PROPERTY_TRANSITIONS = "transitions";
    private List<StateMachineTransition> transitions = new ArrayList<StateMachineTransition>();

    public StateMachine() {
    }

    @JsonCreator
    public StateMachine(@JsonProperty(value="createdAt") OffsetDateTime createdAt, @JsonProperty(value="updatedAt") OffsetDateTime updatedAt) {
        this();
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    public StateMachine id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    @Nonnull
    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Nullable
    @JsonProperty(value="updatedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public StateMachine translated(Object translated) {
        this.translated = translated;
        return this;
    }

    @Nullable
    @JsonProperty(value="translated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getTranslated() {
        return this.translated;
    }

    @JsonProperty(value="translated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTranslated(Object translated) {
        this.translated = translated;
    }

    public StateMachine states(List<StateMachineState> states) {
        this.states = states;
        return this;
    }

    public StateMachine addStatesItem(StateMachineState statesItem) {
        if (this.states == null) {
            this.states = new ArrayList<StateMachineState>();
        }
        this.states.add(statesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="states")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<StateMachineState> getStates() {
        return this.states;
    }

    @JsonProperty(value="states")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStates(List<StateMachineState> states) {
        this.states = states;
    }

    public StateMachine transitions(List<StateMachineTransition> transitions) {
        this.transitions = transitions;
        return this;
    }

    public StateMachine addTransitionsItem(StateMachineTransition transitionsItem) {
        if (this.transitions == null) {
            this.transitions = new ArrayList<StateMachineTransition>();
        }
        this.transitions.add(transitionsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="transitions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<StateMachineTransition> getTransitions() {
        return this.transitions;
    }

    @JsonProperty(value="transitions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTransitions(List<StateMachineTransition> transitions) {
        this.transitions = transitions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StateMachine stateMachine = (StateMachine)o;
        return Objects.equals(this.id, stateMachine.id) && Objects.equals(this.createdAt, stateMachine.createdAt) && Objects.equals(this.updatedAt, stateMachine.updatedAt) && Objects.equals(this.translated, stateMachine.translated) && Objects.equals(this.states, stateMachine.states) && Objects.equals(this.transitions, stateMachine.transitions);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.createdAt, this.updatedAt, this.translated, this.states, this.transitions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StateMachine {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    translated: ").append(this.toIndentedString(this.translated)).append("\n");
        sb.append("    states: ").append(this.toIndentedString(this.states)).append("\n");
        sb.append("    transitions: ").append(this.toIndentedString(this.transitions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

