package de.codecamp.maven.delayment.model;


import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Stream;


public enum DefaultLifecycle
{

  VALIDATE("validate"),
  INITIALIZE("initialize"),
  GENERATE_SOURCES("generate-sources"),
  PROCESS_SOURCES("process-sources"),
  GENERATE_RESOURCES("generate-resources"),
  PROCESS_RESOURCES("process-resources"),
  COMPILE("compile"),
  PROCESS_CLASSES("process-classes"),
  GENERATE_TEST_SOURCES("generate-test-sources"),
  PROCESS_TEST_SOURCES("process-test-sources"),
  GENERATE_TEST_RESOURCES("generate-test-resources"),
  PROCESS_TEST_RESOURCES("process-test-resources"),
  TEST_COMPILE("test-compile"),
  PROCESS_TEST_CLASSES("process-test-classes"),
  TEST("test"),
  PREPARE_PACKAGE("prepare-package"),
  PACKAGE("package"),
  PRE_INTEGRATION_TEST("pre-integration-test"),
  INTEGRATION_TEST("integration-test"),
  POST_INTEGRATION_TEST("post-integration-test"),
  VERIFY("verify"),
  INSTALL("install"),
  DEPLOY("deploy");


  private final String phase;


  DefaultLifecycle(String phase)
  {
    this.phase = phase;
  }


  public String phase()
  {
    return this.phase;
  }


  public static DefaultLifecycle valueOfPhase(String phase)
  {
    return valueOfPhaseOptional(phase)
        .orElseThrow(() -> new NoSuchElementException(phase + " not found"));
  }

  public static Optional<DefaultLifecycle> valueOfPhaseOptional(String phase)
  {
    return Stream.of(values()).filter(dlc -> dlc.phase().equals(phase)).findFirst();
  }

}
