/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.maven.delayment;

import de.codecamp.maven.delayment.model.CleanLifecycle;
import de.codecamp.maven.delayment.model.DefaultLifecycle;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Extension;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.sisu.Priority;

@Singleton
@Named(value="DelaymentLifecycleParticipant")
@Priority(value=-2147483648)
public class DelaymentLifecycleParticipant
extends AbstractMavenLifecycleParticipant
implements LogEnabled {
    public static final String GROUP_ID = "de.codecamp.maven";
    public static final String ARTIFACT_ID = "delayment-maven-plugin";
    public static final String PROPERTY_USE_LOCAL_REPOSITORY = "delayment.useLocalRepository";
    private Logger log;
    private String extensionVersion;

    public void enableLogging(Logger logger) {
        this.log = logger;
    }

    public void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        boolean useLocalRepository = DelaymentLifecycleParticipant.getExtensionProperty(session, PROPERTY_USE_LOCAL_REPOSITORY).map(Boolean::parseBoolean).orElse(false);
        Mode mode = session.getGoals().size() == 1 && session.getGoals().contains(CleanLifecycle.CLEAN.phase()) ? Mode.NONE : (session.getGoals().contains(CleanLifecycle.CLEAN.phase()) ? Mode.RECORD : (session.getGoals().contains(DefaultLifecycle.INSTALL.phase()) && !useLocalRepository || session.getGoals().contains(DefaultLifecycle.DEPLOY.phase()) ? Mode.RESTORE : Mode.RECORD));
        this.log.info(String.format("--- %s ---", MessageUtils.buffer().warning((Object)ARTIFACT_ID)));
        switch (mode) {
            case RECORD: {
                this.log.info("RECORD-mode of delayed deployment enabled.");
                for (MavenProject project : session.getProjects()) {
                    this.log.debug("");
                    this.log.debug(String.format("* %s", MessageUtils.buffer().project((Object)(project.getGroupId() + ":" + project.getArtifactId()))));
                    this.addPlugin(session, project, DefaultLifecycle.VERIFY, "recordArtifacts", null);
                }
                break;
            }
            case RESTORE: {
                this.log.info("RESTORE-mode of delayed deployment enabled.");
                if (useLocalRepository) {
                    this.log.info("Artifact files will be reattached from local repository (instead of target-directory).");
                }
                DefaultLifecycle skippedPhases = useLocalRepository ? DefaultLifecycle.INSTALL : DefaultLifecycle.VERIFY;
                for (MavenProject project : session.getProjects()) {
                    this.log.debug("");
                    this.log.debug(String.format("* %s", MessageUtils.buffer().project((Object)(project.getGroupId() + ":" + project.getArtifactId()))));
                    this.removeExecutionsUpTo(project, skippedPhases);
                    this.addPlugin(session, project, DefaultLifecycle.INITIALIZE, "reattachArtifacts", useLocalRepository ? Map.of("useLocalRepository", Boolean.TRUE.toString()) : null);
                }
                break;
            }
            case NONE: {
                this.log.info("Delayed deployment NOT enabled.");
            }
        }
    }

    private void addPlugin(MavenSession session, MavenProject project, DefaultLifecycle phase, String goal, Map<String, String> configuration) throws MavenExecutionException {
        this.log.debug(String.format("  Adding %s-goal to %s-phase.", MessageUtils.buffer().mojo((Object)goal), phase.phase()));
        if (this.extensionVersion == null) {
            this.extensionVersion = ((Object)((Object)this)).getClass().getPackage().getImplementationVersion();
        }
        if (this.extensionVersion == null) {
            block0: for (MavenProject p : session.getProjects()) {
                for (Extension extension : p.getBuildExtensions()) {
                    if (!extension.getGroupId().equals(GROUP_ID) || !extension.getArtifactId().equals(ARTIFACT_ID)) continue;
                    this.extensionVersion = extension.getVersion();
                    break block0;
                }
            }
        }
        if (this.extensionVersion == null) {
            throw new MavenExecutionException("Failed to determine the used version of the 'delayment-maven-plugin' extension.", (Throwable)null);
        }
        Plugin plugin = new Plugin();
        plugin.setGroupId(GROUP_ID);
        plugin.setArtifactId(ARTIFACT_ID);
        plugin.setVersion(this.extensionVersion);
        PluginExecution execution = new PluginExecution();
        execution.setPhase(phase.phase());
        execution.getGoals().add(goal);
        if (configuration != null) {
            Xpp3Dom executionConfiguration = new Xpp3Dom("configuration");
            execution.setConfiguration((Object)executionConfiguration);
            configuration.forEach((key, value) -> {
                Xpp3Dom pluginConfEntry = new Xpp3Dom(key);
                pluginConfEntry.setValue(value);
                executionConfiguration.addChild(pluginConfEntry);
            });
        }
        plugin.getExecutions().add(execution);
        project.getBuild().getPlugins().add(plugin);
    }

    private void removeExecutionsUpTo(MavenProject project, DefaultLifecycle phase) {
        for (Plugin plugin : project.getBuild().getPlugins()) {
            for (PluginExecution execution : new ArrayList(plugin.getExecutions())) {
                DefaultLifecycle executionPhase = DefaultLifecycle.valueOfPhaseOptional(execution.getPhase()).orElse(null);
                if (execution.getPhase() != null && (executionPhase == null || executionPhase.ordinal() > phase.ordinal())) continue;
                this.log.debug(String.format("  Removing execution %s (%s).", MessageUtils.buffer().mojo((Object)plugin.getArtifactId()), execution.getId()));
                plugin.getExecutions().remove(execution);
            }
        }
    }

    private static Optional<String> getExtensionProperty(MavenSession session, String key) {
        for (MavenProject project : session.getProjects()) {
            String value = project.getProperties().getProperty(key);
            if (value == null) continue;
            return Optional.of(value);
        }
        return Optional.empty();
    }

    private static enum Mode {
        RECORD,
        RESTORE,
        NONE;

    }
}

