/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.maven.delayment;

import de.codecamp.maven.delayment.AbstractDelaymentMojo;
import de.codecamp.maven.delayment.model.RecordedArtifacts;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.inject.Inject;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProjectHelper;
import org.eclipse.aether.RepositorySystemSession;

@Mojo(name="reattachArtifacts", defaultPhase=LifecyclePhase.VERIFY)
public class ReattachArtifactsMojo
extends AbstractDelaymentMojo {
    public static final String MOJO_NAME = "reattachArtifacts";
    public static final String CONF_USE_LOCAL_REPOSITORY = "useLocalRepository";
    @Inject
    private MavenProjectHelper helper;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true, required=true)
    private RepositorySystemSession repositorySystemSession;
    @Parameter(property="delayment.useLocalRepository", defaultValue="false")
    private Boolean useLocalRepository;

    public void execute() throws MojoExecutionException {
        RecordedArtifacts recordedArtifacts;
        Path artifactsFilePath = this.getArtifactsFilePath();
        this.getLog().info((CharSequence)("Reattaching artifacts for delayed deployment from file '" + artifactsFilePath + "':"));
        if (!Files.isRegularFile(artifactsFilePath, new LinkOption[0])) {
            throw new MojoExecutionException("'" + artifactsFilePath.getFileName().toString() + "' missing. Recorded artifacts not found.");
        }
        try (BufferedReader in = Files.newBufferedReader(artifactsFilePath, StandardCharsets.UTF_8);){
            recordedArtifacts = (RecordedArtifacts)this.getGson().fromJson((Reader)in, RecordedArtifacts.class);
        }
        catch (IOException | RuntimeException ex) {
            throw new MojoExecutionException("Failed to restore artifacts from '" + artifactsFilePath + "'.", ex);
        }
        if (recordedArtifacts.getMainFile() == null && recordedArtifacts.getArtifacts().isEmpty()) {
            this.getLog().info((CharSequence)"Nothing to reattach.");
            return;
        }
        if (recordedArtifacts.getMainFile() != null) {
            File mainArtifactFile;
            if (this.useLocalRepository.booleanValue()) {
                File basedir = this.repositorySystemSession.getLocalRepository().getBasedir();
                mainArtifactFile = new File(basedir, this.repositorySystemSession.getLocalRepositoryManager().getPathForLocalArtifact(RepositoryUtils.toArtifact((Artifact)this.getProject().getArtifact())));
            } else {
                mainArtifactFile = recordedArtifacts.getMainFile();
            }
            this.getLog().info((CharSequence)("  main - " + mainArtifactFile));
            this.getProject().getArtifact().setFile(mainArtifactFile);
        }
        for (RecordedArtifacts.Artifact recordedArtifact : recordedArtifacts.getArtifacts()) {
            File attachedArtifactFile = recordedArtifact.getFile();
            this.helper.attachArtifact(this.getProject(), recordedArtifact.getType(), recordedArtifact.getClassifier(), attachedArtifactFile);
            if (this.useLocalRepository.booleanValue()) {
                Artifact artifact = (Artifact)this.getProject().getAttachedArtifacts().get(this.getProject().getAttachedArtifacts().size() - 1);
                File basedir = this.repositorySystemSession.getLocalRepository().getBasedir();
                attachedArtifactFile = new File(basedir, this.repositorySystemSession.getLocalRepositoryManager().getPathForLocalArtifact(RepositoryUtils.toArtifact((Artifact)artifact)));
                artifact.setFile(attachedArtifactFile);
            }
            this.getLog().info((CharSequence)String.format("  %s:%s - %s", recordedArtifact.getType(), recordedArtifact.getClassifier(), attachedArtifactFile));
        }
    }
}

