/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.maven.delayment;

import de.codecamp.maven.delayment.AbstractDelaymentMojo;
import de.codecamp.maven.delayment.model.RecordedArtifacts;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="recordArtifacts", defaultPhase=LifecyclePhase.VERIFY)
public class RecordArtifactsMojo
extends AbstractDelaymentMojo {
    public static final String MOJO_NAME = "recordArtifacts";

    public void execute() throws MojoExecutionException {
        Path artifactsFilePath = this.getArtifactsFilePath();
        this.getLog().info((CharSequence)("Recording artifacts for delayed deployment into file '" + artifactsFilePath + "':"));
        RecordedArtifacts artifacts = new RecordedArtifacts();
        File mainArtifactFile = this.getProject().getArtifact().getFile();
        if (mainArtifactFile != null) {
            this.getLog().info((CharSequence)("  main - " + mainArtifactFile));
            artifacts.setMainFile(mainArtifactFile);
        }
        for (Artifact attachedArtifact : this.getProject().getAttachedArtifacts()) {
            this.getLog().info((CharSequence)String.format("  %s:%s - %s", this.getProject().getArtifact().getType(), attachedArtifact.getClassifier(), attachedArtifact.getFile()));
            artifacts.getArtifacts().add(new RecordedArtifacts.Artifact(this.getProject().getArtifact().getType(), attachedArtifact.getClassifier(), attachedArtifact.getFile()));
        }
        try {
            Files.createDirectories(Paths.get(this.getProject().getBuild().getDirectory(), new String[0]), new FileAttribute[0]);
            try (BufferedWriter out = Files.newBufferedWriter(artifactsFilePath, StandardCharsets.UTF_8, new OpenOption[0]);){
                this.getGson().toJson((Object)artifacts, (Appendable)out);
            }
        }
        catch (IOException | RuntimeException ex) {
            throw new MojoExecutionException("Failed to record artifacts to '" + artifactsFilePath + "'.", ex);
        }
    }
}

