/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.maven.delayment.model;

import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Stream;

public enum CleanLifecycle {
    PRE_CLEAN("pre-clean"),
    CLEAN("clean"),
    POST_CLEAN("post-clean");

    private final String phase;

    private CleanLifecycle(String phase) {
        this.phase = phase;
    }

    public String phase() {
        return this.phase;
    }

    public static CleanLifecycle valueOfPhase(String phase) {
        return CleanLifecycle.valueOfPhaseOptional(phase).orElseThrow(() -> new NoSuchElementException(phase + " not found"));
    }

    public static Optional<CleanLifecycle> valueOfPhaseOptional(String phase) {
        return Stream.of(CleanLifecycle.values()).filter(dlc -> dlc.phase().equals(phase)).findFirst();
    }
}

