/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages.proxy;

import de.codecamp.messages.codegen.MessageProxyMethod;
import de.codecamp.messages.proxy.AbstractMessageProxyInvocationHandler;
import de.codecamp.messages.proxy.MessageProvider;
import java.lang.reflect.Method;

public class MessageProxyInvocationHandler
extends AbstractMessageProxyInvocationHandler {
    private MessageProvider messageProvider;

    public MessageProxyInvocationHandler(MessageProvider messageProvider) {
        if (messageProvider == null) {
            throw new IllegalArgumentException("messageProvider must not be null");
        }
        this.messageProvider = messageProvider;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        MessageProxyMethod messageProxyMethodAt = method.getAnnotation(MessageProxyMethod.class);
        if (messageProxyMethodAt != null) {
            return this.messageProvider.getMessage(messageProxyMethodAt.code(), args);
        }
        return super.invoke(proxy, method, args);
    }
}

