/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages;

import de.codecamp.messages.MessageKey;
import de.codecamp.messages.impl.ResolvableMessageImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface ResolvableMessage
extends MessageKey,
Serializable {
    public Map<String, Object> getArgsByName();

    public Map<String, Object> getArgsByName(boolean var1);

    public List<Object> getArgsByIndex();

    public static ResolvableMessage of(String code) {
        return new ResolvableMessageImpl(code);
    }

    public static ResolvableMessage of(String code, Map<String, Object> argsByName, List<Object> argsByIndex) {
        return new ResolvableMessageImpl(code, argsByName, argsByIndex);
    }

    public static Builder forCode(String code) {
        return new Builder(code);
    }

    public static ResolvableMessage forCodeNoArgs(String code) {
        return new ResolvableMessageImpl(code);
    }

    public static class Builder {
        private final String code;
        private Map<String, Object> argsByName;
        private List<Object> argsByIndex;

        public Builder(String code) {
            this.code = code;
        }

        public Builder arg(String name, Object value) {
            if (this.argsByName == null) {
                this.argsByName = new HashMap<String, Object>();
                this.argsByIndex = new ArrayList<Object>();
            }
            if (name != null) {
                this.argsByName.put(name, value);
            }
            this.argsByIndex.add(value);
            return this;
        }

        public ResolvableMessage build() {
            return new ResolvableMessageImpl(this.code, (Map<String, Object>)(this.argsByName == null || this.argsByName.isEmpty() ? Collections.emptyMap() : new HashMap<String, Object>(this.argsByName)), this.argsByIndex == null || this.argsByIndex.isEmpty() ? Collections.emptyList() : new ArrayList<Object>(this.argsByIndex));
        }
    }
}

