/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages;

import de.codecamp.messages.Messages;
import java.lang.annotation.Annotation;
import java.util.Objects;

public class MessageKeyUtils {
    public static String getKeyFor(Class<?> type) {
        return MessageKeyUtils.getKeyFor(MessageKeyUtils.getPrefixFor(type), "Type");
    }

    public static String getKeyFor(Enum<?> enumConstant) {
        return MessageKeyUtils.getKeyFor(enumConstant.getDeclaringClass(), enumConstant.name());
    }

    public static String getKeyFor(Class<?> type, String localPart) {
        return MessageKeyUtils.getKeyFor(MessageKeyUtils.getPrefixFor(type), localPart);
    }

    public static String getKeyFor(Class<?> type, String localPartPrefix, String localPart) {
        return MessageKeyUtils.getKeyFor(MessageKeyUtils.getPrefixFor(type), localPartPrefix, localPart);
    }

    public static String getKeyFor(String prefix, String localPart) {
        Objects.requireNonNull("prefix must not be null");
        if (localPart != null && !localPart.isEmpty()) {
            return prefix + localPart;
        }
        return prefix;
    }

    public static String getKeyFor(String prefix, String localPartPrefix, String localPart) {
        Object fullLocalPart = localPartPrefix != null && !localPartPrefix.isEmpty() ? (localPart != null && !localPart.isEmpty() ? localPartPrefix + "_" + localPart : localPartPrefix) : (localPart != null && !localPart.isEmpty() ? localPart : null);
        return MessageKeyUtils.getKeyFor(prefix, (String)fullLocalPart);
    }

    private static String getPrefixFor(Class<?> sourceType) {
        Object prefix = null;
        Messages messagesAt = sourceType.getAnnotation(Messages.class);
        if (messagesAt != null) {
            prefix = messagesAt.prefix();
        }
        if (prefix == null || ((String)prefix).equals("__SOURCE_TYPE__")) {
            Annotation at;
            Annotation[] annotationArray = sourceType.getAnnotations();
            int n = annotationArray.length;
            for (int i = 0; i < n && ((messagesAt = (at = annotationArray[i]).annotationType().getAnnotation(Messages.class)) == null || ((String)(prefix = messagesAt.prefix())).equals("__SOURCE_TYPE__")); ++i) {
            }
        }
        if (prefix == null || ((String)prefix).equals("__SOURCE_TYPE__")) {
            prefix = sourceType.getCanonicalName() + ".";
        }
        return prefix;
    }
}

