/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages.proxy;

import de.codecamp.messages.ResolvableMessage;
import de.codecamp.messages.codegen.MessageProxyMethod;
import de.codecamp.messages.codegen.MessageProxyParam;
import de.codecamp.messages.proxy.AbstractMessageProxyInvocationHandler;
import de.codecamp.messages.proxy.NamedArgsMessageProvider;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;

public class NamedArgsMessageProxyInvocationHandler
extends AbstractMessageProxyInvocationHandler {
    private NamedArgsMessageProvider messageProvider;

    public NamedArgsMessageProxyInvocationHandler(NamedArgsMessageProvider messageProvider) {
        if (messageProvider == null) {
            throw new IllegalArgumentException("messageProvider must not be null");
        }
        this.messageProvider = messageProvider;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        MessageProxyMethod messageProxyMethodAt = method.getAnnotation(MessageProxyMethod.class);
        if (messageProxyMethodAt != null) {
            String code = messageProxyMethodAt.code();
            ResolvableMessage.Builder builder = ResolvableMessage.forCode(code);
            if (method.getParameterCount() > 0) {
                Parameter[] parameters = method.getParameters();
                for (int i = 0; i < parameters.length; ++i) {
                    Parameter param = parameters[i];
                    String argName = null;
                    MessageProxyParam argNameAt = param.getAnnotation(MessageProxyParam.class);
                    if (argNameAt != null) {
                        argName = !argNameAt.name().isEmpty() ? argNameAt.name() : null;
                    }
                    builder.arg(argName, args[i]);
                }
            }
            return this.messageProvider.getMessage(builder.build());
        }
        return super.invoke(proxy, method, args);
    }
}

