/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages.runtime;

import de.codecamp.messages.runtime.MessageArgConverter;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.function.Supplier;

public class DefaultMessageArgConverter
implements MessageArgConverter {
    private final Supplier<TimeZone> timeZoneProvider;

    public DefaultMessageArgConverter(Supplier<TimeZone> timeZoneProvider) {
        this.timeZoneProvider = timeZoneProvider;
    }

    @Override
    public Object convert(Object value, Locale locale) {
        if (value instanceof LocalDate) {
            return Date.from(((LocalDate)value).atStartOfDay(this.timeZoneProvider.get().toZoneId()).toInstant());
        }
        if (value instanceof LocalTime) {
            ZoneId zoneId = this.zoneId();
            return Date.from(((LocalTime)value).atDate(LocalDate.now(zoneId)).atZone(zoneId).toInstant());
        }
        if (value instanceof LocalDateTime) {
            return Date.from(((LocalDateTime)value).atZone(this.zoneId()).toInstant());
        }
        if (value instanceof ZonedDateTime) {
            return Date.from(((ZonedDateTime)value).toInstant());
        }
        if (value instanceof OffsetTime) {
            ZoneId zoneId = this.zoneId();
            return Date.from(((OffsetTime)value).atDate(LocalDate.now(zoneId)).atZoneSameInstant(zoneId).toInstant());
        }
        if (value instanceof OffsetDateTime) {
            return Date.from(((OffsetDateTime)value).atZoneSameInstant(this.zoneId()).toInstant());
        }
        if (value instanceof Instant) {
            return Date.from(((Instant)value).atZone(this.zoneId()).toInstant());
        }
        return value;
    }

    private ZoneId zoneId() {
        return this.timeZoneProvider.get().toZoneId();
    }
}

