/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages;

import de.codecamp.messages.MessageArg;
import de.codecamp.messages.MessageKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public interface MessageKeyWithArgs
extends MessageKey {
    public boolean hasArgs();

    public String[] getArgTypes();

    public String[] getArgNames();

    default public List<MessageArg> getArgs() {
        if (!this.hasArgs()) {
            return Collections.emptyList();
        }
        final String[] argNames = this.getArgNames();
        final String[] argTypes = this.getArgTypes();
        ArrayList<MessageArg> args = new ArrayList<MessageArg>(argNames.length);
        int i = 0;
        while (i < argNames.length) {
            final int index = i++;
            args.add(new MessageArg(){

                @Override
                public String getName() {
                    return argNames[index];
                }

                @Override
                public int getIndex() {
                    return index;
                }

                @Override
                public String getType() {
                    return argTypes[index];
                }
            });
        }
        return args;
    }
}

