/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages.runtime;

import com.ibm.icu.util.TimeZone;
import de.codecamp.messages.runtime.MessageArgConverter;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Locale;
import java.util.function.Supplier;

public class IcuMessageArgConverter
implements MessageArgConverter {
    private final Supplier<java.util.TimeZone> timeZoneProvider;

    public IcuMessageArgConverter(Supplier<java.util.TimeZone> timeZoneProvider) {
        this.timeZoneProvider = timeZoneProvider;
    }

    @Override
    public Object convert(Object value, Locale locale) {
        ZonedDateTime zonedDateTime = null;
        if (value instanceof Calendar) {
            Calendar juc = (Calendar)value;
            zonedDateTime = ZonedDateTime.ofInstant(juc.toInstant(), juc.getTimeZone().toZoneId());
        } else if (value instanceof LocalDate) {
            zonedDateTime = ((LocalDate)value).atStartOfDay(this.zoneId());
        } else if (value instanceof LocalTime) {
            zonedDateTime = ((LocalTime)value).atDate(LocalDate.now(this.zoneId())).atZone(this.zoneId());
        } else if (value instanceof LocalDateTime) {
            zonedDateTime = ((LocalDateTime)value).atZone(this.zoneId());
        } else if (value instanceof ZonedDateTime) {
            zonedDateTime = (ZonedDateTime)value;
        } else if (value instanceof OffsetTime) {
            zonedDateTime = ((OffsetTime)value).atDate(LocalDate.now(this.zoneId())).atZoneSameInstant(this.zoneId());
        } else if (value instanceof OffsetDateTime) {
            zonedDateTime = ((OffsetDateTime)value).atZoneSameInstant(this.zoneId());
        } else if (value instanceof Instant) {
            zonedDateTime = ((Instant)value).atZone(this.zoneId());
        }
        if (zonedDateTime != null) {
            com.ibm.icu.util.Calendar calendar = com.ibm.icu.util.Calendar.getInstance((TimeZone)TimeZone.getTimeZone((String)this.timeZoneProvider.get().getID()));
            calendar.setTimeInMillis(zonedDateTime.toInstant().toEpochMilli());
            return calendar;
        }
        return value;
    }

    private ZoneId zoneId() {
        return this.timeZoneProvider.get().toZoneId();
    }
}

