/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages;

import de.codecamp.messages.Messages;
import java.lang.annotation.Annotation;

public class MessageKeyUtils {
    public static String getKeyFor(Class<?> type) {
        return MessageKeyUtils.getPrefixFor(type) + "Type";
    }

    public static String getKeyFor(Enum<?> enumConstant) {
        return MessageKeyUtils.getKeyFor(enumConstant.getDeclaringClass(), enumConstant.name());
    }

    public static String getKeyFor(Class<?> type, String localPart) {
        return MessageKeyUtils.getKeyFor(MessageKeyUtils.getPrefixFor(type), localPart);
    }

    public static String getKeyFor(Class<?> type, String localPartPrefix, String localPart) {
        return MessageKeyUtils.getKeyFor(MessageKeyUtils.getPrefixFor(type), localPartPrefix, localPart);
    }

    public static String getKeyFor(String prefix, String localPart) {
        if (localPart != null && !localPart.isEmpty()) {
            return prefix + localPart;
        }
        return prefix;
    }

    public static String getKeyFor(String prefix, String localPartPrefix, String localPart) {
        String fullLocalPart = localPartPrefix != null && !localPartPrefix.isEmpty() ? (localPart != null && !localPart.isEmpty() ? localPartPrefix + "_" + localPart : localPartPrefix) : (localPart != null && !localPart.isEmpty() ? localPart : null);
        return MessageKeyUtils.getKeyFor(prefix, fullLocalPart);
    }

    private static String getPrefixFor(Class<?> sourceType) {
        String prefix = null;
        Messages messagesAt = sourceType.getAnnotation(Messages.class);
        if (messagesAt != null) {
            prefix = messagesAt.prefix();
        }
        if (prefix == null || prefix.equals("__SOURCE_TYPE__")) {
            Annotation at;
            Annotation[] annotationArray = sourceType.getAnnotations();
            int n = annotationArray.length;
            for (int i = 0; i < n && ((messagesAt = (at = annotationArray[i]).annotationType().getAnnotation(Messages.class)) == null || (prefix = messagesAt.prefix()).equals("__SOURCE_TYPE__")); ++i) {
            }
        }
        if (prefix == null || prefix.equals("__SOURCE_TYPE__")) {
            prefix = sourceType.getCanonicalName() + ".";
        }
        return prefix;
    }
}

