/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages;

import de.codecamp.messages.MessageKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;

public class ResolvableMessage
implements MessageKey {
    private final String code;
    private final Map<String, Object> argsByName;
    private final List<Object> argsByIndex;

    private ResolvableMessage(String code) {
        this.code = code;
        this.argsByName = Collections.emptyMap();
        this.argsByIndex = Collections.emptyList();
    }

    private ResolvableMessage(String code, Map<String, Object> argsByName, List<Object> argsByIndex) {
        this.code = code;
        this.argsByName = argsByName;
        this.argsByIndex = argsByIndex;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    public Map<String, Object> getArgsByName() {
        return this.getArgsByName(false);
    }

    public Map<String, Object> getArgsByName(boolean includeByIndex) {
        if (!includeByIndex) {
            if (this.argsByName.size() != this.argsByIndex.size()) {
                throw new IllegalStateException("Names aren't available for all message arguments.");
            }
            return this.argsByName;
        }
        HashMap<String, Object> result = new HashMap<String, Object>(this.argsByName);
        for (int i = 0; i < this.argsByIndex.size(); ++i) {
            result.put(Integer.toString(i), this.argsByIndex.get(i));
        }
        return result;
    }

    public Object[] getArgsByIndex() {
        return this.argsByIndex.toArray(new Object[this.argsByIndex.size()]);
    }

    public void convertValues(BiFunction<Object, Locale, Object> converter, Locale locale) {
        for (Map.Entry<String, Object> entry : this.argsByName.entrySet()) {
            entry.setValue(converter.apply(entry.getValue(), locale));
        }
        ListIterator<Object> it = this.argsByIndex.listIterator();
        while (it.hasNext()) {
            it.set(converter.apply(it.next(), locale));
        }
    }

    public static Builder forCode(String code) {
        return new Builder(code);
    }

    public static ResolvableMessage forCodeNoArgs(String code) {
        return new ResolvableMessage(code);
    }

    public static class Builder {
        private final String code;
        private Map<String, Object> argsByName;
        private List<Object> argsByIndex;

        public Builder(String code) {
            this.code = code;
        }

        public Builder arg(String name, Object value) {
            if (this.argsByName == null) {
                this.argsByName = new HashMap<String, Object>();
                this.argsByIndex = new ArrayList<Object>();
            }
            if (name != null) {
                this.argsByName.put(name, value);
            }
            this.argsByIndex.add(value);
            return this;
        }

        public ResolvableMessage build() {
            return new ResolvableMessage(this.code, this.argsByName == null || this.argsByName.isEmpty() ? Collections.emptyMap() : new HashMap<String, Object>(this.argsByName), this.argsByIndex == null || this.argsByIndex.isEmpty() ? Collections.emptyList() : new ArrayList<Object>(this.argsByIndex));
        }
    }
}

