/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages.proxy;

import de.codecamp.messages.proxy.MessageProvider;
import de.codecamp.messages.proxy.MessageProxyInvocationHandler;
import de.codecamp.messages.proxy.NamedArgsMessageProvider;
import de.codecamp.messages.proxy.NamedArgsMessageProxyInvocationHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;

public class MessageProxyUtils {
    public static <T> T createMessageProxy(Class<T> messageProxyIface, MessageProvider messageProvider) {
        if (messageProxyIface == null) {
            throw new IllegalArgumentException("messageProxyIface must not be null");
        }
        MessageProxyInvocationHandler invocationHandler = new MessageProxyInvocationHandler(messageProvider);
        return messageProxyIface.cast(Proxy.newProxyInstance(messageProxyIface.getClassLoader(), new Class[]{messageProxyIface}, (InvocationHandler)invocationHandler));
    }

    public static <T> T createNamedArgsMessageProxy(Class<T> messageProxyIface, NamedArgsMessageProvider messageProvider) {
        if (messageProxyIface == null) {
            throw new IllegalArgumentException("messageProxyIface must not be null");
        }
        NamedArgsMessageProxyInvocationHandler invocationHandler = new NamedArgsMessageProxyInvocationHandler(messageProvider);
        return messageProxyIface.cast(Proxy.newProxyInstance(messageProxyIface.getClassLoader(), new Class[]{messageProxyIface}, (InvocationHandler)invocationHandler));
    }
}

