package de.codecamp.messages;


/**
 * A message key with information about its arguments.
 */
public interface MessageKeyWithArgs
  extends
    MessageKey
{

  /**
   * Returns whether the message key has arguments.
   *
   * @return whether the message key has arguments
   */
  boolean hasArgs();

  /**
   * Returns the types of the message arguments in their declared order.
   *
   * @return the types of the message arguments in their declared order
   */
  String[] getArgTypes();

  /**
   * Returns the names of the message arguments in their declared order. The names may be null if
   * none were declared.
   *
   * @return the names of the message arguments in their declared order
   */
  String[] getArgNames();

}
