/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.messages;

import de.codecamp.messages.ResolvableMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class ResolvableMessageImpl
implements ResolvableMessage {
    private final String code;
    private final Map<String, Object> argsByName;
    private final List<Object> argsByIndex;

    ResolvableMessageImpl(String code) {
        this.code = code;
        this.argsByName = Collections.emptyMap();
        this.argsByIndex = Collections.emptyList();
    }

    ResolvableMessageImpl(String code, Map<String, Object> argsByName, List<Object> argsByIndex) {
        this.code = code;
        this.argsByName = Collections.unmodifiableMap(argsByName);
        this.argsByIndex = Collections.unmodifiableList(argsByIndex);
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public Map<String, Object> getArgsByName() {
        return this.getArgsByName(false);
    }

    @Override
    public Map<String, Object> getArgsByName(boolean includeByIndex) {
        if (!includeByIndex) {
            if (this.argsByName.size() != this.argsByIndex.size()) {
                throw new IllegalStateException("Names aren't available for all message arguments.");
            }
            return this.argsByName;
        }
        HashMap<String, Object> result = new HashMap<String, Object>(this.argsByName);
        for (int i = 0; i < this.argsByIndex.size(); ++i) {
            result.put(Integer.toString(i), this.argsByIndex.get(i));
        }
        return result;
    }

    @Override
    public List<Object> getArgsByIndex() {
        return this.argsByIndex;
    }

    public static Builder forCode(String code) {
        return new Builder(code);
    }

    public static ResolvableMessageImpl forCodeNoArgs(String code) {
        return new ResolvableMessageImpl(code);
    }

    public static class Builder {
        private final String code;
        private Map<String, Object> argsByName;
        private List<Object> argsByIndex;

        public Builder(String code) {
            this.code = code;
        }

        public Builder arg(String name, Object value) {
            if (this.argsByName == null) {
                this.argsByName = new HashMap<String, Object>();
                this.argsByIndex = new ArrayList<Object>();
            }
            if (name != null) {
                this.argsByName.put(name, value);
            }
            this.argsByIndex.add(value);
            return this;
        }

        public ResolvableMessageImpl build() {
            return new ResolvableMessageImpl(this.code, (Map<String, Object>)(this.argsByName == null || this.argsByName.isEmpty() ? Collections.emptyMap() : new HashMap<String, Object>(this.argsByName)), this.argsByIndex == null || this.argsByIndex.isEmpty() ? Collections.emptyList() : new ArrayList<Object>(this.argsByIndex));
        }
    }
}

